/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.web.server.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

final class OidcLogoutServerAuthenticationConverter
implements ServerAuthenticationConverter {
    private static final String DEFAULT_LOGOUT_URI = "/logout/connect/back-channel/{registrationId}";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private ServerWebExchangeMatcher exchangeMatcher = new PathPatternParserServerWebExchangeMatcher("/logout/connect/back-channel/{registrationId}", HttpMethod.POST);

    OidcLogoutServerAuthenticationConverter(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        return this.exchangeMatcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).flatMap(match -> {
            String registrationId = (String)match.getVariables().get("registrationId");
            return this.clientRegistrationRepository.findByRegistrationId(registrationId).switchIfEmpty(Mono.error(() -> {
                this.logger.debug((Object)"Did not process OIDC Back-Channel Logout since no ClientRegistration was found");
                return new OAuth2AuthenticationException("invalid_request");
            }));
        }).flatMap(clientRegistration -> exchange.getFormData().map(data -> {
            String logoutToken = (String)data.getFirst((Object)"logout_token");
            return new OidcLogoutAuthenticationToken(logoutToken, (ClientRegistration)clientRegistration);
        }).switchIfEmpty(Mono.error(() -> {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout since no logout token was found");
            return new OAuth2AuthenticationException("invalid_request");
        })));
    }

    void setExchangeMatcher(ServerWebExchangeMatcher exchangeMatcher) {
        Assert.notNull((Object)exchangeMatcher, (String)"exchangeMatcher cannot be null");
        this.exchangeMatcher = exchangeMatcher;
    }
}

