/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { createReducer, on } from '@ngrx/store';
import { BUNDLED_HEX_VIEWER, BUNDLED_IMAGE_VIEWER, ViewerOptionsState } from './index';
import {
    loadContentViewerOptions,
    loadContentViewerOptionsSuccess,
    resetContentViewerOptions
} from './viewer-options.actions';

export const initialState: ViewerOptionsState = {
    contentViewers: null,
    bundledContentViewers: [BUNDLED_HEX_VIEWER, BUNDLED_IMAGE_VIEWER],
    status: 'pending'
};

export const viewerOptionsReducer = createReducer(
    initialState,
    on(loadContentViewerOptions, (state) => ({
        ...state,
        status: 'loading' as const
    })),
    on(loadContentViewerOptionsSuccess, (state, { response }) => ({
        ...state,
        contentViewers: response.contentViewers,
        status: 'success' as const
    })),
    on(resetContentViewerOptions, () => ({
        ...initialState
    }))
);
