/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.layout.template.json.internal.annotation.SuppressFBWarnings;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public final class Uris {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private Uris() {
    }

    public static String readUri(String spec, Charset charset) {
        Objects.requireNonNull(spec, "spec");
        Objects.requireNonNull(charset, "charset");
        try {
            URI uri = new URI(spec);
            return Uris.unsafeReadUri(uri, charset);
        }
        catch (Exception error) {
            throw new RuntimeException("failed reading URI: " + spec, error);
        }
    }

    public static String readUri(URI uri, Charset charset) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(charset, "charset");
        try {
            return Uris.unsafeReadUri(uri, charset);
        }
        catch (Exception error) {
            throw new RuntimeException("failed reading URI: " + uri, error);
        }
    }

    private static String unsafeReadUri(URI uri, Charset charset) throws Exception {
        String uriScheme;
        switch (uriScheme = Strings.toRootLowerCase((String)uri.getScheme())) {
            case "classpath": {
                return Uris.readClassPathUri(uri, charset);
            }
            case "file": {
                return Uris.readFileUri(uri, charset);
            }
        }
        throw new IllegalArgumentException("unknown scheme in URI: " + uri);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The uri parameter comes from aconfiguration file.")
    private static String readFileUri(URI uri, Charset charset) throws IOException {
        Path path = Paths.get(uri);
        try (BufferedReader fileReader = Files.newBufferedReader(path, charset);){
            String string = Uris.consumeReader(fileReader);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The uri parameter comes fro a configuration file.")
    private static String readClassPathUri(URI uri, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String consumeReader(BufferedReader reader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }
}

