/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.etcd;

import com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$ServiceNode$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011-c\u0001\u00020`\u00011D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u0006}\u0002!\ta \u0004\u0007\u0003\u000f\u0001\u0001)!\u0003\t\u0015\u0005]1A!f\u0001\n\u0003\tI\u0002\u0003\u0006\u00022\r\u0011\t\u0012)A\u0005\u00037A!\"a\r\u0004\u0005+\u0007I\u0011AA\u001b\u0011)\tid\u0001B\tB\u0003%\u0011q\u0007\u0005\u0007}\u000e!\t!a\u0010\t\u0013\u0005%3!!A\u0005\u0002\u0005-\u0003\"CA)\u0007E\u0005I\u0011AA*\u0011%\tIgAI\u0001\n\u0003\tY\u0007C\u0005\u0002p\r\t\t\u0011\"\u0011\u0002r!I\u0011\u0011Q\u0002\u0002\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u0017\u001b\u0011\u0011!C\u0001\u0003\u001bC\u0011\"!'\u0004\u0003\u0003%\t%a'\t\u0013\u0005%6!!A\u0005\u0002\u0005-\u0006\"CA[\u0007\u0005\u0005I\u0011IA\\\u0011%\tIlAA\u0001\n\u0003\nY\fC\u0005\u0002>\u000e\t\t\u0011\"\u0011\u0002@\u001eI\u00111\u0019\u0001\u0002\u0002#\u0005\u0011Q\u0019\u0004\n\u0003\u000f\u0001\u0011\u0011!E\u0001\u0003\u000fDaA`\u000b\u0005\u0002\u0005U\u0007\"CA]+\u0005\u0005IQIA^\u0011%\t9.FA\u0001\n\u0003\u000bI\u000eC\u0005\u0002`V\t\t\u0011\"!\u0002b\"Q!\r\u0001a\u0001\u0002\u0004%\t!a=\t\u0017\t\u001d\u0001\u00011AA\u0002\u0013\u0005!\u0011\u0002\u0005\f\u0005'\u0001\u0001\u0019!A!B\u0013\t)\u0010C\u0006\u0003\u001e\u0001\u0001\r\u00111A\u0005\u0002\t}\u0001b\u0003B\u0014\u0001\u0001\u0007\t\u0019!C\u0001\u0005SA1B!\f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\"!Y!\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011\u0001B\u001a\u0011-\u0011Y\u0004\u0001a\u0001\u0002\u0004%\tA!\u0010\t\u0017\t\u0005\u0003\u00011A\u0001B\u0003&!Q\u0007\u0005\f\u0005\u000b\u0002\u0001\u0019!a\u0001\n\u0003\u00119\u0005C\u0006\u0003P\u0001\u0001\r\u00111A\u0005\u0002\tE\u0003b\u0003B+\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0013B1B!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\\!Y!Q\f\u0001A\u0002\u0003\u0007I\u0011\u0001B0\u0011-\u0011\u0019\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0011\t\u0017\t\u001d\u0004\u00011AA\u0002\u0013\u0005\u0011Q\u0007\u0005\f\u0005S\u0002\u0001\u0019!a\u0001\n\u0003\u0011Y\u0007C\u0006\u0003p\u0001\u0001\r\u0011!Q!\n\u0005]\u0002b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005o\u0002A\u0011\tB=\u0011\u001d\u0011Y\b\u0001C!\u0005sBqA! \u0001\t\u0003\u0012y\bC\u0005\u0003\f\u0002\t\n\u0011\"\u0001\u0003\u000e\"9!\u0011\u0013\u0001\u0005B\tM\u0005b\u0002BR\u0001\u0011\u0005#Q\u0015\u0005\b\u0005[\u0003A\u0011\tBX\u0011\u001d\u0011)\r\u0001C!\u0005\u000fDqAa3\u0001\t\u0003\u0012i\rC\u0005\u0003V\u0002\t\n\u0011\"\u0001\u0003\u000e\"9!q\u001b\u0001\u0005B\te\u0007\"\u0003Bq\u0001E\u0005I\u0011\u0001BG\u0011\u001d\u0011\u0019\u000f\u0001C!\u0005KDqA!=\u0001\t\u0003\u0012\u0019\u0010C\u0004\u0004\u001c\u0001!\te!\b\t\u000f\r\u001d\u0002\u0001\"\u0011\u0004*!91\u0011\u0007\u0001\u0005B\rM\u0002\"CB'\u0001E\u0005I\u0011AB(\u0011%\u0019\u0019\u0006AI\u0001\n\u0003\u0011i\tC\u0004\u0004V\u0001!\tea\u0016\t\u0013\r%\u0004!%A\u0005\u0002\r-\u0004\"CB8\u0001E\u0005I\u0011\u0001BG\u0011\u001d\u0019\t\b\u0001C!\u0005sBqaa\u001d\u0001\t\u0003\u001a)\bC\u0004\u0004z\u0001!\tea\u001f\t\u0013\r%\u0005!%A\u0005\u0002\r-\u0004\"CBF\u0001E\u0005I\u0011\u0001BG\u0011\u001d\u0019i\t\u0001C!\u0007\u001fC\u0011ba/\u0001#\u0003%\tA!$\t\u000f\ru\u0006\u0001\"\u0011\u0004@\"I1q\u0019\u0001\u0012\u0002\u0013\u00051\u0011\u001a\u0005\b\u0007\u001b\u0004A\u0011BBh\u0011%\u0019)\u000fAI\u0001\n\u0013\u0019Y\u0007C\u0005\u0004h\u0002\t\n\u0011\"\u0003\u0003\u000e\"I1\u0011\u001e\u0001\u0012\u0002\u0013%11\u001e\u0004\u0007\u0007_\u0004\u0001a!=\t\u0015\r\r\u0005K!A!\u0002\u0013\tY\u0002\u0003\u0006\u0003jB\u0013\t\u0011)A\u0005\u0005WDaA )\u0005\u0002\u0011\u001d\u0001b\u0002C\b!\u0012\u0005C\u0011\u0003\u0005\b\tG\u0001F\u0011\tC\u0013\u0011\u001d!\t\u0004\u0015C!\u0005s:q\u0001b\r`\u0011\u0003!)D\u0002\u0004_?\"\u0005Aq\u0007\u0005\u0007}b#\t\u0001\"\u000f\t\u0013\u0011m\u0002L1A\u0005\u000e\u0005U\u0002\u0002\u0003C\u001f1\u0002\u0006i!a\u000e\t\u0015\u0011}\u0002L1A\u0005\u0006}#\t\u0005\u0003\u0005\u0005Ja\u0003\u000bQ\u0002C\"\u0005M)Eo\u00193ESN\u001cwN^3ss\u000ec\u0017.\u001a8u\u0015\t\u0001\u0017-\u0001\u0003fi\u000e$'B\u00012d\u0003\u0019\u0019G.[3oi*\u0011A-Z\u0001\u0003Q\u0006T!AZ4\u0002\r-LX/\u001e2j\u0015\tA\u0017.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0006\u0019qN]4\u0004\u0001M\u0019\u0001!\\:\u0011\u00059\fX\"A8\u000b\u0003A\fQa]2bY\u0006L!A]8\u0003\r\u0005s\u0017PU3g!\t!X/D\u0001b\u0013\t1\u0018MA\bESN\u001cwN^3ss\u000ec\u0017.\u001a8u\u0003\u0011\u0019wN\u001c4\u0011\u0005edX\"\u0001>\u000b\u0005m,\u0017AB2p]\u001aLw-\u0003\u0002~u\nQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\u0011\t\t!!\u0002\u0011\u0007\u0005\r\u0001!D\u0001`\u0011\u00159(\u00011\u0001y\u0005-\u0019VM\u001d<jG\u0016tu\u000eZ3\u0014\r\ri\u00171BA\t!\rq\u0017QB\u0005\u0004\u0003\u001fy'a\u0002)s_\u0012,8\r\u001e\t\u0004]\u0006M\u0011bAA\u000b_\na1+\u001a:jC2L'0\u00192mK\u0006!\u0001/\u0019;i+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003O\u00012!!\tp\u001b\t\t\u0019CC\u0002\u0002&-\fa\u0001\u0010:p_Rt\u0014bAA\u0015_\u00061\u0001K]3eK\u001aLA!!\f\u00020\t11\u000b\u001e:j]\u001eT1!!\u000bp\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0015aW-Y:f+\t\t9\u0004E\u0002o\u0003sI1!a\u000fp\u0005\u0011auN\\4\u0002\r1,\u0017m]3!)\u0019\t\t%!\u0012\u0002HA\u0019\u00111I\u0002\u000e\u0003\u0001Aq!a\u0006\t\u0001\u0004\tY\u0002C\u0004\u00024!\u0001\r!a\u000e\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0003\ni%a\u0014\t\u0013\u0005]\u0011\u0002%AA\u0002\u0005m\u0001\"CA\u001a\u0013A\u0005\t\u0019AA\u001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0016+\t\u0005m\u0011qK\u0016\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005v]\u000eDWmY6fI*\u0019\u00111M8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002h\u0005u#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA7U\u0011\t9$a\u0016\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\nAA[1wC&!\u0011QFA<\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\tE\u0002o\u0003\u000fK1!!#p\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty)!&\u0011\u00079\f\t*C\u0002\u0002\u0014>\u00141!\u00118z\u0011%\t9JDA\u0001\u0002\u0004\t))A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003;\u0003b!a(\u0002&\u0006=UBAAQ\u0015\r\t\u0019k\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAT\u0003C\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QVAZ!\rq\u0017qV\u0005\u0004\u0003c{'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003/\u0003\u0012\u0011!a\u0001\u0003\u001f\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\na!Z9vC2\u001cH\u0003BAW\u0003\u0003D\u0011\"a&\u0014\u0003\u0003\u0005\r!a$\u0002\u0017M+'O^5dK:{G-\u001a\t\u0004\u0003\u0007*2#B\u000b\u0002J\u0006E\u0001CCAf\u0003#\fY\"a\u000e\u0002B5\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f|\u0017a\u0002:v]RLW.Z\u0005\u0005\u0003'\fiMA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\u0005\u00131\\Ao\u0011\u001d\t9\u0002\u0007a\u0001\u00037Aq!a\r\u0019\u0001\u0004\t9$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0018q\u001e\t\u0006]\u0006\u0015\u0018\u0011^\u0005\u0004\u0003O|'AB(qi&|g\u000eE\u0004o\u0003W\fY\"a\u000e\n\u0007\u00055xN\u0001\u0004UkBdWM\r\u0005\n\u0003cL\u0012\u0011!a\u0001\u0003\u0003\n1\u0001\u001f\u00131+\t\t)\u0010\u0005\u0003\u0002x\n\rQBAA}\u0015\u0011\tY0!@\u0002\u000b),Go\u00193\u000b\u0007\u0001\fyP\u0003\u0002\u0003\u0002\u0005\u0011\u0011n\\\u0005\u0005\u0005\u000b\tIP\u0001\u0004DY&,g\u000e^\u0001\u000bG2LWM\u001c;`I\u0015\fH\u0003\u0002B\u0006\u0005#\u00012A\u001cB\u0007\u0013\r\u0011ya\u001c\u0002\u0005+:LG\u000fC\u0005\u0002\u0018n\t\t\u00111\u0001\u0002v\u000691\r\\5f]R\u0004\u0003f\u0001\u000f\u0003\u0018A\u0019aN!\u0007\n\u0007\tmqN\u0001\u0005w_2\fG/\u001b7f\u0003!Ygo\u00117jK:$XC\u0001B\u0011!\u0011\t9Pa\t\n\t\t\u0015\u0012\u0011 \u0002\u0003\u0017Z\u000bAb\u001b<DY&,g\u000e^0%KF$BAa\u0003\u0003,!I\u0011q\u0013\u0010\u0002\u0002\u0003\u0007!\u0011E\u0001\nWZ\u001cE.[3oi\u0002B3a\bB\f\u0003)awnY6DY&,g\u000e^\u000b\u0003\u0005k\u0001B!a>\u00038%!!\u0011HA}\u0005\u0011aunY6\u0002\u001d1|7m[\"mS\u0016tGo\u0018\u0013fcR!!1\u0002B \u0011%\t9*IA\u0001\u0002\u0004\u0011)$A\u0006m_\u000e\\7\t\\5f]R\u0004\u0003f\u0001\u0012\u0003\u0018\u0005YA.Z1tK\u000ec\u0017.\u001a8u+\t\u0011I\u0005\u0005\u0003\u0002x\n-\u0013\u0002\u0002B'\u0003s\u0014Q\u0001T3bg\u0016\fq\u0002\\3bg\u0016\u001cE.[3oi~#S-\u001d\u000b\u0005\u0005\u0017\u0011\u0019\u0006C\u0005\u0002\u0018\u0012\n\t\u00111\u0001\u0003J\u0005aA.Z1tK\u000ec\u0017.\u001a8uA!\u001aQEa\u0006\u0002\u0017M,'O^5dK:{G-Z\u000b\u0003\u0003\u0003\nqb]3sm&\u001cWMT8eK~#S-\u001d\u000b\u0005\u0005\u0017\u0011\t\u0007C\u0005\u0002\u0018\u001e\n\t\u00111\u0001\u0002B\u0005a1/\u001a:wS\u000e,gj\u001c3fA!\u001a\u0001Fa\u0006\u0002\u00111,\u0017m]3U)2\u000bA\u0002\\3bg\u0016$F\u000bT0%KF$BAa\u0003\u0003n!I\u0011q\u0013\u0016\u0002\u0002\u0003\u0007\u0011qG\u0001\nY\u0016\f7/\u001a+U\u0019\u0002B3a\u000bB\f\u0003-\u0011W/\u001b7e\u00072LWM\u001c;\u0015\u0005\u0005U\u0018\u0001D2sK\u0006$Xm\u00117jK:$HC\u0001B\u0006\u0003-\u0019Gn\\:f\u00072LWM\u001c;\u0002\r\r\u0014X-\u0019;f)!\tYB!!\u0003\u0004\n\u001d\u0005bBA\f_\u0001\u0007\u00111\u0004\u0005\b\u0005\u000b{\u0003\u0019AA\u000e\u0003\u0011iw\u000eZ3\t\u0013\t%u\u0006%AA\u0002\u00055\u0016\u0001D2sK\u0006$X\rU1sK:$\u0018\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yI\u000b\u0003\u0002.\u0006]\u0013aB4fi\u0012\u000bG/\u0019\u000b\u0005\u0005+\u0013\t\u000bE\u0003o\u0005/\u0013Y*C\u0002\u0003\u001a>\u0014Q!\u0011:sCf\u00042A\u001cBO\u0013\r\u0011yj\u001c\u0002\u0005\u0005f$X\rC\u0004\u0002\u0018E\u0002\r!a\u0007\u0002\u000fM,G\u000fR1uCR1\u0011Q\u0016BT\u0005SCq!a\u00063\u0001\u0004\tY\u0002C\u0004\u0003,J\u0002\rA!&\u0002\t\u0011\fG/Y\u0001\fO\u0016$8\t[5mIJ,g\u000e\u0006\u0003\u00032\n\r\u0007C\u0002BZ\u0005{\u000bYB\u0004\u0003\u00036\nef\u0002BA\u0011\u0005oK\u0011\u0001]\u0005\u0004\u0005w{\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u007f\u0013\tM\u0001\u0003MSN$(b\u0001B^_\"9\u0011qC\u001aA\u0002\u0005m\u0011A\u00039bi\",\u00050[:ugR!\u0011Q\u0016Be\u0011\u001d\t9\u0002\u000ea\u0001\u00037\tQ\u0002]1uQ:{g.\u0012=jgR\u001cHCBAW\u0005\u001f\u0014\t\u000eC\u0004\u0002\u0018U\u0002\r!a\u0007\t\u0013\tMW\u0007%AA\u0002\u00055\u0016\u0001C5t!J,g-\u001b=\u0002/A\fG\u000f\u001b(p]\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012\u0014A\u00023fY\u0016$X\r\u0006\u0004\u0003\f\tm'Q\u001c\u0005\b\u0003/9\u0004\u0019AA\u000e\u0011%\u0011yn\u000eI\u0001\u0002\u0004\ti+\u0001\beK2,G/Z\"iS2$'/\u001a8\u0002!\u0011,G.\u001a;fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D7p]&$xN]*uCR,G\u0003\u0002B\u0006\u0005ODqA!;:\u0001\u0004\u0011Y/\u0001\ttKJ4\u0018nY3ESN\u001cwN^3ssB\u0019AO!<\n\u0007\t=\u0018M\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u0006YAO]=XSRDGj\\2l+\u0011\u0011)P!@\u0015\r\t]81CB\f)\u0011\u0011Ip!\u0003\u0011\t\tm(Q \u0007\u0001\t\u001d\u0011yP\u000fb\u0001\u0007\u0003\u0011\u0011\u0001V\t\u0005\u0007\u0007\ty\tE\u0002o\u0007\u000bI1aa\u0002p\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001ba\u0003;\t\u0003\u00071QB\u0001\u0002MB)ana\u0004\u0003z&\u00191\u0011C8\u0003\u0011q\u0012\u0017P\\1nKzBqa!\u0006;\u0001\u0004\tY\"\u0001\u0005m_\u000e\\\u0007+\u0019;i\u0011\u001d\u0019IB\u000fa\u0001\u0003o\tq\u0001^5nK>,H/A\u0007hKR\u001cVM\u001d<fe\"{7\u000f\u001e\u000b\u0005\u0007?\u0019\u0019\u0003E\u0003o\u0003K\u001c\t\u0003E\u0004o\u0003W\fY\"!\"\t\u000f\r\u00152\b1\u0001\u0002\u001c\u0005Ia.Y7fgB\f7-Z\u0001\u0011O\u0016$XI\\4j]\u0016\u0014\u0015PU3g\u0013\u0012$baa\b\u0004,\r5\u0002bBB\u0013y\u0001\u0007\u00111\u0004\u0005\b\u0007_a\u0004\u0019AA\u000e\u0003-)gnZ5oKJ+g-\u00133\u0002'\u001d,GoU3sm&\u001cWMT8eKNLeNZ8\u0015\u0011\rU2\u0011IB\"\u0007\u0013\u0002bAa-\u00048\rm\u0012\u0002BB\u001d\u0005\u0003\u00141aU3r!\r!8QH\u0005\u0004\u0007\u007f\t'aD*feZL7-\u001a(pI\u0016LeNZ8\t\u000f\r\u0015R\b1\u0001\u0002\u001c!I1QI\u001f\u0011\u0002\u0003\u00071qI\u0001\bg&TXm\u00149u!\u0015q\u0017Q]AC\u0011%\u0019Y%\u0010I\u0001\u0002\u0004\ti+\u0001\u0004tS2,g\u000e^\u0001\u001eO\u0016$8+\u001a:wS\u000e,gj\u001c3fg&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u000b\u0016\u0005\u0007\u000f\n9&A\u000fhKR\u001cVM\u001d<jG\u0016tu\u000eZ3t\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003=\u0011XmZ5ti\u0016\u00148+\u001a:wS\u000e,G\u0003\u0004B\u0006\u00073\u001aYf!\u0018\u0004`\r\u0015\u0004\"B<A\u0001\u0004A\bbBB\u0013\u0001\u0002\u0007\u00111\u0004\u0005\b\u0005S\u0004\u0005\u0019\u0001Bv\u0011%\u0019\t\u0007\u0011I\u0001\u0002\u0004\u0019\u0019'A\u0004wKJ\u001c\u0018n\u001c8\u0011\u000b9\f)/a\u0007\t\u0013\r\u001d\u0004\t%AA\u0002\u00055\u0016\u0001C3yi\u0016\u0014h.\u00197\u00023I,w-[:uKJ\u001cVM\u001d<jG\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007[RCaa\u0019\u0002X\u0005I\"/Z4jgR,'oU3sm&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003E!WM]3hSN$XM]*feZL7-Z\u0001\u0016a>\u001cH\u000fR3sK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\u0011\tika\u001e\t\u000f\r\u0015B\t1\u0001\u0002\u001c\u000592M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u000b\r\u00037\u0019iha \u0004\u0002\u000e\u00155q\u0011\u0005\u0006o\u0016\u0003\r\u0001\u001f\u0005\b\u0007K)\u0005\u0019AA\u000e\u0011\u001d\u0019\u0019)\u0012a\u0001\u00037\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\n\u0007C*\u0005\u0013!a\u0001\u0007GB\u0011ba\u001aF!\u0003\u0005\r!!,\u0002C\r\u0014X-\u0019;f\u0003:$w)\u001a;TKJ4\u0018nY3O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002C\r\u0014X-\u0019;f\u0003:$w)\u001a;TKJ4\u0018nY3O_\u0012,G\u0005Z3gCVdG\u000fJ\u001b\u0002\u001fM$\u0018M\u001d;TK\u000e\u0014X\r\u001e(pI\u0016$\"Ba\u0003\u0004\u0012\u000eU5\u0011TBO\u0011\u001d\u0019\u0019\n\u0013a\u0001\u00037\t!b\u0019:fCR,Wj\u001c3f\u0011\u001d\u00199\n\u0013a\u0001\u00037\t\u0001BY1tKB\u000bG\u000f\u001b\u0005\b\u00077C\u0005\u0019AA\u000e\u0003!Ig.\u001b;ECR\f\u0007\"CBP\u0011B\u0005\t\u0019AAW\u00035)8/\u001a)s_R,7\r^5p]\"\u001a\u0001ja)\u0011\t\r\u00156qW\u0007\u0003\u0007OSAa!+\u0004,\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\u0019ika,\u0002\r\r|W.\\8o\u0015\u0011\u0019\tla-\u0002\r\u001d|wn\u001a7f\u0015\t\u0019),A\u0002d_6LAa!/\u0004(\n\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u00023M$\u0018M\u001d;TK\u000e\u0014X\r\u001e(pI\u0016$C-\u001a4bk2$H\u0005N\u0001\u0010O\u0016$\u0018I\u001c3J]\u000e\u0014X-\\3oiR1\u0011QQBa\u0007\u0007Dq!a\u0006K\u0001\u0004\tY\u0002C\u0005\u0004F*\u0003\n\u00111\u0001\u0002\u0006\u0006)A-\u001a7uC\u0006Ir-\u001a;B]\u0012Len\u0019:f[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YM\u000b\u0003\u0002\u0006\u0006]\u0013\u0001F2sK\u0006$X\rU3sg&\u001cH/\u001a8u\u001d>$W\r\u0006\b\u0002B\rE71[Bk\u0007/\u001cIna7\t\u000b]d\u0005\u0019\u0001=\t\u000f\r\u0015B\n1\u0001\u0002\u001c!911\u0011'A\u0002\u0005m\u0001\"CB1\u0019B\u0005\t\u0019AB2\u0011%\u00199\u0007\u0014I\u0001\u0002\u0004\ti\u000bC\u0005\u0004^2\u0003\n\u00111\u0001\u0004`\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0011\u0011\u0005u1\u0011]A\u000e\u00037IAaa9\u00020\t\u0019Q*\u00199\u0002=\r\u0014X-\u0019;f!\u0016\u00148/[:uK:$hj\u001c3fI\u0011,g-Y;mi\u0012\"\u0014AH2sK\u0006$X\rU3sg&\u001cH/\u001a8u\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00136\u0003y\u0019'/Z1uKB+'o]5ti\u0016tGOT8eK\u0012\"WMZ1vYR$c'\u0006\u0002\u0004n*\"1q\\A,\u0005E!UMU3hSN$XM],bi\u000eDWM]\n\u0006!\u000eM8\u0011 \t\u0005\u0003k\u001a)0\u0003\u0003\u0004x\u0006]$AB(cU\u0016\u001cG\u000f\u0005\u0003\u0004|\u0012\u0005a\u0002BA|\u0007{LAaa@\u0002z\u0006)q+\u0019;dQ&!A1\u0001C\u0003\u0005!a\u0015n\u001d;f]\u0016\u0014(\u0002BB\u0000\u0003s$b\u0001\"\u0003\u0005\f\u00115\u0001cAA\"!\"911Q*A\u0002\u0005m\u0001b\u0002Bu'\u0002\u0007!1^\u0001\u0007_:tU\r\u001f;\u0015\t\t-A1\u0003\u0005\b\t+!\u0006\u0019\u0001C\f\u000359\u0018\r^2i%\u0016\u001c\bo\u001c8tKB!A\u0011\u0004C\u0010\u001b\t!YB\u0003\u0003\u0005\u001e\u0005e\u0018!B<bi\u000eD\u0017\u0002\u0002C\u0011\t7\u0011QbV1uG\"\u0014Vm\u001d9p]N,\u0017aB8o\u000bJ\u0014xN\u001d\u000b\u0005\u0005\u0017!9\u0003C\u0004\u0005*U\u0003\r\u0001b\u000b\u0002\u0013QD'o\\<bE2,\u0007\u0003\u0002BZ\t[IA\u0001b\f\u0003B\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\f_:\u001cu.\u001c9mKR,G-A\nFi\u000e$G)[:d_Z,'/_\"mS\u0016tG\u000fE\u0002\u0002\u0004a\u001b\"\u0001W7\u0015\u0005\u0011U\u0012\u0001\u0005'F\u0003N+uLT+M\u0019~3\u0016\tT+F\u0003EaU)Q*F?:+F\nT0W\u00032+V\tI\u0001\u0011\u0019>\u001b5j\u0018)B)\"{6+\u0016$G\u0013b+\"\u0001b\u0011\u0010\u0005\u0011\u0015\u0013E\u0001C$\u0003\u0015yCn\\2l\u0003EaujQ&`!\u0006#\u0006jX*V\r\u001aK\u0005\f\t")
public class EtcdDiscoveryClient
implements DiscoveryClient {
    private volatile EtcdDiscoveryClient$ServiceNode$ ServiceNode$module;
    private final KyuubiConf conf;
    private volatile Client client;
    private volatile KV kvClient;
    private volatile Lock lockClient;
    private volatile Lease leaseClient;
    private volatile ServiceNode serviceNode;
    private volatile long leaseTTL;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public EtcdDiscoveryClient$ServiceNode$ ServiceNode() {
        if (this.ServiceNode$module == null) {
            this.ServiceNode$lzycompute$1();
        }
        return this.ServiceNode$module;
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public KV kvClient() {
        return this.kvClient;
    }

    public void kvClient_$eq(KV x$1) {
        this.kvClient = x$1;
    }

    public Lock lockClient() {
        return this.lockClient;
    }

    public void lockClient_$eq(Lock x$1) {
        this.lockClient = x$1;
    }

    public Lease leaseClient() {
        return this.leaseClient;
    }

    public void leaseClient_$eq(Lease x$1) {
        this.leaseClient = x$1;
    }

    public ServiceNode serviceNode() {
        return this.serviceNode;
    }

    public void serviceNode_$eq(ServiceNode x$1) {
        this.serviceNode = x$1;
    }

    public long leaseTTL() {
        return this.leaseTTL;
    }

    public void leaseTTL_$eq(long x$1) {
        this.leaseTTL = x$1;
    }

    private Client buildClient() {
        String[] endpoints = ((String)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES())).split(",");
        boolean sslEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_ENABLED()));
        if (!sslEnabled) {
            return Client.builder().endpoints(endpoints).build();
        }
        String caPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).append(" is not defined").toString());
        });
        String crtPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).append(" is not defined").toString());
        });
        String keyPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).append(" is not defined").toString());
        });
        SslContext context = GrpcSslContexts.forClient().trustManager(new File(caPath)).keyManager(new File(crtPath), new File(keyPath)).build();
        return Client.builder().endpoints(endpoints).sslContext(context).build();
    }

    @Override
    public void createClient() {
        this.client_$eq(this.buildClient());
        this.kvClient_$eq(this.client().getKVClient());
        this.lockClient_$eq(this.client().getLockClient());
        this.leaseClient_$eq(this.client().getLeaseClient());
        this.leaseTTL_$eq(BoxesRunTime.unboxToLong((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_LEASE_TIMEOUT())) / 1000L);
    }

    @Override
    public void closeClient() {
        if (this.client() != null) {
            this.client().close();
            return;
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        String string = mode;
        if (!"PERSISTENT".equals(string)) {
            throw new KyuubiException(new StringBuilder(36).append("Create mode ").append(string).append(" is not support in etcd!").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        PutResponse cfr_ignored_0 = (PutResponse)this.kvClient().put(ByteSequence.from((byte[])path.getBytes()), ByteSequence.from((byte[])path.getBytes())).get();
        return path;
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        GetResponse response = (GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes())).get();
        if (response.getKvs().isEmpty()) {
            throw new KyuubiException(new StringBuilder(42).append("Key[").append(path).append("] not exists in ETCD, please check it.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((KeyValue)response.getKvs().get(0)).getValue().getBytes();
    }

    @Override
    public boolean setData(String path, byte[] data) {
        PutResponse response = (PutResponse)this.kvClient().put(ByteSequence.from((byte[])path.getBytes()), ByteSequence.from((byte[])data)).get();
        return response != null;
    }

    @Override
    public List<String> getChildren(String path) {
        java.util.List kvs = ((GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes()), GetOption.newBuilder().isPrefix(true).build()).get()).getKvs();
        if (kvs.isEmpty()) {
            return List$.MODULE$.empty();
        }
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(kvs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(kv.getKey().toString(StandardCharsets.UTF_8))).stripPrefix(path))).stripPrefix("/"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getChildren$2(key)))).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return !this.pathNonExists(path, this.pathNonExists$default$2());
    }

    @Override
    public boolean pathNonExists(String path, boolean isPrefix) {
        return ((GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes()), GetOption.newBuilder().isPrefix(isPrefix).build()).get()).getKvs().isEmpty();
    }

    @Override
    public boolean pathNonExists$default$2() {
        return true;
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        this.kvClient().delete(ByteSequence.from((byte[])path.getBytes()), DeleteOption.newBuilder().isPrefix(deleteChildren).build()).get();
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        long leaseTime = timeout / 1000L + 3L;
        long leaseId = ((LeaseGrantResponse)this.leaseClient().grant(leaseTime).get()).getID();
        try {
            try {
                this.lockClient().lock(ByteSequence.from((byte[])lockPath.getBytes()), leaseId).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), (Throwable)e);
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                this.lockClient().unlock(ByteSequence.from((byte[])lockPath.getBytes())).get();
                this.leaseClient().revoke(leaseId).get();
            }
            catch (Exception e) {
                throw new KyuubiException(e.getMessage(), e.getCause());
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.lockClient().unlock(ByteSequence.from((byte[])lockPath.getBytes())).get();
            this.leaseClient().revoke(leaseId).get();
        }
        catch (Exception e) {
            throw new KyuubiException(e.getMessage(), e.getCause());
        }
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            return new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            List<String> hosts = this.getChildren(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)hosts.takeRight(size).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = DiscoveryPaths$.MODULE$.makePath(namespace, (String)p, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                String instance = new String(this.getData(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                String host2 = (String)tuple22._1();
                int port2 = tuple22._2$mcI$sp();
                Map attributes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getServiceNodesInfo$4(x$5))))).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Option version = attributes.get((Object)"version");
                Option engineRefId = attributes.get((Object)"refId");
                String engineIdStr = (String)attributes.get((Object)"kyuubi.engine.id").map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(11).append(" engine id:").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(engineIdStr).append(" and version:").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" ").append("under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId, (Map<String, String>)attributes);
            }, List$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        DeRegisterWatcher watcher = new DeRegisterWatcher(this, instance, serviceDiscovery);
        this.serviceNode_$eq(this.createPersistentNode(conf, namespace, instance, version, external, (Map<String, String>)serviceDiscovery.fe().attributes()));
        this.client().getWatchClient().watch(ByteSequence.from((byte[])this.serviceNode().path().getBytes()), (Watch.Listener)watcher);
        if (this.pathNonExists(this.serviceNode().path(), this.pathNonExists$default$2())) {
            throw new KyuubiException(new StringBuilder(61).append("Unable to create keyValue for this Kyuubi ").append("instance[").append(instance).append("] on ETCD.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        if (this.serviceNode() != null) {
            if (this.serviceNode().lease() != EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE()) {
                this.client().getLeaseClient().revoke(this.serviceNode().lease());
                this.delete(this.serviceNode().path(), this.delete$default$2());
            }
            this.serviceNode_$eq(null);
            return;
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        if (namespace != null) {
            this.delete(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), true);
            return true;
        }
        return false;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external, this.createPersistentNode$default$6()).path();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        this.client().getKVClient().put(ByteSequence.from((byte[])basePath.getBytes()), ByteSequence.from((byte[])initData.getBytes())).get();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    @Override
    public int getAndIncrement(String path, int delta) {
        String lockPath = new StringBuilder(13).append(path).append("_tmp_for_lock").toString();
        return BoxesRunTime.unboxToInt(this.tryWithLock(lockPath, 60000L, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.pathNonExists(path, false)) {
                this.create(path, "PERSISTENT", this.create$default$3());
                object = BoxesRunTime.boxToBoolean((boolean)this.setData(path, String.valueOf(0).getBytes()));
            } else {
                object = BoxedUnit.UNIT;
            }
            int s = new StringOps(Predef$.MODULE$.augmentString(new String(this.getData(path)))).toInt();
            this.setData(path, String.valueOf(s + delta).getBytes());
            return s;
        }));
    }

    @Override
    public int getAndIncrement$default$2() {
        return 1;
    }

    private ServiceNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external, Map<String, String> attributes) {
        String ns = DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.create(ns, "PERSISTENT", this.create$default$3());
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraInfo = ((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(";", ";", "");
        String pathPrefix = DiscoveryPaths$.MODULE$.makePath(namespace, new StringBuilder(29).append("serverUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(new StringOps(Predef$.MODULE$.augmentString(extraInfo)).stripSuffix(";")).append(";").append(session).append("sequence=").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String znode = instance;
        LongRef leaseId = LongRef.create((long)EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE());
        ObjectRef realPath = ObjectRef.create(null);
        long timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.tryWithLock(new StringBuilder(5).append(ns).append("/lock").toString(), timeout, (Function0 & Serializable & scala.Serializable)() -> {
            List instances = (List)this.getChildren(pathPrefix).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)EtcdDiscoveryClient.$anonfun$createPersistentNode$6(pathPrefix, x$7)), List$.MODULE$.canBuildFrom());
            long sequence = instances.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)instances.max((Ordering)Ordering.Long$.MODULE$)) + 1L;
            realPath$1.elem = new StringBuilder(0).append(pathPrefix).append(new StringOps(Predef$.MODULE$.augmentString("%010d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sequence)}))).toString();
            if (external) {
                return (PutResponse)this.client().getKVClient().put(ByteSequence.from((byte[])((String)realPath$1.elem).getBytes()), ByteSequence.from((byte[])znode.getBytes())).get();
            }
            leaseId$1.elem = ((LeaseGrantResponse)this.client().getLeaseClient().grant(this.leaseTTL()).get()).getID();
            this.client().getLeaseClient().keepAlive(leaseId$1.elem, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(null){

                public void onNext(LeaseKeepAliveResponse v) {
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
            return (PutResponse)this.client().getKVClient().put(ByteSequence.from((byte[])((String)realPath$1.elem).getBytes()), ByteSequence.from((byte[])znode.getBytes()), PutOption.newBuilder().withLeaseId(leaseId$1.elem).build()).get();
        });
        return new ServiceNode(this, (String)realPath.elem, leaseId.elem);
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private Map<String, String> createPersistentNode$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void ServiceNode$lzycompute$1() {
        EtcdDiscoveryClient etcdDiscoveryClient = this;
        synchronized (etcdDiscoveryClient) {
            if (this.ServiceNode$module == null) {
                this.ServiceNode$module = new EtcdDiscoveryClient$ServiceNode$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getChildren$2(String key) {
        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && !key.startsWith("lock");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodesInfo$4(String[] x$5) {
        return x$5.length == 2;
    }

    public static final /* synthetic */ long $anonfun$createPersistentNode$6(String pathPrefix$1, String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix(pathPrefix$1))).toLong();
    }

    public EtcdDiscoveryClient(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
    }

    public class DeRegisterWatcher
    implements Watch.Listener {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public void onNext(WatchResponse watchResponse) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(watchResponse.getEvents()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeRegisterWatcher.$anonfun$onNext$1(x$8)))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                DeRegisterWatcher.$anonfun$onNext$2(this, x$9);
                return BoxedUnit.UNIT;
            });
        }

        public void onError(Throwable throwable) {
            throw new KyuubiException(throwable.getMessage(), throwable.getCause());
        }

        public void onCompleted() {
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent x$8) {
            WatchEvent.EventType eventType = x$8.getEventType();
            WatchEvent.EventType eventType2 = WatchEvent.EventType.DELETE;
            return !(eventType != null ? !eventType.equals(eventType2) : eventType2 != null);
        }

        public static final /* synthetic */ void $anonfun$onNext$2(DeRegisterWatcher $this, WatchEvent x$9) {
            $this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("This Kyuubi instance ").append($this.instance).append(" is now de-registered from").append(" ETCD. The server will be shut down after the last client session completes.").toString());
            ThreadUtils$.MODULE$.runInNewThread("deregister-watcher-thread", false, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.serviceDiscovery.stopGracefully($this.serviceDiscovery.stopGracefully$default$1()));
        }

        public DeRegisterWatcher(EtcdDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class ServiceNode
    implements Product,
    scala.Serializable {
        private final String path;
        private final long lease;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public String path() {
            return this.path;
        }

        public long lease() {
            return this.lease;
        }

        public ServiceNode copy(String path, long lease) {
            return new ServiceNode(this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer(), path, lease);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.lease();
        }

        public String productPrefix() {
            return "ServiceNode";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.lease());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServiceNode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lease()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ServiceNode)) return false;
            if (((ServiceNode)object).org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() != this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ServiceNode serviceNode = (ServiceNode)x$1;
            String string = this.path();
            String string2 = serviceNode.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.lease() != serviceNode.lease()) return false;
            if (!serviceNode.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() {
            return this.$outer;
        }

        public ServiceNode(EtcdDiscoveryClient $outer, String path, long lease) {
            this.path = path;
            this.lease = lease;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

