/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.KdcUdpTransport;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.KrbTcpTransport;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KdcNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(KdcNetwork.class);
    protected static final int MAX_MESSAGE_SIZE = 65507;
    private static final int KDC_TCP_TRANSPORT_TIMEOUT = 3000;
    private static final int KDC_TCP_SERVER_TIMEOUT = 100;
    private TransportPair tpair;
    private boolean isStopped;
    private ServerSocket tcpServer;
    private DatagramChannel udpServer;
    private Map<InetSocketAddress, KdcUdpTransport> transports = new HashMap<InetSocketAddress, KdcUdpTransport>();
    private ByteBuffer recvBuffer;

    public synchronized void init() {
        this.isStopped = false;
    }

    public synchronized void listen(TransportPair tpair) throws IOException {
        this.tpair = tpair;
        if (tpair.tcpAddress != null) {
            this.tcpServer = new ServerSocket();
            this.tcpServer.setSoTimeout(100);
            this.tcpServer.bind(tpair.tcpAddress);
        }
        if (tpair.udpAddress != null) {
            this.udpServer = DatagramChannel.open();
            this.udpServer.configureBlocking(false);
            this.udpServer.bind(tpair.udpAddress);
            this.recvBuffer = ByteBuffer.allocate(65507);
        }
    }

    public synchronized void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KdcNetwork.this.run();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void run() {
        while (true) {
            KdcNetwork kdcNetwork = this;
            // MONITORENTER : kdcNetwork
            if (this.isStopped) {
                // MONITOREXIT : kdcNetwork
                return;
            }
            // MONITOREXIT : kdcNetwork
            if (this.tpair.tcpAddress != null) {
                try {
                    this.checkAndAccept();
                }
                catch (SocketException | SocketTimeoutException | ClosedChannelException iOException) {
                }
                catch (IOException e) {
                    throw new RuntimeException("Error occured while checking tcp connections", e);
                }
            }
            if (this.tpair.udpAddress == null) continue;
            try {
                this.checkUdpMessage();
                continue;
            }
            catch (SocketException | SocketTimeoutException | ClosedChannelException e) {
                continue;
            }
            break;
        }
        catch (IOException e) {
            throw new RuntimeException("Error occured while checking udp connections", e);
        }
    }

    public synchronized void stop() {
        try {
            if (this.tcpServer != null) {
                this.tcpServer.close();
            }
            if (this.udpServer != null) {
                this.udpServer.close();
            }
        }
        catch (IOException e) {
            LOG.warn("KDC network stopping error " + e);
        }
        this.isStopped = true;
    }

    private void checkAndAccept() throws IOException {
        if (this.tcpServer.isClosed()) {
            return;
        }
        Socket socket = this.tcpServer.accept();
        if (socket != null) {
            socket.setSoTimeout(3000);
            KrbTcpTransport transport = new KrbTcpTransport(socket);
            this.onNewTransport(transport);
        }
    }

    private void checkUdpMessage() throws IOException {
        if (!this.udpServer.isOpen()) {
            return;
        }
        InetSocketAddress fromAddress = (InetSocketAddress)this.udpServer.receive(this.recvBuffer);
        if (fromAddress != null) {
            this.recvBuffer.flip();
            KdcUdpTransport transport = this.transports.get(fromAddress);
            if (transport == null) {
                transport = new KdcUdpTransport(this.udpServer, fromAddress);
                transport.onRecvMessage(this.recvBuffer);
                this.onNewTransport(transport);
            } else {
                transport.onRecvMessage(this.recvBuffer);
            }
            this.recvBuffer = ByteBuffer.allocate(65507);
        }
    }

    protected abstract void onNewTransport(KrbTransport var1);
}

