/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino.session;

import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import io.trino.client.OkHttpUtil;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoContext$;
import org.apache.kyuubi.engine.trino.TrinoStatement;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoType;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u0013&\u0001IB\u0011\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O$\t\u0013!\u0003!\u0011!Q\u0001\n%3\u0006\"C,\u0001\u0005\u0003\u0005\u000b\u0011B%Y\u0011%I\u0006A!A!\u0002\u0013I%\fC\u0005\\\u0001\t\u0005\t\u0015!\u0003]?\"I\u0001\r\u0001B\u0001B\u0003%\u0011\r\u001a\u0005\u0006K\u0002!\tA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u00199\b\u0001)A\u0005c\"9\u0001\u0010\u0001b\u0001\n\u0003J\bBB?\u0001A\u0003%!\u0010C\u0004\u007f\u0001\t\u0007I\u0011B@\t\u000f\u0005\u0005\u0001\u0001)A\u0005\u0013\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011-\ty\u0001\u0001a\u0001\u0002\u0004%\t!!\u0005\t\u0017\u0005}\u0001\u00011A\u0001B\u0003&\u0011q\u0001\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0003C\u0006\u00028\u0001\u0001\r\u00111A\u0005\n\u0005e\u0002bCA\u001f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KA!\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0000\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\t\u0015\u0005\u001d\u0003\u00011A\u0001B\u0003&\u0011\n\u0003\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n}D1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N!Q\u0011\u0011\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B%\t\u0013\u0005M\u0003A1A\u0005\n\u0005U\u0003\u0002CA2\u0001\u0001\u0006I!a\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003{\u0002A\u0011KA@\u0011\u001d\t)\n\u0001C!\u0003/Ca!!+\u0001\t\u0013y\bbBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003c\u0003A\u0011IA4\u0005A!&/\u001b8p'\u0016\u001c8/[8o\u00136\u0004HN\u0003\u0002'O\u000591/Z:tS>t'B\u0001\u0015*\u0003\u0015!(/\u001b8p\u0015\tQ3&\u0001\u0004f]\u001eLg.\u001a\u0006\u0003Y5\naa[=vk\nL'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001gA\u0011AGN\u0007\u0002k)\u0011aeK\u0005\u0003oU\u0012q\"\u00112tiJ\f7\r^*fgNLwN\\\u0001\taJ|Go\\2pYB\u0011!(R\u0007\u0002w)\u0011A(P\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005yz\u0014a\u0001:qG*\u0011\u0001)Q\u0001\bg\u0016\u0014h/[2f\u0015\t\u00115)\u0001\u0003iSZ,'B\u0001#,\u0003\u0019\u0019\b.\u00193fI&\u0011ai\u000f\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:L!\u0001\u000f\u001c\u0002\tU\u001cXM\u001d\t\u0003\u0015Ns!aS)\u0011\u00051{U\"A'\u000b\u00059\u000b\u0014A\u0002\u001fs_>$hHC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011v*\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*P\u0013\tAe'\u0001\u0005qCN\u001cxo\u001c:e\u0013\t9f'A\u0005ja\u0006#GM]3tg&\u0011\u0011LN\u0001\u0005G>tg\r\u0005\u0003K;&K\u0015B\u00010V\u0005\ri\u0015\r]\u0005\u00037Z\nab]3tg&|g.T1oC\u001e,'\u000f\u0005\u00025E&\u00111-\u000e\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0013\t\u0001g'\u0001\u0004=S:LGO\u0010\u000b\bO&T7\u000e\\7o!\tA\u0007!D\u0001&\u0011\u0015At\u00011\u0001:\u0011\u0015Au\u00011\u0001J\u0011\u00159v\u00011\u0001J\u0011\u0015Iv\u00011\u0001J\u0011\u0015Yv\u00011\u0001]\u0011\u0015\u0001w\u00011\u0001b\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u0016\u0002\r\r|gNZ5h\u0013\t18O\u0001\u0006LsV,(-[\"p]\u001a\fAb]3tg&|gnQ8oM\u0002\na\u0001[1oI2,W#\u0001>\u0011\u0005QZ\u0018B\u0001?6\u00055\u0019Vm]:j_:D\u0015M\u001c3mK\u00069\u0001.\u00198eY\u0016\u0004\u0013aC:fgNLwN\\+tKJ,\u0012!S\u0001\rg\u0016\u001c8/[8o+N,'\u000fI\u0001\riJLgn\\\"p]R,\u0007\u0010^\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\f5\tq%C\u0002\u0002\u000e\u001d\u0012A\u0002\u0016:j]>\u001cuN\u001c;fqR\f\u0001\u0003\u001e:j]>\u001cuN\u001c;fqR|F%Z9\u0015\t\u0005M\u00111\u0004\t\u0005\u0003+\t9\"D\u0001P\u0013\r\tIb\u0014\u0002\u0005+:LG\u000fC\u0005\u0002\u001e=\t\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002\u001bQ\u0014\u0018N\\8D_:$X\r\u001f;!\u00035\u0019G.[3oiN+7o]5p]V\u0011\u0011Q\u0005\t\u0005\u0003O\t\u0019$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0019\u0019G.[3oi*\u0019\u0001&a\f\u000b\u0005\u0005E\u0012AA5p\u0013\u0011\t)$!\u000b\u0003\u001b\rc\u0017.\u001a8u'\u0016\u001c8/[8o\u0003E\u0019G.[3oiN+7o]5p]~#S-\u001d\u000b\u0005\u0003'\tY\u0004C\u0005\u0002\u001eI\t\t\u00111\u0001\u0002&\u0005q1\r\\5f]R\u001cVm]:j_:\u0004\u0013aC2bi\u0006dwn\u001a(b[\u0016\fqbY1uC2|wMT1nK~#S-\u001d\u000b\u0005\u0003'\t)\u0005\u0003\u0005\u0002\u001eU\t\t\u00111\u0001J\u00031\u0019\u0017\r^1m_\u001et\u0015-\\3!\u00031!\u0017\r^1cCN,g*Y7f\u0003A!\u0017\r^1cCN,g*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005=\u0003\u0002CA\u000f1\u0005\u0005\t\u0019A%\u0002\u001b\u0011\fG/\u00192bg\u0016t\u0015-\\3!\u00031\u0019Xm]:j_:,e/\u001a8u+\t\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifJ\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003C\nYFA\tUe&twnU3tg&|g.\u0012<f]R\fQb]3tg&|g.\u0012<f]R\u0004\u0013\u0001B8qK:$\"!a\u0005\u0002'\r\u0014X-\u0019;f\u00072LWM\u001c;TKN\u001c\u0018n\u001c8\u0015\u0005\u0005\u0015\u0012\u0001E2sK\u0006$X\r\u0013;ua\u000ec\u0017.\u001a8u)\t\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\t\t9(A\u0004pW\"$H\u000f]\u001a\n\t\u0005m\u0014Q\u000f\u0002\r\u001f.DE\u000f\u001e9DY&,g\u000e^\u0001\reVtw\n]3sCRLwN\u001c\u000b\u0005\u0003\u0003\u000bi\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9iK\u0001\n_B,'/\u0019;j_:LA!a#\u0002\u0006\nyq\n]3sCRLwN\u001c%b]\u0012dW\rC\u0004\u0002\b~\u0001\r!a$\u0011\t\u0005\r\u0015\u0011S\u0005\u0005\u0003'\u000b)IA\u0005Pa\u0016\u0014\u0018\r^5p]\u00069q-\u001a;J]\u001a|G\u0003BAM\u0003?\u00032AOAN\u0013\r\tij\u000f\u0002\u000e)\u001e+G/\u00138g_Z\u000bG.^3\t\u000f\u0005\u0005\u0006\u00051\u0001\u0002$\u0006A\u0011N\u001c4p)f\u0004X\rE\u0002;\u0003KK1!a*<\u00051!v)\u001a;J]\u001a|G+\u001f9f\u0003U9W\r\u001e+sS:|7+\u001a:wKJ4VM]:j_:\f1cZ3u)JLgn\\*fgNLwN\\\"p]\u001a$2\u0001XAX\u0011\u0015y'\u00051\u0001r\u0003\u0015\u0019Gn\\:f\u0001")
public class TrinoSessionImpl
extends AbstractSession {
    private final KyuubiConf sessionConf;
    private final SessionHandle handle;
    private final String sessionUser;
    private TrinoContext trinoContext;
    private ClientSession clientSession;
    private String catalogName;
    private String databaseName;
    private final TrinoSessionEvent sessionEvent;

    public KyuubiConf sessionConf() {
        return this.sessionConf;
    }

    public SessionHandle handle() {
        return this.handle;
    }

    private String sessionUser() {
        return this.sessionUser;
    }

    public TrinoContext trinoContext() {
        return this.trinoContext;
    }

    public void trinoContext_$eq(TrinoContext x$1) {
        this.trinoContext = x$1;
    }

    private ClientSession clientSession() {
        return this.clientSession;
    }

    private void clientSession_$eq(ClientSession x$1) {
        this.clientSession = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private String databaseName() {
        return this.databaseName;
    }

    private void databaseName_$eq(String x$1) {
        this.databaseName = x$1;
    }

    private TrinoSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    public void open() {
        Tuple2 tuple2 = this.normalizedConf().partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TrinoSessionImpl.$anonfun$open$1(x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map useCatalogAndDatabaseConf = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map useCatalogAndDatabaseConf2 = useCatalogAndDatabaseConf;
        useCatalogAndDatabaseConf2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TrinoSessionImpl.$anonfun$open$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        if (this.catalogName() == null) {
            this.catalogName_$eq((String)((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_CATALOG())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw KyuubiSQLException$.MODULE$.apply("Trino default catalog can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }));
        }
        this.clientSession_$eq(this.createClientSession());
        this.trinoContext_$eq(TrinoContext$.MODULE$.apply(this.createHttpClient(), this.clientSession()));
        super.open();
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
    }

    private ClientSession createClientSession() {
        String connectionUrl = (String)((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_URL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply("Trino server url can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
        long clientRequestTimeout = BoxesRunTime.unboxToLong((Object)this.sessionConf().get(TrinoConf$.MODULE$.CLIENT_REQUEST_TIMEOUT()));
        Map properties = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.getTrinoSessionConf(this.sessionConf())).asJava();
        return ClientSession.builder().server(URI.create(connectionUrl)).principal(Optional.of(this.sessionUser())).source("kyuubi").catalog(this.catalogName()).schema(this.databaseName()).timeZone(ZoneId.systemDefault()).locale(Locale.getDefault()).properties(properties).clientRequestTimeout(new Duration((double)clientRequestTimeout, TimeUnit.MILLISECONDS)).compressionDisabled(true).build();
    }

    private OkHttpClient createHttpClient() {
        String serverScheme = this.clientSession().getServer().getScheme();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        boolean insecureEnabled = BoxesRunTime.unboxToBoolean((Object)this.sessionConf().get(KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_INSECURE_ENABLED()));
        if (insecureEnabled) {
            OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)builder);
        } else {
            Option keystorePath = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_PATH());
            Option keystorePassword = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_PASSWORD());
            Option keystoreType = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_TYPE());
            Option truststorePath = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_PATH());
            Option truststorePassword = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_PASSWORD());
            Option truststoreType = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_TYPE());
            OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, Optional.ofNullable(keystorePath.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(keystorePassword.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(keystoreType.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststorePath.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststorePassword.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststoreType.orNull(Predef$.MODULE$.$conforms())), (boolean)true);
        }
        ((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_PASSWORD())).foreach((Function1 & Serializable & scala.Serializable)password -> {
            Predef$.MODULE$.require(serverScheme.equalsIgnoreCase("https"), (Function0 & Serializable & scala.Serializable)() -> "Trino engine using username/password requires HTTPS to be enabled");
            String user = (String)((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_USER())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.sessionUser());
            return builder.addInterceptor(OkHttpUtil.basicAuth((String)user, (String)password));
        });
        return builder.build();
    }

    public OperationHandle runOperation(Operation operation) {
        this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        return super.runOperation(operation);
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Trino");
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.getTrinoServerVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType) ? true : (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType) ? true : TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType))) {
                return TGetInfoValue.lenValue((long)0L);
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    private String getTrinoServerVersion() {
        TrinoStatement trinoStatement = TrinoStatement$.MODULE$.apply(this.trinoContext(), super.sessionManager().getConf(), "SELECT version()", TrinoStatement$.MODULE$.apply$default$4());
        Iterator<List<Object>> resultSet = trinoStatement.execute();
        Predef$.MODULE$.assert(resultSet.hasNext());
        return ((IterableLike)resultSet.next()).head().toString();
    }

    private scala.collection.immutable.Map<String, String> getTrinoSessionConf(KyuubiConf sessionConf) {
        scala.collection.immutable.Map trinoSessionConf = (scala.collection.immutable.Map)sessionConf.getAll().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("trino."))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(k)).stripPrefix("trino."), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        return trinoSessionConf.toMap(Predef$.MODULE$.$conforms());
    }

    public void close() {
        this.sessionEvent().endTime_$eq(System.currentTimeMillis());
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        super.close();
    }

    public static final /* synthetic */ boolean $anonfun$open$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{package$.MODULE$.USE_CATALOG(), package$.MODULE$.USE_DATABASE()})).contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$open$2(TrinoSessionImpl $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String catalog = (String)tuple2._2();
            String string2 = package$.MODULE$.USE_CATALOG();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                $this.catalogName_$eq(catalog);
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String database = (String)tuple2._2();
            String string4 = package$.MODULE$.USE_DATABASE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                $this.databaseName_$eq(database);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public TrinoSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
        KyuubiConf engineConf = super.sessionManager().getConf().clone();
        super.conf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return engineConf.set(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.sessionConf = engineConf;
        this.handle = (SessionHandle)super.conf().get((Object)"kyuubi.session.handle").map((Function1 & Serializable & scala.Serializable)uuid -> SessionHandle$.MODULE$.fromUUID(uuid)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionHandle$.MODULE$.apply());
        this.sessionUser = (String)this.sessionConf().getOption("kyuubi.session.user").getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.currentUser());
        this.sessionEvent = TrinoSessionEvent$.MODULE$.apply(this);
    }
}

