/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstanceSettings {
    private final int sshPort;
    private final int rmiRegistryPort;
    private final int rmiServerPort;
    private final String location;
    private final String javaOpts;
    private final List<String> featureURLs;
    private final List<String> features;
    private final String address;
    private final Map<String, URL> textResources;
    private final Map<String, URL> binaryResources;
    private final List<String> profiles;

    public InstanceSettings(int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, List<String> featureURLs, List<String> features) {
        this(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, featureURLs, features, "0.0.0.0");
    }

    public InstanceSettings(int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, List<String> featureURLs, List<String> features, String address) {
        this(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, featureURLs, features, address, new HashMap<String, URL>(), new HashMap<String, URL>());
    }

    public InstanceSettings(int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, List<String> featureURLs, List<String> features, String address, Map<String, URL> textResources, Map<String, URL> binaryResources) {
        this(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, featureURLs, features, address, textResources, binaryResources, null);
    }

    public InstanceSettings(int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, List<String> featureURLs, List<String> features, String address, Map<String, URL> textResources, Map<String, URL> binaryResources, List<String> profiles) {
        this.sshPort = sshPort;
        this.rmiRegistryPort = rmiRegistryPort;
        this.rmiServerPort = rmiServerPort;
        this.location = location;
        this.javaOpts = javaOpts;
        this.featureURLs = featureURLs != null ? featureURLs : new ArrayList();
        this.features = features != null ? features : new ArrayList();
        this.address = address;
        this.textResources = textResources != null ? textResources : new HashMap();
        this.binaryResources = binaryResources != null ? binaryResources : new HashMap();
        this.profiles = profiles != null ? profiles : new ArrayList();
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public int getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public List<String> getFeatureURLs() {
        return Collections.unmodifiableList(this.featureURLs);
    }

    public List<String> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public Map<String, URL> getTextResources() {
        return Collections.unmodifiableMap(this.textResources);
    }

    public Map<String, URL> getBinaryResources() {
        return Collections.unmodifiableMap(this.binaryResources);
    }

    public String getAddress() {
        return this.address;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceSettings)) {
            return false;
        }
        InstanceSettings is = (InstanceSettings)o;
        return is.sshPort == this.sshPort && is.rmiRegistryPort == this.rmiRegistryPort && is.rmiServerPort == this.rmiServerPort && (this.location == null ? is.location == null : this.location.equals(is.location)) && (this.javaOpts == null ? is.javaOpts == null : this.javaOpts.equals(is.javaOpts)) && (this.featureURLs == null ? is.featureURLs == null : this.featureURLs.equals(is.featureURLs)) && (this.features == null ? is.features == null : this.features.equals(is.features)) && (this.address == null ? is.address == null : this.address.equals(is.address)) && (this.profiles == null ? is.profiles == null : this.profiles.equals(is.profiles));
    }

    public int hashCode() {
        int result = this.sshPort + this.rmiRegistryPort + this.rmiServerPort;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.javaOpts != null ? this.javaOpts.hashCode() : 0);
        result = 31 * result + (this.featureURLs != null ? this.featureURLs.hashCode() : 0);
        result = 31 * result + (this.features != null ? this.features.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.profiles != null ? this.profiles.hashCode() : 0);
        return result;
    }
}

