/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.regex.Pattern;
import org.apache.jena.rfc3986.Chars3986;
import org.apache.jena.rfc3986.IRIParseException;

public class ParseDID {
    private static char EOF = (char)65535;
    private static final Pattern DID_PATTERN = Pattern.compile("^did:[a-z]+:(?:(?:[a-z0-9.-_]|%[0-9]A-Fa-f]{2})+)$");
    private static final int DIDStart = "did:".length();

    public static void parse(String string, boolean allowPercentEncoding) {
        if (!string.startsWith("did:")) {
            ParseDID.error(string, "Not a DID");
        }
        int end = string.length();
        int p = DIDStart;
        int q = ParseDID.methodName(string, p);
        if (q <= p + 1) {
            ParseDID.error(string, "No method name");
        }
        if ((q = ParseDID.methodSpecificId(string, p = q)) <= p) {
            ParseDID.error(string, "No method-specific-id");
        }
        if (q != end) {
            ParseDID.error(string, "Trailing characters after method-specific-id");
        }
    }

    private static int methodName(String str2, int p) {
        int end = str2.length();
        int start = p;
        while (p < end) {
            char ch = Chars3986.charAt(str2, p);
            if (ch == EOF) {
                return p;
            }
            if (ch == ':') {
                return ++p;
            }
            if (!ParseDID.methodChar(ch)) {
                if (ParseDID.uppercaseMethodChar(ch)) {
                    ParseDID.error(str2, "Uppercase character (not allowed in DID method name): '" + Character.toString(ch) + "'");
                } else {
                    ParseDID.error(str2, "Bad character: '" + Character.toString(ch) + "'");
                }
            }
            ++p;
        }
        if (p != end && start + 1 == p) {
            ParseDID.error(str2, "Zero length methodName");
        }
        return p;
    }

    private static int methodSpecificId(String str2, int p) {
        char chLast;
        int end = str2.length();
        int start = p;
        while (p < end) {
            char ch = Chars3986.charAt(str2, p);
            if (ch == EOF) {
                // empty if block
            }
            if (ch == ':') {
                ++p;
                continue;
            }
            if (!ParseDID.idchar(ch, str2, p)) {
                ParseDID.error(str2, "Bad character: '" + Character.toString(ch) + "'");
            }
            ++p;
        }
        if (p != end) {
            ParseDID.error(str2, "Traing charactser after method specific id");
        }
        if (start == p) {
            ParseDID.error(str2, "Zero length method specific id");
        }
        if ((chLast = Chars3986.charAt(str2, p - 1)) == ':') {
            ParseDID.error(str2, "Final method specifc id character is a ':'");
        }
        return p;
    }

    private static boolean methodChar(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    private static boolean uppercaseMethodChar(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    private static boolean idchar(char ch, String str2, int p) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '_' || Chars3986.isPctEncoded(ch, str2, p);
    }

    private static void error(String didString, String msg) {
        throw new DIDParseException(didString, msg);
    }

    static class DIDParseException
    extends IRIParseException {
        DIDParseException(String entity, String msg) {
            super((CharSequence)entity, msg);
        }
    }
}

