/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.PatchHeader;
import org.apache.jena.rdfpatch.PatchProcessor;
import org.apache.jena.rdfpatch.RDF2Patch;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.rdfpatch.StreamPatch;
import org.apache.jena.rdfpatch.binary.RDFChangesWriterBinary;
import org.apache.jena.rdfpatch.binary.RDFPatchReaderBinary;
import org.apache.jena.rdfpatch.changes.PatchSummary;
import org.apache.jena.rdfpatch.changes.RDFChangesApply;
import org.apache.jena.rdfpatch.changes.RDFChangesApplyGraph;
import org.apache.jena.rdfpatch.changes.RDFChangesCollector;
import org.apache.jena.rdfpatch.changes.RDFChangesCounter;
import org.apache.jena.rdfpatch.changes.RDFChangesLog;
import org.apache.jena.rdfpatch.system.DatasetGraphChanges;
import org.apache.jena.rdfpatch.system.GraphChanges;
import org.apache.jena.rdfpatch.system.RDFPatchAltHeader;
import org.apache.jena.rdfpatch.system.URNs;
import org.apache.jena.rdfpatch.text.RDFChangesWriterText;
import org.apache.jena.rdfpatch.text.RDFPatchReaderText;
import org.apache.jena.rdfpatch.text.TokenWriter;
import org.apache.jena.rdfpatch.text.TokenWriterText;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;

public class RDFPatchOps {
    public static String namespace = "http://jena.apache.org/rdf-patch/";

    public static RDFPatch fileToPatch(String filename) {
        InputStream in = IO.openFile((String)filename);
        return RDFPatchOps.read(in);
    }

    public static RDFPatch nullPatch() {
        return new RDFPatchNull();
    }

    public static RDFPatch emptyPatch() {
        return new RDFPatchEmpty();
    }

    public static PatchSummary summary(RDFPatch patch) {
        RDFChangesCounter x = new RDFChangesCounter();
        patch.apply(x);
        return x.summary();
    }

    public static RDFPatch collect(RDFPatch patch) {
        if (patch instanceof RDFChangesCollector) {
            return patch;
        }
        return RDFPatchOps.build(x -> patch.apply((RDFChanges)x));
    }

    public static RDFPatch build(Consumer<RDFChangesCollector> filler) {
        RDFChangesCollector x = new RDFChangesCollector();
        filler.accept(x);
        return x.getRDFPatch();
    }

    public static RDFPatch rdf2patch(String rdfDataFile) {
        RDFChangesCollector x = new RDFChangesCollector();
        RDF2Patch dest = new RDF2Patch(x);
        RDFParser.source((String)rdfDataFile).parse((StreamRDF)dest);
        RDFPatch patch = x.getRDFPatch();
        return patch;
    }

    public static RDFPatch withPrev(RDFPatch body, Node prev) {
        return RDFPatchOps.withHeader(body, body.getId(), prev);
    }

    public static RDFPatch withPrev(RDFPatch patch, RDFPatch prevPatch) {
        return RDFPatchOps.withPrev(patch, prevPatch.getId());
    }

    public static RDFPatch withHeader(RDFPatch body, Node id, Node prev) {
        PatchHeader h = RDFPatchOps.makeHeader(id, prev);
        return RDFPatchOps.withHeader(h, body);
    }

    public static RDFPatch withHeader(PatchHeader header, RDFPatch body) {
        return new RDFPatchAltHeader(header, body);
    }

    public static PatchHeader makeHeader(Node id, Node prev) {
        Objects.requireNonNull(id, "Head id node is null");
        HashMap<String, Node> m = new HashMap<String, Node>();
        m.put("id", id);
        if (prev != null) {
            m.put("prev", prev);
        }
        return new PatchHeader(m);
    }

    public static RDFPatch read(InputStream input) {
        RDFPatchReaderText pr = new RDFPatchReaderText(input);
        RDFChangesCollector c = new RDFChangesCollector();
        pr.apply(c);
        return c.getRDFPatch();
    }

    public static RDFPatch read(InputStream input, ErrorHandler errorHandler) {
        RDFPatchReaderText pr = new RDFPatchReaderText(input, errorHandler);
        RDFChangesCollector c = new RDFChangesCollector();
        pr.apply(c);
        return c.getRDFPatch();
    }

    public static RDFPatch read(String filename) {
        RDFPatch rDFPatch;
        block8: {
            InputStream input = IO.openFile((String)filename);
            try {
                rDFPatch = RDFPatchOps.read(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception((IOException)ex);
                    return null;
                }
            }
            input.close();
        }
        return rDFPatch;
    }

    public static RDFPatch readBinary(InputStream input) {
        PatchProcessor reader = RDFPatchReaderBinary.create(input);
        RDFChangesCollector c = new RDFChangesCollector();
        reader.apply(c);
        return c.getRDFPatch();
    }

    public static RDFPatch readBinary(String filename) {
        RDFPatch rDFPatch;
        block8: {
            InputStream input = IO.openFile((String)filename);
            try {
                rDFPatch = RDFPatchOps.readBinary(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception((IOException)ex);
                    return null;
                }
            }
            input.close();
        }
        return rDFPatch;
    }

    public static PatchHeader readHeader(InputStream input) {
        return RDFPatchReaderText.readerHeader(input);
    }

    public static void applyChange(DatasetGraph dsg, RDFPatch patch) {
        RDFChangesApply changes = new RDFChangesApply(dsg);
        patch.apply(changes);
    }

    public static void applyChange(DatasetGraph dsg, InputStream input) {
        RDFPatchReaderText pr = new RDFPatchReaderText(input);
        RDFChangesApply changes = new RDFChangesApply(dsg);
        pr.apply(changes);
    }

    public static void applyChange(Graph graph, RDFPatch patch) {
        RDFChangesApplyGraph changes = new RDFChangesApplyGraph(graph);
        patch.apply(changes);
    }

    public static void applyChange(Graph graph, InputStream input) {
        RDFPatchReaderText pr = new RDFPatchReaderText(input);
        RDFChangesApplyGraph changes = new RDFChangesApplyGraph(graph);
        pr.apply(changes);
    }

    public static DatasetGraph changes(DatasetGraph dsgBase, RDFChanges changes) {
        return new DatasetGraphChanges(dsgBase, changes);
    }

    private static void printer(PrintStream out, String fmt, Object ... args) {
        out.printf(fmt, args);
        if (!fmt.endsWith("\n")) {
            out.println();
        }
    }

    public static RDFChanges changesPrinter() {
        return new RDFChangesLog((fmt, args) -> RDFPatchOps.printer(System.out, fmt, args));
    }

    public static RDFChangesWriterText textWriter(OutputStream output) {
        return RDFChangesWriterText.create(output);
    }

    public static Graph changes(Graph graphBase, RDFChanges changes) {
        return new GraphChanges(graphBase, changes);
    }

    public static DatasetGraph textWriter(DatasetGraph dsgBase, OutputStream out) {
        RDFChangesWriterText changeLog = RDFPatchOps.textWriter(out);
        return RDFPatchOps.changes(dsgBase, (RDFChanges)changeLog);
    }

    public static Graph textWriter(Graph graph, OutputStream out) {
        RDFChangesWriterText changeLog = RDFPatchOps.textWriter(out);
        return RDFPatchOps.changes(graph, (RDFChanges)changeLog);
    }

    public static void write(OutputStream out, RDFPatch patch) {
        RDFChangesWriterText c = RDFChangesWriterText.create(out);
        c.start();
        patch.apply(c);
        c.finish();
    }

    public static void writeBinary(OutputStream out, RDFPatch patch) {
        RDFChangesWriterBinary.write(patch, out);
    }

    public static StreamRDF write(OutputStream out) {
        RDFChangesWriterText rdfChanges = RDFChangesWriterText.create(out);
        return new StreamPatch(rdfChanges);
    }

    public static void writeBinary(OutputStream out, Consumer<StreamRDF> action) {
        RDFChangesWriterBinary.writeBinary(out, (RDFChanges c) -> {
            StreamPatch stream = new StreamPatch((RDFChanges)c);
            action.accept(stream);
        });
    }

    public static String str(RDFPatch patch) {
        StringWriter sw = new StringWriter();
        TokenWriter tw = TokenWriterText.create(sw);
        RDFChangesWriterText c = new RDFChangesWriterText(tw);
        patch.apply(c);
        tw.flush();
        return sw.toString();
    }

    private static class RDFPatchNull
    implements RDFPatch {
        private final PatchHeader header = new PatchHeader(Collections.emptyMap());

        private RDFPatchNull() {
        }

        @Override
        public PatchHeader header() {
            return this.header;
        }

        @Override
        public void apply(RDFChanges changes) {
        }

        @Override
        public boolean repeatable() {
            return true;
        }
    }

    private static class RDFPatchEmpty
    implements RDFPatch {
        private final Node id = URNs.unique();
        private final PatchHeader header = new PatchHeader(Collections.singletonMap("id", this.id));

        RDFPatchEmpty() {
        }

        @Override
        public PatchHeader header() {
            return this.header;
        }

        @Override
        public void apply(RDFChanges changes) {
            this.header.apply(changes);
            changes.txnBegin();
            changes.txnCommit();
        }

        @Override
        public boolean repeatable() {
            return true;
        }
    }
}

