/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncreaseRequest;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AllocateRequest {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static AllocateRequest newInstance(int responseID, float appProgress, List<ResourceRequest> resourceAsk, List<ContainerId> containersToBeReleased, ResourceBlacklistRequest resourceBlacklistRequest) {
        return AllocateRequest.newInstance(responseID, appProgress, resourceAsk, containersToBeReleased, null, resourceBlacklistRequest);
    }

    @Deprecated
    public static AllocateRequest newInstance(int responseID, float appProgress, List<ResourceRequest> resourceAsk, List<ContainerId> containersToBeReleased, ResourceBlacklistRequest resourceBlacklistRequest, List<ContainerResourceIncreaseRequest> increaseRequests) {
        AllocateRequest allocateRequest = Records.newRecord(AllocateRequest.class);
        allocateRequest.setResponseId(responseID);
        allocateRequest.setProgress(appProgress);
        allocateRequest.setAskList(resourceAsk);
        allocateRequest.setReleaseList(containersToBeReleased);
        allocateRequest.setResourceBlacklistRequest(resourceBlacklistRequest);
        allocateRequest.setIncreaseRequests(increaseRequests);
        return allocateRequest;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static AllocateRequest newInstance(int responseID, float appProgress, List<ResourceRequest> resourceAsk, List<ContainerId> containersToBeReleased, List<UpdateContainerRequest> updateRequests, ResourceBlacklistRequest resourceBlacklistRequest) {
        AllocateRequest allocateRequest = Records.newRecord(AllocateRequest.class);
        allocateRequest.setResponseId(responseID);
        allocateRequest.setProgress(appProgress);
        allocateRequest.setAskList(resourceAsk);
        allocateRequest.setReleaseList(containersToBeReleased);
        allocateRequest.setResourceBlacklistRequest(resourceBlacklistRequest);
        allocateRequest.setUpdateRequests(updateRequests);
        return allocateRequest;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getResponseId();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResponseId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getProgress();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setProgress(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ResourceRequest> getAskList();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setAskList(List<ResourceRequest> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ContainerId> getReleaseList();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setReleaseList(List<ContainerId> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ResourceBlacklistRequest getResourceBlacklistRequest();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResourceBlacklistRequest(ResourceBlacklistRequest var1);

    @Deprecated
    public abstract List<ContainerResourceIncreaseRequest> getIncreaseRequests();

    @Deprecated
    public abstract void setIncreaseRequests(List<ContainerResourceIncreaseRequest> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<UpdateContainerRequest> getUpdateRequests();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setUpdateRequests(List<UpdateContainerRequest> var1);
}

