/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeRegistration
extends DatanodeID
implements NodeRegistration {
    private final StorageInfo storageInfo;
    private ExportedBlockKeys exportedKeys;
    private final String softwareVersion;
    private NamespaceInfo nsInfo;

    @VisibleForTesting
    public DatanodeRegistration(String uuid, DatanodeRegistration dnr) {
        this(new DatanodeID(uuid, dnr), dnr.getStorageInfo(), dnr.getExportedKeys(), dnr.getSoftwareVersion());
    }

    public DatanodeRegistration(DatanodeID dn, StorageInfo info, ExportedBlockKeys keys, String softwareVersion) {
        super(dn);
        this.storageInfo = info;
        this.exportedKeys = keys;
        this.softwareVersion = softwareVersion;
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public void setExportedKeys(ExportedBlockKeys keys) {
        this.exportedKeys = keys;
    }

    public ExportedBlockKeys getExportedKeys() {
        return this.exportedKeys;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    public void setNamespaceInfo(NamespaceInfo nsInfo) {
        this.nsInfo = nsInfo;
    }

    public NamespaceInfo getNamespaceInfo() {
        return this.nsInfo;
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    @Override
    public String getAddress() {
        return this.getXferAddr();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + super.toString() + ", datanodeUuid=" + this.getDatanodeUuid() + ", infoPort=" + this.getInfoPort() + ", infoSecurePort=" + this.getInfoSecurePort() + ", ipcPort=" + this.getIpcPort() + ", storageInfo=" + this.storageInfo + ")";
    }

    @Override
    public boolean equals(Object to) {
        return super.equals(to);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

