/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.http.HttpConstants;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.http.multipart.AbstractHttpData;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ChannelBuffer channelBuffer;
    private int chunkPosition;
    protected boolean isRenamed;

    protected AbstractMemoryHttpData(String name, Charset charset, long size) {
        super(name, charset, size);
    }

    public void setContent(ChannelBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        long localsize = buffer.readableBytes();
        if (this.definedSize > 0L && this.definedSize < localsize) {
            throw new IOException("Out of size: " + localsize + " > " + this.definedSize);
        }
        this.channelBuffer = buffer;
        this.size = localsize;
        this.completed = true;
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        byte[] bytes = new byte[16384];
        int read = inputStream.read(bytes);
        int written = 0;
        while (read > 0) {
            buffer.writeBytes(bytes);
            written += read;
            read = inputStream.read(bytes);
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.channelBuffer = buffer;
        this.completed = true;
    }

    public void addContent(ChannelBuffer buffer, boolean last) throws IOException {
        if (buffer != null) {
            long localsize = buffer.readableBytes();
            if (this.definedSize > 0L && this.definedSize < this.size + localsize) {
                throw new IOException("Out of size: " + (this.size + localsize) + " > " + this.definedSize);
            }
            this.size += localsize;
            this.channelBuffer = this.channelBuffer == null ? buffer : ChannelBuffers.wrappedBuffer(this.channelBuffer, buffer);
        }
        if (last) {
            this.completed = true;
        } else if (buffer == null) {
            throw new NullPointerException("buffer");
        }
    }

    public void setContent(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        long newsize = file.length();
        if (newsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        FileInputStream inputStream = new FileInputStream(file);
        FileChannel fileChannel = inputStream.getChannel();
        byte[] array = new byte[(int)newsize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        int read = 0;
        while ((long)read < newsize) {
            read += fileChannel.read(byteBuffer);
        }
        fileChannel.close();
        inputStream.close();
        byteBuffer.flip();
        this.channelBuffer = ChannelBuffers.wrappedBuffer(byteBuffer);
        this.size = newsize;
        this.completed = true;
    }

    public void delete() {
    }

    public byte[] get() {
        if (this.channelBuffer == null) {
            return new byte[0];
        }
        byte[] array = new byte[this.channelBuffer.readableBytes()];
        this.channelBuffer.getBytes(this.channelBuffer.readerIndex(), array);
        return array;
    }

    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    public String getString(Charset encoding) {
        if (this.channelBuffer == null) {
            return "";
        }
        if (encoding == null) {
            encoding = HttpConstants.DEFAULT_CHARSET;
        }
        return this.channelBuffer.toString(encoding);
    }

    public ChannelBuffer getChannelBuffer() {
        return this.channelBuffer;
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        if (this.channelBuffer == null || length == 0 || this.channelBuffer.readableBytes() == 0) {
            this.chunkPosition = 0;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        int sizeLeft = this.channelBuffer.readableBytes() - this.chunkPosition;
        if (sizeLeft == 0) {
            this.chunkPosition = 0;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        int sliceLength = length;
        if (sizeLeft < length) {
            sliceLength = sizeLeft;
        }
        ChannelBuffer chunk = this.channelBuffer.slice(this.chunkPosition, sliceLength);
        this.chunkPosition += sliceLength;
        return chunk;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean renameTo(File dest) throws IOException {
        int written;
        if (dest == null) {
            throw new NullPointerException("dest");
        }
        if (this.channelBuffer == null) {
            dest.createNewFile();
            this.isRenamed = true;
            return true;
        }
        int length = this.channelBuffer.readableBytes();
        FileOutputStream outputStream = new FileOutputStream(dest);
        FileChannel fileChannel = outputStream.getChannel();
        ByteBuffer byteBuffer = this.channelBuffer.toByteBuffer();
        for (written = 0; written < length; written += fileChannel.write(byteBuffer)) {
        }
        fileChannel.force(false);
        fileChannel.close();
        outputStream.close();
        this.isRenamed = true;
        return written == length;
    }

    public File getFile() throws IOException {
        throw new IOException("Not represented by a file");
    }
}

