/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalName
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PrincipalNameType nameType;
    private List<String> nameString = new ArrayList<String>();
    private String realm;
    private List<byte[]> nameBytes;
    private int principalNameSeqLength;
    private int principalTypeTagLength;
    private int principalTypeLength;
    private int principalStringsTagLength;
    private int principalStringsSeqLength;

    public PrincipalName() {
    }

    public PrincipalName(KerberosPrincipal principal) {
        try {
            this.nameString = KerberosUtils.getNames(principal);
        }
        catch (ParseException pe) {
            this.nameString = KerberosUtils.EMPTY_PRINCIPAL_NAME;
        }
        this.nameType = PrincipalNameType.getTypeByValue(principal.getNameType());
    }

    public PrincipalName(String nameString, PrincipalNameType nameType) throws ParseException {
        this.nameString = KerberosUtils.getNames(nameString);
        this.nameType = nameType;
    }

    public PrincipalName(String nameString, int nameType) {
        try {
            this.nameString = KerberosUtils.getNames(nameString);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe);
        }
        this.nameType = PrincipalNameType.getTypeByValue(nameType);
    }

    public PrincipalNameType getNameType() {
        return this.nameType;
    }

    public void setNameType(PrincipalNameType nameType) {
        this.nameType = nameType;
    }

    public void setNameType(int nameType) {
        this.nameType = PrincipalNameType.getTypeByValue(nameType);
    }

    public List<String> getNames() {
        return this.nameString;
    }

    public String getNameString() {
        if (this.nameString == null || this.nameString.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String name : this.nameString) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('/');
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public void addName(String name) {
        if (this.nameString == null) {
            this.nameString = new ArrayList<String>();
        }
        this.nameString.add(name);
    }

    @Override
    public int computeLength() {
        this.principalTypeLength = BerValue.getNbBytes((int)this.nameType.getValue());
        this.principalTypeTagLength = 2 + this.principalTypeLength;
        this.principalNameSeqLength = 1 + TLV.getNbBytes((int)this.principalTypeTagLength) + this.principalTypeTagLength;
        if (this.nameString == null || this.nameString.size() == 0) {
            this.principalStringsSeqLength = 0;
        } else {
            this.principalStringsSeqLength = 0;
            this.nameBytes = new ArrayList<byte[]>(this.nameString.size());
            for (String name : this.nameString) {
                if (name != null) {
                    byte[] bytes = Strings.getBytesUtf8(name);
                    this.nameBytes.add(bytes);
                    this.principalStringsSeqLength += 1 + TLV.getNbBytes((int)bytes.length) + bytes.length;
                    continue;
                }
                this.nameBytes.add(StringConstants.EMPTY_BYTES);
                this.principalStringsSeqLength += 2;
            }
        }
        this.principalStringsTagLength = 1 + TLV.getNbBytes((int)this.principalStringsSeqLength) + this.principalStringsSeqLength;
        this.principalNameSeqLength += 1 + TLV.getNbBytes((int)this.principalStringsTagLength) + this.principalStringsTagLength;
        return 1 + TLV.getNbBytes((int)this.principalNameSeqLength) + this.principalNameSeqLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.principalNameSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.principalTypeTagLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.nameType.getValue());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.principalStringsTagLength));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            if (this.nameString == null || this.nameString.size() == 0) {
                buffer.put((byte)0);
            } else {
                buffer.put(TLV.getBytes((int)this.principalStringsSeqLength));
                for (byte[] name : this.nameBytes) {
                    buffer.put(UniversalTag.GENERAL_STRING.getValue());
                    if (name == null || name.length == 0) {
                        buffer.put((byte)0);
                        continue;
                    }
                    buffer.put(TLV.getBytes((int)name.length));
                    buffer.put(name);
                }
            }
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err(I18n.ERR_146, 1 + TLV.getNbBytes((int)this.principalNameSeqLength) + this.principalNameSeqLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("PrinipalName encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            LOG.debug("PrinipalName initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append("name-type: ").append(this.nameType.name());
        if (this.nameString != null && this.nameString.size() != 0) {
            sb.append(", name-string : <");
            boolean isFirst = true;
            for (String name : this.nameString) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append(name).append('\'');
            }
            sb.append("> }");
        } else {
            sb.append(" no name-string }");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameString == null ? 0 : this.nameString.hashCode());
        result = 31 * result + (this.nameType == null ? 0 : this.nameType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        PrincipalName other = (PrincipalName)obj;
        if (this.nameString == null ? other.nameString != null : !this.nameString.equals(other.nameString)) {
            return false;
        }
        return this.nameType == other.nameType;
    }
}

