/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.time.DateTimeException;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.StringUtils;

public class BinaryStringUtils {
    public static final BinaryString NULL_STRING = BinaryString.fromString("NULL");
    public static final BinaryString TRUE_STRING = BinaryString.fromString("TRUE");
    public static final BinaryString FALSE_STRING = BinaryString.fromString("FALSE");
    public static final BinaryString[] EMPTY_STRING_ARRAY = new BinaryString[0];
    private static final List<BinaryString> TRUE_STRINGS = Stream.of("t", "true", "y", "yes", "1").map(BinaryString::fromString).collect(Collectors.toList());
    private static final List<BinaryString> FALSE_STRINGS = Stream.of("f", "false", "n", "no", "0").map(BinaryString::fromString).collect(Collectors.toList());

    private static byte[] getTmpBytes(BinaryString str, int sizeInBytes) {
        byte[] bytes = MemorySegmentUtils.allocateReuseBytes(sizeInBytes);
        MemorySegmentUtils.copyToBytes(str.getSegments(), str.getOffset(), bytes, 0, sizeInBytes);
        return bytes;
    }

    public static boolean toBoolean(BinaryString str) {
        BinaryString lowerCase = str.toLowerCase();
        if (TRUE_STRINGS.contains(lowerCase)) {
            return true;
        }
        if (FALSE_STRINGS.contains(lowerCase)) {
            return false;
        }
        throw new RuntimeException("Cannot parse '" + str + "' as BOOLEAN.");
    }

    public static long toLong(BinaryString str) throws NumberFormatException {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringUtils.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Input is empty.");
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Input has only positive or negative symbol.");
            }
        }
        long result = 0L;
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Invalid character found.");
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Invalid character found.");
            }
            ++i;
        }
        if (!negative && (result = -result) < 0L) {
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
        }
        return result;
    }

    public static int toInt(BinaryString str) throws NumberFormatException {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringUtils.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Input is empty.");
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Input has only positive or negative symbol.");
            }
        }
        int result = 0;
        int separator = 46;
        int radix = 10;
        long stopValue = -214748364L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Invalid character found.");
            }
            int digit = b - 48;
            if ((long)result < -214748364L) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
            }
            if ((result = result * 10 - digit) <= 0) continue;
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                throw BinaryStringUtils.numberFormatExceptionFor(str, "Invalid character found.");
            }
            ++i;
        }
        if (!negative && (result = -result) < 0) {
            throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
        }
        return result;
    }

    public static short toShort(BinaryString str) throws NumberFormatException {
        int intValue = BinaryStringUtils.toInt(str);
        short result = (short)intValue;
        if (result == intValue) {
            return result;
        }
        throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
    }

    public static byte toByte(BinaryString str) throws NumberFormatException {
        int intValue = BinaryStringUtils.toInt(str);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw BinaryStringUtils.numberFormatExceptionFor(str, "Overflow.");
    }

    public static double toDouble(BinaryString str) throws NumberFormatException {
        return Double.parseDouble(str.toString());
    }

    public static float toFloat(BinaryString str) throws NumberFormatException {
        return Float.parseFloat(str.toString());
    }

    private static NumberFormatException numberFormatExceptionFor(BinaryString input, String reason) {
        return new NumberFormatException("For input string: '" + input + "'. " + reason);
    }

    public static int toDate(BinaryString input) throws DateTimeException {
        String str = input.toString();
        if (StringUtils.isNumeric(str)) {
            return BinaryStringUtils.toInt(input);
        }
        Integer date = DateTimeUtils.parseDate(str);
        if (date == null) {
            throw new DateTimeException("For input string: '" + input + "'.");
        }
        return date;
    }

    public static int toTime(BinaryString input) throws DateTimeException {
        String str = input.toString();
        if (StringUtils.isNumeric(str)) {
            return BinaryStringUtils.toInt(input);
        }
        Integer date = DateTimeUtils.parseTime(str);
        if (date == null) {
            throw new DateTimeException("For input string: '" + input + "'.");
        }
        return date;
    }

    public static Timestamp toTimestamp(BinaryString input, int precision) throws DateTimeException {
        if (StringUtils.isNumeric(input.toString())) {
            long epoch = BinaryStringUtils.toLong(input);
            return BinaryStringUtils.fromMillisToTimestamp(epoch, precision);
        }
        return DateTimeUtils.parseTimestampData(input.toString(), precision);
    }

    public static Timestamp toTimestamp(BinaryString input, int precision, TimeZone timeZone) throws DateTimeException {
        return DateTimeUtils.parseTimestampData(input.toString(), precision, timeZone);
    }

    private static Timestamp fromMillisToTimestamp(long epoch, int precision) {
        int nanosOfMillis;
        long millis;
        switch (precision) {
            case 0: {
                millis = epoch * 1000L;
                nanosOfMillis = 0;
                break;
            }
            case 3: {
                millis = epoch;
                nanosOfMillis = 0;
                break;
            }
            case 6: {
                millis = epoch / 1000L;
                nanosOfMillis = (int)(epoch % 1000L * 1000L);
                break;
            }
            case 9: {
                millis = epoch / 1000000L;
                nanosOfMillis = (int)(epoch % 1000000L);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported precision: " + precision);
            }
        }
        if (nanosOfMillis < 0) {
            nanosOfMillis = 1000000 + nanosOfMillis;
            --millis;
        }
        return Timestamp.fromEpochMillis(millis, nanosOfMillis);
    }

    public static BinaryString toCharacterString(BinaryString strData, DataType type) {
        boolean targetCharType = type.getTypeRoot() == DataTypeRoot.CHAR;
        int targetLength = DataTypeChecks.getLength(type);
        if (strData.numChars() > targetLength) {
            return strData.substring(0, targetLength);
        }
        if (strData.numChars() < targetLength && targetCharType) {
            int padLength = targetLength - strData.numChars();
            BinaryString padString = BinaryString.blankString(padLength);
            return BinaryStringUtils.concat(strData, padString);
        }
        return strData;
    }

    public static byte[] toBinaryString(byte[] byteArrayTerm, DataType type) {
        boolean targetBinaryType = type.getTypeRoot() == DataTypeRoot.BINARY;
        int targetLength = DataTypeChecks.getLength(type);
        if (byteArrayTerm.length == targetLength) {
            return byteArrayTerm;
        }
        if (targetBinaryType) {
            return Arrays.copyOf(byteArrayTerm, targetLength);
        }
        if (byteArrayTerm.length <= targetLength) {
            return byteArrayTerm;
        }
        return Arrays.copyOf(byteArrayTerm, targetLength);
    }

    public static BinaryString concat(BinaryString ... inputs) {
        return BinaryStringUtils.concat(Arrays.asList(inputs));
    }

    public static BinaryString concat(Iterable<BinaryString> inputs) {
        int totalLength = 0;
        for (BinaryString input : inputs) {
            if (input == null) {
                return null;
            }
            totalLength += input.getSizeInBytes();
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.getSizeInBytes();
            MemorySegmentUtils.copyToBytes(input.getSegments(), input.getOffset(), result, offset, len);
            offset += len;
        }
        return BinaryString.fromBytes(result);
    }
}

