/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagBatchCreation {
    private static final Logger LOG = LoggerFactory.getLogger(TagBatchCreation.class);
    private static final String BATCH_WRITE_TAG_PREFIX = "batch-write-";
    private final FileStoreTable table;
    private final CoreOptions options;
    private final TagManager tagManager;
    private final SnapshotManager snapshotManager;
    private final TagDeletion tagDeletion;

    public TagBatchCreation(FileStoreTable table) {
        this.table = table;
        this.snapshotManager = table.snapshotManager();
        this.tagManager = table.tagManager();
        this.tagDeletion = table.store().newTagDeletion();
        this.options = table.coreOptions();
    }

    public void createTag() {
        block3: {
            Snapshot snapshot = this.snapshotManager.latestSnapshot();
            if (snapshot == null) {
                return;
            }
            Instant instant = Instant.ofEpochMilli(snapshot.timeMillis());
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String tagName = this.options.tagBatchCustomizedName() != null ? this.options.tagBatchCustomizedName() : BATCH_WRITE_TAG_PREFIX + localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            try {
                this.tagManager.deleteTag(tagName, this.tagDeletion, this.snapshotManager, this.table.store().createTagCallbacks(this.table));
                this.tagManager.createTag(snapshot, tagName, this.table.coreOptions().tagDefaultTimeRetained(), this.table.store().createTagCallbacks(this.table), false);
            }
            catch (Exception e) {
                LOG.warn("Failed to create tag '{}' from '${}', you can create this tag manually.", new Object[]{tagName, snapshot.id(), e});
                if (!this.tagManager.tagExists(tagName)) break block3;
                this.tagManager.deleteTag(tagName, this.tagDeletion, this.snapshotManager, this.table.store().createTagCallbacks(this.table));
            }
        }
        this.expireTag();
    }

    private void expireTag() {
        Integer tagNumRetainedMax = this.options.tagNumRetainedMax();
        if (tagNumRetainedMax != null) {
            if (this.snapshotManager.latestSnapshot() == null) {
                return;
            }
            long tagCount = this.tagManager.tagCount();
            block0: while (tagCount > (long)tagNumRetainedMax.intValue()) {
                for (List<String> tagNames : this.tagManager.tags().values()) {
                    if (tagCount - (long)tagNames.size() > (long)tagNumRetainedMax.intValue()) {
                        this.tagManager.deleteAllTagsOfOneSnapshot(tagNames, this.tagDeletion, this.snapshotManager);
                        tagCount -= (long)tagNames.size();
                        continue;
                    }
                    List<String> sortedTagNames = this.tagManager.sortTagsOfOneSnapshot(tagNames);
                    for (String toBeDeleted : sortedTagNames) {
                        this.tagManager.deleteTag(toBeDeleted, this.tagDeletion, this.snapshotManager, this.table.store().createTagCallbacks(this.table));
                        if (--tagCount != (long)tagNumRetainedMax.intValue()) continue;
                        continue block0;
                    }
                    continue block0;
                }
            }
        }
    }
}

