/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FullStartingScanner.class);
    private Snapshot startingSnapshot;

    public FullStartingScanner(SnapshotManager snapshotManager) {
        super(snapshotManager);
        this.startingSnapshot = snapshotManager.latestSnapshot();
        if (this.startingSnapshot != null) {
            this.startingSnapshotId = this.startingSnapshot.id();
        }
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        if (this.startingSnapshot == null) {
            this.startingSnapshot = this.snapshotManager.latestSnapshot();
        }
        if (this.startingSnapshot == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return null;
        }
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.startingSnapshot);
    }
}

