/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory;

public final class Utf8CodingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public Utf8CodingException(String message) {
        super(message);
    }

    public static Utf8CodingException shortUtf8DecodeByteSequence(byte leadByte, long address, long limit, int required) {
        String s = "Too few Utf8 decode bytes remaining given the leading byte. " + Utf8CodingException.shortSeq(leadByte, address, limit, required);
        return new Utf8CodingException(s);
    }

    public static Utf8CodingException illegalUtf8DecodeByteSequence(byte[] bytes) {
        String s = "Invalid UTF-8 decode byte sequence: " + Utf8CodingException.badBytes(bytes);
        return new Utf8CodingException(s);
    }

    public static Utf8CodingException outOfMemory() {
        String s = "Out-of-memory with characters remaining to be encoded";
        return new Utf8CodingException("Out-of-memory with characters remaining to be encoded");
    }

    public static Utf8CodingException unpairedSurrogate(char c) {
        String s = "Last char to encode is an unpaired surrogate: 0X" + Integer.toHexString(c & 0xFFFF);
        return new Utf8CodingException(s);
    }

    public static Utf8CodingException shortUtf8EncodeByteLength(int remaining) {
        String s = "Too few MemoryImpl bytes to encode a surrogate pair: " + remaining;
        return new Utf8CodingException(s);
    }

    public static Utf8CodingException illegalSurrogatePair(char c1, char c2) {
        String s = "Illegal Surrogate Pair: Char 1: " + Integer.toHexString(c1 & 0xFFFF) + ", Char 2: " + Integer.toHexString(c2 & 0xFFFF);
        return new Utf8CodingException(s);
    }

    private static String shortSeq(byte leadByte, long address, long limit, int required) {
        String s = "Lead byte: " + Integer.toHexString(leadByte & 0xFF) + ", offset: 0X" + Long.toHexString(address) + ", limit: 0X" + Long.toHexString(limit) + ", required: " + required;
        return s;
    }

    private static String badBytes(byte[] bytes) {
        int i;
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        for (i = 0; i < len - 1; ++i) {
            sb.append("0X" + Integer.toHexString(bytes[i] & 0xFF)).append(", ");
        }
        sb.append("0X" + Integer.toHexString(bytes[i] & 0xFF));
        return sb.toString();
    }
}

