/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import org.apache.paimon.rest.ErrorHandler;
import org.apache.paimon.rest.exceptions.AlreadyExistsException;
import org.apache.paimon.rest.exceptions.BadRequestException;
import org.apache.paimon.rest.exceptions.ForbiddenException;
import org.apache.paimon.rest.exceptions.NoSuchResourceException;
import org.apache.paimon.rest.exceptions.NotAuthorizedException;
import org.apache.paimon.rest.exceptions.NotImplementedException;
import org.apache.paimon.rest.exceptions.RESTException;
import org.apache.paimon.rest.exceptions.ServiceFailureException;
import org.apache.paimon.rest.exceptions.ServiceUnavailableException;
import org.apache.paimon.rest.responses.ErrorResponse;

public class DefaultErrorHandler
extends ErrorHandler {
    private static final ErrorHandler INSTANCE = new DefaultErrorHandler();

    public static ErrorHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void accept(ErrorResponse error, String requestId) {
        int code = error.getCode();
        String message = "unknown".equals(requestId) ? error.getMessage() : String.format("%s requestId:%s", error.getMessage(), requestId);
        switch (code) {
            case 400: {
                throw new BadRequestException(String.format("%s", message), new Object[0]);
            }
            case 401: {
                throw new NotAuthorizedException("Not authorized: %s", message);
            }
            case 403: {
                throw new ForbiddenException("Forbidden: %s", message);
            }
            case 404: {
                throw new NoSuchResourceException(error.getResourceType(), error.getResourceName(), "%s", message);
            }
            case 405: 
            case 406: {
                break;
            }
            case 409: {
                throw new AlreadyExistsException(error.getResourceType(), error.getResourceName(), "%s", message);
            }
            case 500: {
                throw new ServiceFailureException("Server error: %s", message);
            }
            case 501: {
                throw new NotImplementedException(message, new Object[0]);
            }
            case 503: {
                throw new ServiceUnavailableException("Service unavailable: %s", message);
            }
        }
        throw new RESTException("Unable to process: %s", message);
    }
}

