/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.privilege.PrivilegeChecker;
import org.apache.paimon.privilege.PrivilegedFileStoreTable;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.object.ObjectTable;

public class PrivilegedObjectTable
extends PrivilegedFileStoreTable
implements ObjectTable {
    private final ObjectTable objectTable;

    protected PrivilegedObjectTable(ObjectTable wrapped, PrivilegeChecker privilegeChecker, Identifier identifier) {
        super(wrapped, privilegeChecker, identifier);
        this.objectTable = wrapped;
    }

    @Override
    public String objectLocation() {
        return this.objectTable.objectLocation();
    }

    @Override
    public FileStoreTable underlyingTable() {
        return this.objectTable.underlyingTable();
    }

    @Override
    public FileIO objectFileIO() {
        return this.objectTable.objectFileIO();
    }

    @Override
    public long refresh() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.objectTable.refresh();
    }

    @Override
    public PrivilegedObjectTable copy(Map<String, String> dynamicOptions) {
        return new PrivilegedObjectTable((ObjectTable)this.objectTable.copy((Map)dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedObjectTable copy(TableSchema newTableSchema) {
        return new PrivilegedObjectTable(this.objectTable.copy(newTableSchema), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedObjectTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
        return new PrivilegedObjectTable((ObjectTable)this.objectTable.copyWithoutTimeTravel((Map)dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedObjectTable copyWithLatestSchema() {
        return new PrivilegedObjectTable(this.objectTable.copyWithLatestSchema(), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedObjectTable switchToBranch(String branchName) {
        return new PrivilegedObjectTable(this.objectTable.switchToBranch(branchName), this.privilegeChecker, this.identifier);
    }
}

