/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.SetState;
import org.apache.paimon.lookup.rocksdb.RocksDBState;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.utils.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBSetState<K, V>
extends RocksDBState<K, V, List<byte[]>>
implements SetState<K, V> {
    private static final byte[] EMPTY = new byte[0];

    public RocksDBSetState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(stateFactory, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Override
    public List<V> get(K key) throws IOException {
        ByteArray keyBytes = this.wrap(this.serializeKey(key));
        ArrayList<byte[]> valueBytes = (ArrayList<byte[]>)this.cache.getIfPresent(keyBytes);
        if (valueBytes == null) {
            valueBytes = new ArrayList<byte[]>();
            RocksIterator iterator2 = this.db.newIterator(this.columnFamily);
            Object object = null;
            try {
                iterator2.seek(keyBytes.bytes);
                while (iterator2.isValid() && this.startWithKeyPrefix(keyBytes.bytes, iterator2.key())) {
                    byte[] rawKeyBytes = iterator2.key();
                    byte[] value = Arrays.copyOfRange(rawKeyBytes, keyBytes.bytes.length, rawKeyBytes.length);
                    valueBytes.add(value);
                    iterator2.next();
                }
            }
            catch (Throwable rawKeyBytes) {
                object = rawKeyBytes;
                throw rawKeyBytes;
            }
            finally {
                if (iterator2 != null) {
                    if (object != null) {
                        try {
                            iterator2.close();
                        }
                        catch (Throwable rawKeyBytes) {
                            ((Throwable)object).addSuppressed(rawKeyBytes);
                        }
                    } else {
                        iterator2.close();
                    }
                }
            }
            this.cache.put(keyBytes, valueBytes);
        }
        ArrayList values2 = new ArrayList(valueBytes.size());
        for (byte[] value : valueBytes) {
            this.valueInputView.setBuffer(value);
            values2.add(this.valueSerializer.deserialize(this.valueInputView));
        }
        return values2;
    }

    @Override
    public void retract(K key, V value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            if (this.db.get(this.columnFamily, bytes) != null) {
                this.db.delete(this.columnFamily, this.writeOptions, bytes);
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void add(K key, V value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            this.db.put(this.columnFamily, this.writeOptions, bytes, EMPTY);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private byte[] invalidKeyAndGetKVBytes(K key, V value) throws IOException {
        Preconditions.checkArgument(value != null);
        this.keyOutView.clear();
        this.keySerializer.serialize(key, this.keyOutView);
        this.cache.invalidate(this.wrap(this.keyOutView.getCopyOfBuffer()));
        this.valueSerializer.serialize(value, this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    private boolean startWithKeyPrefix(byte[] keyPrefixBytes, byte[] rawKeyBytes) {
        if (rawKeyBytes.length < keyPrefixBytes.length) {
            return false;
        }
        int i = keyPrefixBytes.length;
        while (--i >= 0) {
            if (rawKeyBytes[i] == keyPrefixBytes[i]) continue;
            return false;
        }
        return true;
    }
}

