/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.Objects;
import org.apache.paimon.iceberg.metadata.IcebergSnapshotSummary;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergSnapshot {
    private static final String FIELD_SEQUENCE_NUMBER = "sequence-number";
    private static final String FIELD_SNAPSHOT_ID = "snapshot-id";
    private static final String FIELD_TIMESTAMP_MS = "timestamp-ms";
    private static final String FIELD_SUMMARY = "summary";
    private static final String FIELD_MANIFEST_LIST = "manifest-list";
    private static final String FIELD_SCHEMA_ID = "schema-id";
    @JsonProperty(value="sequence-number")
    private final long sequenceNumber;
    @JsonProperty(value="snapshot-id")
    private final long snapshotId;
    @JsonProperty(value="timestamp-ms")
    private final long timestampMs;
    @JsonProperty(value="summary")
    private final IcebergSnapshotSummary summary;
    @JsonProperty(value="manifest-list")
    private final String manifestList;
    @JsonProperty(value="schema-id")
    private final int schemaId;

    @JsonCreator
    public IcebergSnapshot(@JsonProperty(value="sequence-number") long sequenceNumber, @JsonProperty(value="snapshot-id") long snapshotId, @JsonProperty(value="timestamp-ms") long timestampMs, @JsonProperty(value="summary") IcebergSnapshotSummary summary, @JsonProperty(value="manifest-list") String manifestList, @JsonProperty(value="schema-id") int schemaId) {
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.timestampMs = timestampMs;
        this.summary = summary;
        this.manifestList = manifestList;
        this.schemaId = schemaId;
    }

    @JsonGetter(value="sequence-number")
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonGetter(value="snapshot-id")
    public long snapshotId() {
        return this.snapshotId;
    }

    @JsonGetter(value="timestamp-ms")
    public long timestampMs() {
        return this.timestampMs;
    }

    @JsonGetter(value="summary")
    public IcebergSnapshotSummary summary() {
        return this.summary;
    }

    @JsonGetter(value="manifest-list")
    public String manifestList() {
        return this.manifestList;
    }

    @JsonGetter(value="schema-id")
    public int schemaId() {
        return this.schemaId;
    }

    public int hashCode() {
        return Objects.hash(this.sequenceNumber, this.snapshotId, this.timestampMs, this.summary, this.manifestList, this.schemaId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergSnapshot)) {
            return false;
        }
        IcebergSnapshot that = (IcebergSnapshot)o;
        return this.sequenceNumber == that.sequenceNumber && this.snapshotId == that.snapshotId && this.timestampMs == that.timestampMs && Objects.equals(this.summary, that.summary) && Objects.equals(this.manifestList, that.manifestList) && this.schemaId == that.schemaId;
    }
}

