/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import org.apache.paimon.format.avro.AvroSchemaVisitor;
import org.apache.paimon.shade.org.apache.avro.LogicalType;
import org.apache.paimon.shade.org.apache.avro.Schema;

public interface AvroSchemaTypelessReader<T>
extends AvroSchemaVisitor<T> {
    default public T visit(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                return this.visitRecord(schema);
            }
            case UNION: {
                return this.visitUnion(schema);
            }
            case ARRAY: {
                return this.visitArray(schema);
            }
            case MAP: {
                return this.visitMap(schema);
            }
        }
        return this.primitive(schema);
    }

    default public T primitive(Schema primitive) {
        LogicalType logicalType = primitive.getLogicalType();
        if (logicalType != null) {
            switch (logicalType.getName()) {
                case "date": 
                case "time-millis": {
                    return this.visitInt();
                }
                case "timestamp-millis": {
                    return this.visitTimestampMillis();
                }
                case "timestamp-micros": {
                    return this.visitTimestampMicros();
                }
                case "decimal": {
                    return this.visitDecimal();
                }
            }
            throw new IllegalArgumentException("Unknown logical type: " + logicalType);
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return this.visitBoolean();
            }
            case INT: {
                return this.visitInt();
            }
            case LONG: {
                return this.visitBigInt();
            }
            case FLOAT: {
                return this.visitFloat();
            }
            case DOUBLE: {
                return this.visitDouble();
            }
            case STRING: {
                return this.visitString();
            }
            case BYTES: {
                return this.visitBytes();
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + primitive);
    }

    public T visitUnion(Schema var1);

    public T visitTimestampMillis();

    public T visitTimestampMicros();

    public T visitDecimal();

    public T visitArray(Schema var1);

    public T visitMap(Schema var1);

    public T visitRecord(Schema var1);
}

