/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.paimon.fileindex.FileIndexerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndexerFactoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexerFactoryUtils.class);
    private static final Map<String, FileIndexerFactory> factories = new HashMap<String, FileIndexerFactory>();

    static FileIndexerFactory load(String type) {
        FileIndexerFactory fileIndexerFactory = factories.get(type);
        if (fileIndexerFactory == null) {
            throw new RuntimeException("Can't find file index for type: " + type);
        }
        return fileIndexerFactory;
    }

    static {
        ServiceLoader<FileIndexerFactory> serviceLoader = ServiceLoader.load(FileIndexerFactory.class);
        for (FileIndexerFactory indexerFactory : serviceLoader) {
            if (factories.put(indexerFactory.identifier(), indexerFactory) == null) continue;
            LOG.warn("Found multiple FileIndexer for type: " + indexerFactory.identifier() + ", choose one of them");
        }
    }
}

