/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fileindex.FileIndexCommon;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexer;
import org.apache.paimon.fileindex.empty.EmptyFileIndexReader;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Pair;

public final class FileIndexFormat {
    private static final long MAGIC = 1493475289347502L;
    private static final int EMPTY_INDEX_FLAG = -1;

    public static Writer createWriter(OutputStream outputStream2) {
        return new Writer(outputStream2);
    }

    public static Reader createReader(SeekableInputStream inputStream2, RowType fileRowType) {
        return new Reader(inputStream2, fileRowType);
    }

    public static class Reader
    implements Closeable {
        private final SeekableInputStream seekableInputStream;
        private final Map<String, Map<String, Pair<Integer, Integer>>> header = new HashMap<String, Map<String, Pair<Integer, Integer>>>();
        private final Map<String, DataField> fields = new HashMap<String, DataField>();

        public Reader(SeekableInputStream seekableInputStream, RowType fileRowType) {
            this.seekableInputStream = seekableInputStream;
            DataInputStream dataInputStream = new DataInputStream(seekableInputStream);
            fileRowType.getFields().forEach(field -> this.fields.put(field.name(), (DataField)field));
            try {
                long magic = dataInputStream.readLong();
                if (magic != 1493475289347502L) {
                    throw new RuntimeException("This file is not file index file.");
                }
                int version = dataInputStream.readInt();
                if (version != Version.V_1.version()) {
                    throw new RuntimeException("This index file is version of " + version + ", not in supported version list [" + Version.V_1.version() + "]");
                }
                int headLength = dataInputStream.readInt();
                byte[] head = new byte[headLength - 8 - 4 - 4];
                dataInputStream.readFully(head);
                try (DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(head));){
                    int columnSize = dataInput.readInt();
                    for (int i = 0; i < columnSize; ++i) {
                        String columnName = dataInput.readUTF();
                        int indexSize = dataInput.readInt();
                        Map indexMap = this.header.computeIfAbsent(columnName, n -> new HashMap());
                        for (int j = 0; j < indexSize; ++j) {
                            indexMap.put(dataInput.readUTF(), Pair.of(dataInput.readInt(), dataInput.readInt()));
                        }
                    }
                }
            }
            catch (IOException e) {
                IOUtils.closeQuietly(seekableInputStream);
                throw new RuntimeException("Exception happens while construct file index reader.", e);
            }
        }

        public Set<FileIndexReader> readColumnIndex(String columnName) {
            return Optional.ofNullable(this.header.getOrDefault(columnName, null)).map(f -> f.entrySet().stream().map(entry -> this.getFileIndexReader(columnName, (String)entry.getKey(), (Pair)entry.getValue())).collect(Collectors.toSet())).orElse(Collections.emptySet());
        }

        private FileIndexReader getFileIndexReader(String columnName, String indexType, Pair<Integer, Integer> startAndLength) {
            if (startAndLength.getLeft() == -1) {
                return EmptyFileIndexReader.INSTANCE;
            }
            return FileIndexer.create(indexType, FileIndexCommon.getFieldType(this.fields, columnName), new Options()).createReader(this.seekableInputStream, startAndLength.getLeft(), startAndLength.getRight());
        }

        private byte[] getBytesWithStartAndLength(Pair<Integer, Integer> startAndLength) {
            byte[] b = new byte[startAndLength.getRight().intValue()];
            try {
                int count;
                this.seekableInputStream.seek(startAndLength.getLeft().intValue());
                int len = b.length;
                for (int n = 0; n < len; n += count) {
                    count = this.seekableInputStream.read(b, n, len - n);
                    if (count >= 0) continue;
                    throw new EOFException();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return b;
        }

        public Map<String, Map<String, byte[]>> readAll() {
            HashMap<String, Map<String, byte[]>> result = new HashMap<String, Map<String, byte[]>>();
            for (Map.Entry<String, Map<String, Pair<Integer, Integer>>> entryOuter : this.header.entrySet()) {
                for (Map.Entry<String, Pair<Integer, Integer>> entryInner : entryOuter.getValue().entrySet()) {
                    result.computeIfAbsent(entryOuter.getKey(), key -> new HashMap()).put(entryInner.getKey(), this.getBytesWithStartAndLength(entryInner.getValue()));
                }
            }
            return result;
        }

        @VisibleForTesting
        Optional<byte[]> getBytesWithNameAndType(String columnName, String indexType) {
            return Optional.ofNullable(this.header.getOrDefault(columnName, null)).map(i -> i.getOrDefault(indexType, null)).map(this::getBytesWithStartAndLength);
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.seekableInputStream);
        }
    }

    public static class Writer
    implements Closeable {
        private final DataOutputStream dataOutputStream;
        private static final int REDUNDANT_LENGTH = 0;

        public Writer(OutputStream outputStream2) {
            this.dataOutputStream = new DataOutputStream(outputStream2);
        }

        public void writeColumnIndexes(Map<String, Map<String, byte[]>> indexes) throws IOException {
            LinkedHashMap<String, Map<String, Pair<Integer, Integer>>> bodyInfo = new LinkedHashMap<String, Map<String, Pair<Integer, Integer>>>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            for (Map.Entry<String, Map<String, byte[]>> columnMap : indexes.entrySet()) {
                Map innerMap = bodyInfo.computeIfAbsent(columnMap.getKey(), k -> new LinkedHashMap());
                Map<String, byte[]> bytesMap = columnMap.getValue();
                for (Map.Entry<String, byte[]> entry : bytesMap.entrySet()) {
                    int startPosition = baos.size();
                    byte[] v = entry.getValue();
                    if (v == null) {
                        innerMap.put(entry.getKey(), Pair.of(-1, 0));
                        continue;
                    }
                    baos.write(entry.getValue());
                    innerMap.put(entry.getKey(), Pair.of(startPosition, baos.size() - startPosition));
                }
            }
            byte[] body = baos.toByteArray();
            this.writeHead(bodyInfo);
            this.dataOutputStream.write(body);
        }

        private void writeHead(Map<String, Map<String, Pair<Integer, Integer>>> bodyInfo) throws IOException {
            int headLength = this.calculateHeadLength(bodyInfo);
            this.dataOutputStream.writeLong(1493475289347502L);
            this.dataOutputStream.writeInt(Version.V_1.version());
            this.dataOutputStream.writeInt(headLength);
            this.dataOutputStream.writeInt(bodyInfo.size());
            for (Map.Entry<String, Map<String, Pair<Integer, Integer>>> entry : bodyInfo.entrySet()) {
                this.dataOutputStream.writeUTF(entry.getKey());
                this.dataOutputStream.writeInt(entry.getValue().size());
                for (Map.Entry<String, Pair<Integer, Integer>> indexEntry : entry.getValue().entrySet()) {
                    this.dataOutputStream.writeUTF(indexEntry.getKey());
                    int start = indexEntry.getValue().getLeft();
                    this.dataOutputStream.writeInt(start == -1 ? -1 : start + headLength);
                    this.dataOutputStream.writeInt(indexEntry.getValue().getRight());
                }
            }
            this.dataOutputStream.writeInt(0);
        }

        private int calculateHeadLength(Map<String, Map<String, Pair<Integer, Integer>>> bodyInfo) throws IOException {
            int baseLength = 20 + bodyInfo.values().stream().mapToInt(Map::size).sum() * 8 + bodyInfo.size() * 4 + 4;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(baos);
            for (Map.Entry<String, Map<String, Pair<Integer, Integer>>> entry : bodyInfo.entrySet()) {
                dataOutput.writeUTF(entry.getKey());
                for (String s : entry.getValue().keySet()) {
                    dataOutput.writeUTF(s);
                }
            }
            return baseLength + baos.size();
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.dataOutputStream);
        }
    }

    static enum Version {
        V_1(1);

        private final int version;

        private Version(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }
    }
}

