/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.disk.BufferFileReader;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.memory.Buffer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MutableObjectIterator;

public class ChannelReaderInputView
extends AbstractPagedInputView {
    private final BlockDecompressor decompressor;
    private final BufferFileReader reader;
    private final MemorySegment uncompressedBuffer;
    private final MemorySegment compressedBuffer;
    private int numBlocksRemaining;
    private int currentSegmentLimit;

    public ChannelReaderInputView(FileIOChannel.ID id, IOManager ioManager, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int numBlocks) throws IOException {
        this.numBlocksRemaining = numBlocks;
        this.reader = ioManager.createBufferFileReader(id);
        this.uncompressedBuffer = MemorySegment.wrap(new byte[compressionBlockSize]);
        this.decompressor = compressionCodecFactory.getDecompressor();
        this.compressedBuffer = MemorySegment.wrap(new byte[compressionCodecFactory.getCompressor().getMaxCompressedSize(compressionBlockSize)]);
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        Buffer buffer = Buffer.create(this.compressedBuffer);
        this.reader.readInto(buffer);
        this.currentSegmentLimit = this.decompressor.decompress(buffer.getMemorySegment().getArray(), 0, buffer.getSize(), this.uncompressedBuffer.getArray(), 0);
        --this.numBlocksRemaining;
        return this.uncompressedBuffer;
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.currentSegmentLimit;
    }

    public List<MemorySegment> close() throws IOException {
        this.reader.close();
        return Collections.emptyList();
    }

    public FileIOChannel getChannel() {
        return this.reader;
    }

    public MutableObjectIterator<BinaryRow> createBinaryRowIterator(BinaryRowSerializer serializer) {
        return new BinaryRowChannelInputViewIterator(serializer);
    }

    private class BinaryRowChannelInputViewIterator
    implements MutableObjectIterator<BinaryRow> {
        protected final BinaryRowSerializer serializer;

        public BinaryRowChannelInputViewIterator(BinaryRowSerializer serializer) {
            this.serializer = serializer;
        }

        @Override
        public BinaryRow next(BinaryRow reuse) throws IOException {
            try {
                return this.serializer.deserializeFromPages(reuse, (AbstractPagedInputView)ChannelReaderInputView.this);
            }
            catch (EOFException e) {
                ChannelReaderInputView.this.close();
                return null;
            }
        }

        @Override
        public BinaryRow next() throws IOException {
            throw new UnsupportedOperationException("This method is disabled due to performance issue!");
        }
    }
}

