/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.paimon.codegen.CodeGenLoader;
import org.apache.paimon.codegen.GeneratedClass;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.shade.guava30.com.google.common.cache.Cache;
import org.apache.paimon.shade.guava30.com.google.common.cache.CacheBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class CodeGenUtils {
    private static final Cache<ClassKey, Pair<Class<?>, Object[]>> COMPILED_CLASS_CACHE = CacheBuilder.newBuilder().maximumSize(300L).softValues().build();
    public static final Projection EMPTY_PROJECTION = input -> BinaryRow.EMPTY_ROW;

    public static Projection newProjection(RowType inputType, List<String> fields) {
        List<String> fieldNames = inputType.getFieldNames();
        int[] mapping = fields.stream().mapToInt(fieldNames::indexOf).toArray();
        return CodeGenUtils.newProjection(inputType, mapping);
    }

    public static Projection newProjection(RowType inputType, int[] mapping) {
        if (mapping.length == 0) {
            return EMPTY_PROJECTION;
        }
        return (Projection)CodeGenUtils.generate(Projection.class, inputType.getFieldTypes(), mapping, () -> CodeGenLoader.getCodeGenerator().generateProjection(inputType, mapping));
    }

    public static NormalizedKeyComputer newNormalizedKeyComputer(List<DataType> inputTypes, int[] sortFields) {
        return (NormalizedKeyComputer)CodeGenUtils.generate(NormalizedKeyComputer.class, inputTypes, sortFields, () -> CodeGenLoader.getCodeGenerator().generateNormalizedKeyComputer(inputTypes, sortFields));
    }

    public static RecordComparator newRecordComparator(List<DataType> inputTypes) {
        return CodeGenUtils.newRecordComparator(inputTypes, IntStream.range(0, inputTypes.size()).toArray(), true);
    }

    public static RecordComparator newRecordComparator(List<DataType> inputTypes, int[] sortFields, boolean isAscendingOrder) {
        return (RecordComparator)CodeGenUtils.generate(RecordComparator.class, inputTypes, sortFields, () -> CodeGenLoader.getCodeGenerator().generateRecordComparator(inputTypes, sortFields, isAscendingOrder));
    }

    public static RecordEqualiser newRecordEqualiser(List<DataType> fieldTypes) {
        return CodeGenUtils.newRecordEqualiser(fieldTypes, IntStream.range(0, fieldTypes.size()).toArray());
    }

    public static RecordEqualiser newRecordEqualiser(List<DataType> fieldTypes, int[] fields) {
        return (RecordEqualiser)CodeGenUtils.generate(RecordEqualiser.class, fieldTypes, fields, () -> CodeGenLoader.getCodeGenerator().generateRecordEqualiser(fieldTypes, fields));
    }

    private static <T> T generate(Class<?> classType, List<DataType> fields, int[] fieldsIndex, Supplier<GeneratedClass<T>> supplier) {
        ClassKey classKey = new ClassKey(classType, fields, fieldsIndex);
        try {
            Pair result = COMPILED_CLASS_CACHE.get(classKey, () -> CodeGenUtils.generateClass(supplier));
            return GeneratedClass.newInstance((Class)result.getLeft(), (Object[])result.getRight());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate generated class '" + classType + "'", e);
        }
    }

    private static <T> Pair<Class<?>, Object[]> generateClass(Supplier<GeneratedClass<T>> supplier) {
        long time = System.currentTimeMillis();
        while (true) {
            try {
                GeneratedClass<T> generatedClass = supplier.get();
                return Pair.of(generatedClass.compile(CodeGenUtils.class.getClassLoader()), generatedClass.getReferences());
            }
            catch (OutOfMemoryError error) {
                System.gc();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw error;
                }
                OutOfMemoryError toThrow = error;
                if (System.currentTimeMillis() - time < 120000L) continue;
                throw toThrow;
            }
            break;
        }
    }

    private static class ClassKey {
        private final Class<?> classType;
        private final List<DataType> fields;
        private final int[] fieldsIndex;

        public ClassKey(Class<?> classType, List<DataType> fields, int[] fieldsIndex) {
            this.classType = classType;
            this.fields = fields;
            this.fieldsIndex = fieldsIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassKey classKey = (ClassKey)o;
            return Objects.equals(this.classType, classKey.classType) && Objects.equals(this.fields, classKey.fields) && Arrays.equals(this.fieldsIndex, classKey.fieldsIndex);
        }

        public int hashCode() {
            int result = Objects.hash(this.classType, this.fields);
            result = 31 * result + Arrays.hashCode(this.fieldsIndex);
            return result;
        }
    }
}

