/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.internal.PropagatorBasedSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerRecordGetter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaReceiveRequest;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaBatchProcessSpanLinksExtractor
implements SpanLinksExtractor<KafkaReceiveRequest> {
    private final SpanLinksExtractor<KafkaProcessRequest> singleRecordLinkExtractor;

    KafkaBatchProcessSpanLinksExtractor(TextMapPropagator propagator) {
        this.singleRecordLinkExtractor = new PropagatorBasedSpanLinksExtractor(propagator, (TextMapGetter)KafkaConsumerRecordGetter.INSTANCE);
    }

    public void extract(SpanLinksBuilder spanLinks, Context parentContext, KafkaReceiveRequest request) {
        for (ConsumerRecord record : request.getRecords()) {
            this.singleRecordLinkExtractor.extract(spanLinks, Context.root(), (Object)KafkaProcessRequest.create(record, request.getConsumerGroup(), request.getClientId()));
        }
    }
}

