/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingLimitDecorator
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(TracingLimitDecorator.class);
    private final Limit delegate;

    public static TracingLimitDecorator wrap(Limit delegate) {
        return new TracingLimitDecorator(delegate);
    }

    public TracingLimitDecorator(Limit delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getLimit() {
        return this.delegate.getLimit();
    }

    @Override
    public void onSample(long startTime, long rtt, int inflight, boolean didDrop) {
        LOG.debug("maxInFlight={} minRtt={} ms", (Object)inflight, (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
        this.delegate.onSample(startTime, rtt, inflight, didDrop);
    }

    @Override
    public void notifyOnChange(Consumer<Integer> consumer) {
        this.delegate.notifyOnChange(consumer);
    }
}

