/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.QueryBuilder;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.tasks.AbstractTelemetryTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelemetryMatViewTask
implements AbstractTelemetryTask {
    public static final String NAME = "MAT VIEW TELEMETRY";
    public static final String TABLE_NAME = "telemetry_mat_view";
    public static final Telemetry.TelemetryTypeBuilder<TelemetryMatViewTask> MAT_VIEW_TELEMETRY = configuration -> {
        final String tableName = String.valueOf(configuration.getSystemTableNamePrefix()) + TABLE_NAME;
        return new Telemetry.TelemetryType<TelemetryMatViewTask>(){

            @Override
            public QueryBuilder getCreateSql(QueryBuilder builder) {
                return builder.$("CREATE TABLE IF NOT EXISTS '").$(tableName).$("' (created TIMESTAMP, event SHORT, view_table_id INT, base_table_txn LONG, invalidation_reason VARCHAR, latency FLOAT ) TIMESTAMP(created) PARTITION BY DAY TTL 1 WEEK BYPASS WAL");
            }

            @Override
            public String getName() {
                return TelemetryMatViewTask.NAME;
            }

            @Override
            public String getTableName() {
                return tableName;
            }

            @Override
            public ObjectFactory<TelemetryMatViewTask> getTaskFactory() {
                return () -> new TelemetryMatViewTask();
            }
        };
    };
    private static final Log LOG = LogFactory.getLog(TelemetryMatViewTask.class);
    private final Utf8StringSink invalidationReason = new Utf8StringSink();
    private long baseTableTxn;
    private short event;
    private float latency;
    private long queueCursor;
    private int viewTableId;

    private TelemetryMatViewTask() {
    }

    public static void store(@NotNull Telemetry<TelemetryMatViewTask> telemetry, short event, int viewTableId, long baseTableTxn, @Nullable CharSequence errorMessage, long latencyUs) {
        TelemetryMatViewTask task = telemetry.nextTask();
        if (task != null) {
            task.event = event;
            task.viewTableId = viewTableId;
            task.baseTableTxn = baseTableTxn;
            task.invalidationReason.clear();
            task.invalidationReason.put(errorMessage);
            task.latency = (float)latencyUs / 1000.0f;
            telemetry.store(task);
        }
    }

    @Override
    public long getQueueCursor() {
        return this.queueCursor;
    }

    @Override
    public void setQueueCursor(long cursor) {
        this.queueCursor = cursor;
    }

    @Override
    public void writeTo(TableWriter writer, long timestamp) {
        try {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putShort(1, this.event);
            row.putInt(2, this.viewTableId);
            row.putLong(3, this.baseTableTxn);
            row.putVarchar(4, this.invalidationReason);
            row.putFloat(5, this.latency);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new ").$(TABLE_NAME).$(" row [errno=").$(e.getErrno()).$(", error=").$safe(e.getFlyweightMessage()).$(']').$();
        }
    }
}

