/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.io.Closeable;

public class PagedDirectLongList
implements Closeable {
    private final int memoryTag;
    private final ObjList<DirectLongList> pages = new ObjList();
    private int blockSize;
    private int pageCapacity;

    public PagedDirectLongList(int memoryTag) {
        this.memoryTag = memoryTag;
    }

    public long allocateBlock() {
        DirectLongList page;
        int currentPage = this.pages.size() - 1;
        if (this.pages.size() > 0 && (page = this.pages.get(currentPage)).size() + (long)this.blockSize < page.getCapacity()) {
            page.setPos(page.size() + (long)this.blockSize);
            return page.getAddress() + (page.size() - (long)this.blockSize) * 8L;
        }
        page = new DirectLongList(this.pageCapacity, this.memoryTag);
        this.pages.add(page);
        page.setPos(page.size() + (long)this.blockSize);
        return page.getAddress() + (page.size() - (long)this.blockSize) * 8L;
    }

    public void clear() {
        if (this.pages.size() > 0) {
            int n = this.pages.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.pages.get(i).close();
                    continue;
                }
                this.pages.getQuick(i).clear();
            }
            this.pages.setPos(1);
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.pages);
    }

    public long getBlockAddress(long blockIndex) {
        int blockPage = Numbers.decodeLowInt(blockIndex);
        long offset = Numbers.decodeHighInt(blockIndex);
        return this.pages.getQuick(blockPage).getAddress() + offset * 8L;
    }

    public long nextBlockIndex(long prevBlockIndex) {
        int prevBlockOffset;
        int blockPage = prevBlockIndex < 0L ? 0 : Numbers.decodeLowInt(prevBlockIndex);
        long newIndex = this.getBlockIndex(this.blockSize, blockPage, (prevBlockOffset = prevBlockIndex < 0L ? -this.blockSize : Numbers.decodeHighInt(prevBlockIndex)) + this.blockSize);
        if (newIndex > -1L) {
            return newIndex;
        }
        return this.getBlockIndex(this.blockSize, ++blockPage, 0);
    }

    public void setBlockSize(int blockSize) {
        if (this.pages.size() > 1 || this.pages.size() == 1 && this.pages.getQuick(0).size() > 0L) {
            throw new UnsupportedOperationException("list must be clear when changing block size");
        }
        this.blockSize = blockSize;
        this.pageCapacity = Math.max(blockSize, 4096 / blockSize * blockSize);
    }

    private long getBlockIndex(int blockSize, int blockPage, int probeOffset) {
        DirectLongList page;
        if (blockPage < this.pages.size() && (page = this.pages.getQuick(blockPage)).size() >= (long)(probeOffset + blockSize)) {
            return Numbers.encodeLowHighInts(blockPage, probeOffset);
        }
        return -1L;
    }
}

