/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.IntGroupSort;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IntList
implements Mutable,
Sinkable {
    public static final int NO_ENTRY_VALUE = -1;
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final int[] EMPTY_ARRAY = new int[0];
    private final int initialCapacity;
    private int[] data;
    private int pos = 0;

    public IntList() {
        this(16);
    }

    public IntList(int capacity) {
        this.initialCapacity = capacity;
        this.data = capacity == 0 ? EMPTY_ARRAY : new int[this.initialCapacity];
    }

    public IntList(IntList source) {
        this(source.size());
        this.addAll(source);
    }

    public void add(int value) {
        this.checkCapacity(this.pos + 1);
        this.data[this.pos++] = value;
    }

    public void addAll(IntList that) {
        int p = this.pos;
        int s = that.size();
        this.setPos(p + s);
        System.arraycopy(that.data, 0, this.data, p, s);
    }

    public void allocate(int size) {
        this.checkCapacity(size);
    }

    public void arrayCopy(int srcPos, int dstPos, int length) {
        System.arraycopy(this.data, srcPos, this.data, dstPos, length);
    }

    public int binarySearchUniqueList(int v) {
        int low = 0;
        int high = this.pos - 1;
        while (high - low > 65) {
            int mid = low + high >>> 1;
            int midVal = this.data[mid];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this.scanSearch(v, low, high + 1);
    }

    public int capacity() {
        return this.data.length;
    }

    public void checkCapacity(int capacity) {
        int l = this.data.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            this.data = Arrays.copyOf(this.data, newCap);
        }
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void clear(int capacity) {
        this.checkCapacity(capacity);
        this.pos = 0;
        Arrays.fill(this.data, -1);
    }

    public boolean contains(int value) {
        return this.indexOf(value, 0, this.pos) > -1;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof IntList && this.equals((IntList)that);
    }

    public void extendAndSet(int index, int value) {
        this.checkCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.data[index] = value;
    }

    public int get(int index) {
        return this.getQuick(index);
    }

    public int getLast() {
        if (this.pos > 0) {
            return this.data[this.pos - 1];
        }
        return -1;
    }

    public int getQuick(int index) {
        assert (index >= 0) : "negative index";
        assert (index < this.pos) : String.format("index %,d out of bounds for list size %,d", index, this.pos);
        return this.data[index];
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            int v = this.getQuick(i);
            hashCode = 31 * hashCode + (v == -1 ? 0 : v);
        }
        return hashCode;
    }

    public void increment(int index) {
        this.data[index] = this.data[index] + 1;
    }

    public void increment(int index, int delta) {
        assert (delta > -1);
        this.data[index] = this.data[index] + delta;
    }

    public int indexOf(int v, int low, int high) {
        assert (high <= this.pos);
        for (int i = low; i < high; ++i) {
            int f = this.data[i];
            if (f != v) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, int element) {
        this.setPos(++this.pos);
        System.arraycopy(this.data, index, this.data, index + 1, this.pos - index - 1);
        this.data[index] = element;
    }

    public int postIncrement(int index) {
        int prev = this.data[index];
        this.data[index] = prev + 1;
        return prev;
    }

    public void remove(int key) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (key != this.getQuick(i)) continue;
            this.removeIndex(i);
            return;
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, move);
        }
        int index1 = --this.pos;
        this.data[index1] = -1;
    }

    public void restoreInitialCapacity() {
        this.data = new int[this.initialCapacity];
        this.pos = 0;
    }

    public void reverse() {
        int len = this.size();
        int mid = len / 2;
        for (int index = 0; index < mid; ++index) {
            int temp = this.get(index);
            this.set(index, this.get(len - index - 1));
            this.set(len - index - 1, temp);
        }
    }

    public void rshift(int level) {
        if (level == 0) {
            return;
        }
        assert (level > 0);
        int newCapacityRequired = this.pos + level;
        if (newCapacityRequired > this.data.length) {
            int[] buf = new int[newCapacityRequired];
            System.arraycopy(this.data, 0, buf, level, this.pos);
            this.data = buf;
        } else {
            System.arraycopy(this.data, 0, this.data, level, this.pos);
        }
        Arrays.fill(this.data, 0, level, -1);
        this.pos += level;
    }

    public void set(int index, int element) {
        if (index < this.pos) {
            this.data[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, int value) {
        this.checkCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.data, 0, this.pos, value);
    }

    public void setPos(int position) {
        this.checkCapacity(position);
        this.pos = position;
    }

    public void setQuick(int index, int value) {
        assert (index < this.pos);
        this.data[index] = value;
    }

    public int size() {
        return this.pos;
    }

    public void sortGroups(int groupSize) {
        if (groupSize > 0 && this.pos % groupSize == 0) {
            IntGroupSort.quickSort(groupSize, this.data, 0, this.pos / groupSize);
            return;
        }
        throw new IllegalStateException("sorting not supported for group size: " + groupSize + ", length: " + this.pos);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.putAscii(',');
            }
            sink.put(this.get(i));
        }
        sink.putAscii(']');
    }

    public void toSink(CharSink<?> sink, int exceptValue) {
        sink.putAscii('[');
        boolean pastFirst = false;
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            int val;
            if (pastFirst) {
                sink.putAscii(',');
            }
            if ((val = this.get(i)) == exceptValue) continue;
            sink.put(val);
            pastFirst = true;
        }
        sink.putAscii(']');
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalSink();
        this.toSink(b);
        return ((Object)b).toString();
    }

    public void zero(int value) {
        Arrays.fill(this.data, 0, this.pos, value);
    }

    private boolean equals(IntList that) {
        if (this.pos != that.pos) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (this.getQuick(i) == that.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    private int scanSearch(int v, int low, int high) {
        for (int i = low; i < high; ++i) {
            int f = this.data[i];
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(high + 1);
    }
}

