/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.std.Misc;

class ExceptRecordCursor
extends AbstractSetRecordCursor {
    private final Map mapA;
    private final Map mapB;
    private final RecordSink recordSink;
    private boolean isCursorBHashed;
    private boolean isOpen;
    private Record recordA;
    private Record recordB;

    public ExceptRecordCursor(Map mapA, Map mapB, RecordSink recordSink) {
        this.mapA = mapA;
        this.mapB = mapB;
        this.recordSink = recordSink;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.mapA.close();
            this.mapB.close();
            super.close();
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.cursorA.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.cursorA.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isCursorBHashed) {
            this.hashCursorB();
            this.toTop();
            this.isCursorBHashed = true;
        }
        while (this.cursorA.hasNext()) {
            MapKey keyB = this.mapB.withKey();
            keyB.put(this.recordA, this.recordSink);
            if (keyB.notFound()) {
                MapKey keyA = this.mapA.withKey();
                keyA.put(this.recordA, this.recordSink);
                if (keyA.create()) {
                    return true;
                }
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.cursorA.newSymbolTable(columnIndex);
    }

    @Override
    public long preComputedStateSize() {
        return RecordCursor.fromBool(this.isCursorBHashed);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursorA.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.cursorA.toTop();
        this.mapA.clear();
    }

    private void hashCursorB() {
        while (this.cursorB.hasNext()) {
            MapKey keyB = this.mapB.withKey();
            keyB.put(this.recordB, this.recordSink);
            keyB.createValue();
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        this.cursorB = Misc.free(this.cursorB);
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        if (!this.isOpen) {
            this.isOpen = true;
            this.mapA.reopen();
            this.mapB.reopen();
        }
        super.of(cursorA, cursorB, circuitBreaker);
        this.recordA = cursorA.getRecord();
        this.recordB = cursorB.getRecord();
        this.isCursorBHashed = false;
    }
}

