/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;
import io.questdb.tasks.TableWriterTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOperation
implements AsyncWriterCommand,
QuietCloseable {
    private static final long NO_CORRELATION_ID = -1L;
    @Nullable
    protected TableToken tableToken;
    @Nullable
    SecurityContext securityContext;
    @Nullable
    SqlExecutionContext sqlExecutionContext;
    @Nullable
    CharSequence sqlText;
    int tableNamePosition;
    private String cmdName;
    private int cmdType;
    private long correlationId;
    private int tableId;
    private long tableVersion;

    public void clearCommandCorrelationId() {
        this.setCommandCorrelationId(-1L);
    }

    public void clearSecurityContext() {
        Misc.clear(this.securityContext);
    }

    @Override
    public void close() {
    }

    @Override
    public int getCmdType() {
        return this.cmdType;
    }

    @Override
    public String getCommandName() {
        return this.cmdName;
    }

    @Override
    public long getCorrelationId() {
        return this.correlationId;
    }

    @Nullable
    public SqlExecutionContext getSqlExecutionContext() {
        return this.sqlExecutionContext;
    }

    @Nullable
    public CharSequence getSqlText() {
        return this.sqlText;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public int getTableNamePosition() {
        return this.tableNamePosition;
    }

    @Override
    @NotNull
    public TableToken getTableToken() {
        assert (this.tableToken != null) : "initialized operation";
        return this.tableToken;
    }

    @Override
    public long getTableVersion() {
        return this.tableVersion;
    }

    @Override
    public void serialize(TableWriterTask task) {
        task.of(this.cmdType, this.tableId, this.tableToken);
        task.setInstance(this.correlationId);
    }

    @Override
    public void setCommandCorrelationId(long correlationId) {
        this.correlationId = correlationId;
    }

    public void withContext(@NotNull SqlExecutionContext sqlExecutionContext) {
        this.sqlExecutionContext = sqlExecutionContext;
        this.securityContext = sqlExecutionContext.getSecurityContext();
    }

    public void withSecurityContext(@Nullable SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void withSqlStatement(CharSequence sqlStatement) {
        this.sqlText = sqlStatement;
    }

    void init(int cmdType, String cmdName, TableToken tableToken, int tableId, long tableVersion, int tableNamePosition) {
        this.cmdType = cmdType;
        this.cmdName = cmdName;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.tableVersion = tableVersion;
        this.tableNamePosition = tableNamePosition;
        this.correlationId = -1L;
    }

    public boolean isForceWalBypass() {
        return false;
    }
}

