/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SingleRecordSink;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TimeFrame;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractAsOfJoinFastRecordCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.table.SelectedRecordCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilteredAsOfJoinFastRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final FilteredAsOfJoinKeyedFastRecordCursor cursor;
    private final RecordSink masterKeySink;
    private final SelectedRecordCursorFactory.SelectedTimeFrameCursor selectedTimeFrameCursor;
    private final RecordSink slaveKeySink;
    private final Function slaveRecordFilter;
    private final long toleranceInterval;
    private boolean origHasSlave;

    public FilteredAsOfJoinFastRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull RecordCursorFactory masterFactory, @NotNull RecordSink masterKeySink, @NotNull RecordCursorFactory slaveFactory, @NotNull RecordSink slaveKeySink, @NotNull Function slaveRecordFilter, int columnSplit, @NotNull Record slaveNullRecord, @Nullable IntList slaveColumnCrossIndex, int slaveTimestampIndex, long toleranceInterval) {
        super(metadata, null, masterFactory, slaveFactory);
        assert (slaveFactory.supportsTimeFrameCursor());
        this.slaveRecordFilter = slaveRecordFilter;
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        long maxSinkTargetHeapSize = (long)configuration.getSqlHashJoinValuePageSize() * (long)configuration.getSqlHashJoinValueMaxPages();
        this.cursor = new FilteredAsOfJoinKeyedFastRecordCursor(columnSplit, slaveNullRecord, masterFactory.getMetadata().getTimestampIndex(), new SingleRecordSink(maxSinkTargetHeapSize, 50), slaveTimestampIndex, new SingleRecordSink(maxSinkTargetHeapSize, 50), configuration.getSqlAsOfJoinLookAhead());
        this.selectedTimeFrameCursor = slaveColumnCrossIndex != null && SelectedRecordCursorFactory.isCrossedIndex(slaveColumnCrossIndex) ? new SelectedRecordCursorFactory.SelectedTimeFrameCursor(slaveColumnCrossIndex, slaveFactory.recordCursorSupportsRandomAccess()) : null;
        this.toleranceInterval = toleranceInterval;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        TimeFrameRecordCursor slaveCursor = null;
        try {
            TimeFrameRecordCursor baseTimeFrameCursor = this.slaveFactory.getTimeFrameCursor(executionContext);
            Record filterRecord = baseTimeFrameCursor.getRecordB();
            this.slaveRecordFilter.init(baseTimeFrameCursor, executionContext);
            slaveCursor = this.selectedTimeFrameCursor == null ? baseTimeFrameCursor : this.selectedTimeFrameCursor.of(baseTimeFrameCursor);
            this.cursor.of(masterCursor, slaveCursor, filterRecord, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Filtered AsOf Join Fast Scan");
        sink.attr("filter").val(this.slaveRecordFilter, this.slaveFactory);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.slaveRecordFilter);
    }

    private class FilteredAsOfJoinKeyedFastRecordCursor
    extends AbstractAsOfJoinFastRecordCursor {
        private final SingleRecordSink masterSinkTarget;
        private final SingleRecordSink slaveSinkTarget;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private Record filterRecord;
        private int unfilteredCursorFrameIndex;
        private long unfilteredRecordRowId;

        public FilteredAsOfJoinKeyedFastRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, SingleRecordSink masterSinkTarget, int slaveTimestampIndex, SingleRecordSink slaveSinkTarget, int lookahead) {
            super(columnSplit, nullRecord, masterTimestampIndex, slaveTimestampIndex, lookahead);
            this.unfilteredCursorFrameIndex = -1;
            this.unfilteredRecordRowId = -1L;
            this.masterSinkTarget = masterSinkTarget;
            this.slaveSinkTarget = slaveSinkTarget;
        }

        @Override
        public void close() {
            super.close();
            this.masterSinkTarget.close();
            this.slaveSinkTarget.close();
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (!this.masterHasNext) {
                return false;
            }
            long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
            TimeFrame timeFrame = this.slaveTimeFrameCursor.getTimeFrame();
            this.record.hasSlave(FilteredAsOfJoinFastRecordCursorFactory.this.origHasSlave);
            if (this.unfilteredRecordRowId != -1L && this.slaveRecB.getRowId() != this.unfilteredRecordRowId) {
                this.slaveTimeFrameCursor.recordAt(this.slaveRecB, this.unfilteredRecordRowId);
            }
            if (!(this.unfilteredCursorFrameIndex == -1 || timeFrame.getFrameIndex() == this.unfilteredCursorFrameIndex && timeFrame.isOpen())) {
                this.slaveTimeFrameCursor.jumpTo(this.unfilteredCursorFrameIndex);
                this.slaveTimeFrameCursor.open();
            }
            if (masterTimestamp >= this.lookaheadTimestamp) {
                this.nextSlave(masterTimestamp);
                FilteredAsOfJoinFastRecordCursorFactory.this.origHasSlave = this.record.hasSlave();
                this.unfilteredRecordRowId = this.slaveRecB.getRowId();
                this.unfilteredCursorFrameIndex = timeFrame.getFrameIndex();
            }
            this.isMasterHasNextPending = true;
            if (!this.record.hasSlave()) {
                return true;
            }
            this.masterSinkTarget.clear();
            FilteredAsOfJoinFastRecordCursorFactory.this.masterKeySink.copy(this.masterRecord, this.masterSinkTarget);
            long rowId = this.slaveRecB.getRowId();
            int initialFilteredFrameIndex = Rows.toPartitionIndex(rowId);
            long initialFilteredRowId = Rows.toLocalRowID(rowId);
            this.slaveTimeFrameCursor.jumpTo(initialFilteredFrameIndex);
            this.slaveTimeFrameCursor.open();
            long currentFrameLo = timeFrame.getRowLo();
            long filteredRowId = initialFilteredRowId;
            while (true) {
                long slaveTimestamp = this.slaveRecB.getTimestamp(this.slaveTimestampIndex);
                if (FilteredAsOfJoinFastRecordCursorFactory.this.toleranceInterval != Long.MIN_VALUE && slaveTimestamp < masterTimestamp - FilteredAsOfJoinFastRecordCursorFactory.this.toleranceInterval) {
                    this.record.hasSlave(false);
                    break;
                }
                if (FilteredAsOfJoinFastRecordCursorFactory.this.slaveRecordFilter.getBool(this.filterRecord)) {
                    this.slaveSinkTarget.clear();
                    FilteredAsOfJoinFastRecordCursorFactory.this.slaveKeySink.copy(this.slaveRecB, this.slaveSinkTarget);
                    if (this.masterSinkTarget.memeq(this.slaveSinkTarget)) break;
                }
                if (--filteredRowId < currentFrameLo) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    if (!this.slaveTimeFrameCursor.prev()) {
                        this.record.hasSlave(false);
                        break;
                    }
                    this.slaveTimeFrameCursor.open();
                    int filteredFrameIndex = timeFrame.getFrameIndex();
                    filteredRowId = timeFrame.getRowHi() - 1L;
                    currentFrameLo = timeFrame.getRowLo();
                    this.slaveTimeFrameCursor.recordAt(this.slaveRecB, Rows.toRowID(filteredFrameIndex, filteredRowId));
                }
                this.slaveTimeFrameCursor.recordAtRowIndex(this.slaveRecB, filteredRowId);
            }
            return true;
        }

        public void of(RecordCursor masterCursor, TimeFrameRecordCursor slaveCursor, Record filterRecord, SqlExecutionCircuitBreaker circuitBreaker) {
            super.of(masterCursor, slaveCursor);
            this.circuitBreaker = circuitBreaker;
            this.filterRecord = filterRecord;
            this.masterSinkTarget.reopen();
            this.slaveSinkTarget.reopen();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void toTop() {
            super.toTop();
            FilteredAsOfJoinFastRecordCursorFactory.this.slaveRecordFilter.toTop();
            this.unfilteredRecordRowId = -1L;
            this.unfilteredCursorFrameIndex = -1;
            FilteredAsOfJoinFastRecordCursorFactory.this.origHasSlave = false;
        }
    }
}

