/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.hyperloglog;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.hyperloglog.HyperLogLogDenseRepresentation;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class HyperLogLogSparseRepresentation {
    private static final long CAPACITY_OFFSET = 9L;
    private static final long HEADER_SIZE = 24L;
    private static final int INITIAL_CAPACITY = 16;
    private static final double LOAD_FACTOR = 0.7;
    private static final int NO_ENTRY_VALUE = 0;
    private static final long SIZE_LIMIT_OFFSET = 17L;
    private static final long SIZE_OFFSET = 13L;
    private static final int SPARSE_PRECISION = 25;
    private static final int SPARSE_REGISTER_COUNT = 0x2000000;
    private final int densePrecision;
    private final long encodeMask;
    private final long leadingZerosMask;
    private final int sparseSetMaxSize;
    private GroupByAllocator allocator;
    private int moduloMask;
    private long ptr;

    public HyperLogLogSparseRepresentation(int densePrecision) {
        this.sparseSetMaxSize = HyperLogLogSparseRepresentation.calculateSparseSetMaxSize(densePrecision);
        this.densePrecision = densePrecision;
        this.leadingZerosMask = 1L << densePrecision - 1;
        this.encodeMask = Long.MIN_VALUE >> 25 - densePrecision - 1 >>> densePrecision;
    }

    public static int calculateSparseSetMaxSize(int densePrecision) {
        long denseSizeInBytes = HyperLogLogDenseRepresentation.calculateSizeInBytes(densePrecision);
        int maxSparseSetCapacity = (int)(denseSizeInBytes - 24L >> 2);
        return Math.max(maxSparseSetCapacity, 0);
    }

    public void add(long hash) {
        int registerIdx = HyperLogLogSparseRepresentation.computeRegisterIndex(hash);
        int value = 127;
        if ((hash & this.encodeMask) == 0L) {
            value = this.computeNumberOfLeadingZeros(hash) << 1;
        }
        int entry = registerIdx << 7 | value;
        this.add(registerIdx, entry);
    }

    public long computeCardinality() {
        return this.linearCounting(0x2000000, 0x2000000 - this.size());
    }

    public void convertToDense(HyperLogLogDenseRepresentation dst) {
        dst.setAllocator(this.allocator);
        dst.of(0L);
        long lim = this.ptr + 24L + ((long)this.capacity() << 2);
        for (long p = this.ptr + 24L; p < lim; p += 4L) {
            int entry = Unsafe.getUnsafe().getInt(p);
            if (entry == 0) continue;
            int idx = this.decodeDenseIndex(entry);
            byte leadingZeros = (byte)this.decodeNumberOfLeadingZeros(entry);
            dst.add(idx, leadingZeros);
        }
        this.allocator.free(this.ptr, 24L + ((long)this.capacity() << 2));
    }

    public boolean isFull() {
        return this.size() >= this.sparseSetMaxSize;
    }

    public HyperLogLogSparseRepresentation of(long ptr) {
        if (ptr == 0L) {
            this.ptr = this.allocator.malloc(88L);
            this.zero(this.ptr, 16);
            Unsafe.getUnsafe().putInt(this.ptr + 9L, 16);
            Unsafe.getUnsafe().putInt(this.ptr + 13L, 0);
            Unsafe.getUnsafe().putInt(this.ptr + 17L, 11);
            this.moduloMask = 15;
        } else {
            this.ptr = ptr;
            this.moduloMask = this.capacity() - 1;
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    private static int computeRegisterIndex(long hash) {
        return (int)(hash >>> 39);
    }

    private static int decodeSparseIndex(int entry) {
        return entry >>> 7;
    }

    private void add(int registerIdx, int entry) {
        int index = Integer.hashCode(registerIdx) & this.moduloMask;
        if (!this.tryAddAt(index, registerIdx, entry)) {
            index = this.probe(registerIdx, index);
            this.tryAddAt(index, registerIdx, entry);
        }
    }

    private void addAt(int index, int entry) {
        this.setAt(index, entry);
        int size = this.size();
        int sizeLimit = this.sizeLimit();
        Unsafe.getUnsafe().putInt(this.ptr + 13L, ++size);
        if (size >= sizeLimit) {
            this.rehash(this.capacity() << 1, sizeLimit << 1);
        }
    }

    private int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 9L) : 0;
    }

    private int computeNumberOfLeadingZeros(long hash) {
        return Long.numberOfLeadingZeros(hash << this.densePrecision | this.leadingZerosMask) + 1;
    }

    private int decodeDenseIndex(int entry) {
        int sparseIndex = HyperLogLogSparseRepresentation.decodeSparseIndex(entry);
        return sparseIndex >>> 25 - this.densePrecision;
    }

    private int decodeNumberOfLeadingZeros(int entry) {
        if ((entry & 1) == 0) {
            return entry >>> 1 & 0x3F;
        }
        return Integer.numberOfLeadingZeros(entry << this.densePrecision) + 1;
    }

    private int entryAt(int index) {
        return Unsafe.getUnsafe().getInt(this.ptr + 24L + ((long)index << 2));
    }

    private long linearCounting(int total, int empty) {
        return Math.round((double)total * Math.log((double)total / (double)empty));
    }

    private int probe(int registerIdx, int index) {
        int entry;
        int currentRegisterIdx;
        do {
            if ((entry = this.entryAt(index = index + 1 & this.moduloMask)) != 0) continue;
            return index;
        } while (registerIdx != (currentRegisterIdx = HyperLogLogSparseRepresentation.decodeSparseIndex(entry)));
        return index;
    }

    private void rehash(int newCapacity, int newSizeLimit) {
        if (newCapacity < 0) {
            throw CairoException.nonCritical().put("sparse set capacity overflow");
        }
        int oldCapacity = this.capacity();
        byte type = Unsafe.getUnsafe().getByte(this.ptr);
        long oldPtr = this.ptr;
        this.ptr = this.allocator.malloc(24L + ((long)newCapacity << 2));
        this.zero(this.ptr, newCapacity);
        Unsafe.getUnsafe().putByte(this.ptr, type);
        Unsafe.getUnsafe().putInt(this.ptr + 9L, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr + 13L, 0);
        Unsafe.getUnsafe().putInt(this.ptr + 17L, newSizeLimit);
        this.moduloMask = newCapacity - 1;
        long lim = oldPtr + 24L + ((long)oldCapacity << 2);
        for (long p = oldPtr + 24L; p < lim; p += 4L) {
            int entry = Unsafe.getUnsafe().getInt(p);
            if (entry == 0) continue;
            int registerIdx = HyperLogLogSparseRepresentation.decodeSparseIndex(entry);
            this.add(registerIdx, entry);
        }
        this.allocator.free(oldPtr, 24L + ((long)oldCapacity << 2));
    }

    private void setAt(int index, int entry) {
        Unsafe.getUnsafe().putInt(this.ptr + 24L + ((long)index << 2), entry);
    }

    private int sizeLimit() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 17L) : 0;
    }

    private boolean tryAddAt(int index, int registerIdx, int entry) {
        int currentEntry = this.entryAt(index);
        if (currentEntry == 0) {
            this.addAt(index, entry);
            return true;
        }
        int currentRegisterIdx = HyperLogLogSparseRepresentation.decodeSparseIndex(currentEntry);
        if (currentRegisterIdx == registerIdx) {
            if (currentEntry > entry) {
                this.setAt(index, entry);
            }
            return true;
        }
        return false;
    }

    private void zero(long ptr, int cap) {
        Vect.memset(ptr + 24L, (long)cap << 2, 0);
    }

    void copyTo(HyperLogLogSparseRepresentation dst) {
        long lim = this.ptr + 24L + ((long)this.capacity() << 2);
        for (long p = this.ptr + 24L; p < lim; p += 4L) {
            int entry = Unsafe.getUnsafe().getInt(p);
            if (entry == 0) continue;
            int registerIdx = HyperLogLogSparseRepresentation.decodeSparseIndex(entry);
            dst.add(registerIdx, entry);
        }
    }

    void copyTo(HyperLogLogDenseRepresentation dst) {
        long lim = this.ptr + 24L + ((long)this.capacity() << 2);
        for (long p = this.ptr + 24L; p < lim; p += 4L) {
            int entry = Unsafe.getUnsafe().getInt(p);
            if (entry == 0) continue;
            int idx = this.decodeDenseIndex(entry);
            byte leadingZeros = (byte)this.decodeNumberOfLeadingZeros(entry);
            dst.add(idx, leadingZeros);
        }
    }

    int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 13L) : 0;
    }
}

