/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.hyperloglog;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.hyperloglog.HyperLogLogDenseRepresentation;
import io.questdb.griffin.engine.groupby.hyperloglog.HyperLogLogSparseRepresentation;
import io.questdb.std.Unsafe;

public class HyperLogLog {
    public static final int DEFAULT_PRECISION = 14;
    public static final int MAX_PRECISION = 18;
    public static final int MIN_PRECISION = 4;
    private static final long CACHED_CARDINALITY_OFFSET = 1L;
    private static final long CARDINALITY_NULL_VALUE = -1L;
    private static final byte DENSE = 0;
    private static final byte SPARSE = 1;
    private final HyperLogLogDenseRepresentation dense;
    private final int precision;
    private final HyperLogLogSparseRepresentation sparse;
    private long ptr;

    public HyperLogLog(int precision) {
        assert (precision >= 4 && precision <= 18) : "Precision must be within the range of 4 to 18, inclusive.";
        this.dense = new HyperLogLogDenseRepresentation(precision);
        this.sparse = new HyperLogLogSparseRepresentation(precision);
        this.precision = precision;
    }

    public static long merge(HyperLogLog first, HyperLogLog second) {
        byte firstType = first.getType();
        byte secondType = second.getType();
        if (firstType == 0 && secondType == 0) {
            return HyperLogLog.mergeDenseWithDense(first, second);
        }
        if (firstType == 1 && secondType == 1) {
            if (second.sparse.size() < first.sparse.size()) {
                return HyperLogLog.mergeSparseWithSparse(second, first);
            }
            return HyperLogLog.mergeSparseWithSparse(first, second);
        }
        if (firstType == 1 && secondType == 0) {
            return HyperLogLog.mergeSparseWithDense(first, second);
        }
        if (firstType == 0 && secondType == 1) {
            return HyperLogLog.mergeSparseWithDense(second, first);
        }
        throw new IllegalStateException("Unexpected combination of HyperLogLog types.");
    }

    public long addAndComputeCardinalityFast(long hash) {
        if (this.getType() == 1) {
            this.sparse.add(hash);
            this.ptr = this.sparse.ptr();
            if (this.sparse.isFull()) {
                this.convertToDense();
                this.setCachedCardinality(-1L);
                return -1L;
            }
            long cardinality = this.sparse.computeCardinality();
            this.setCachedCardinality(cardinality);
            return cardinality;
        }
        this.dense.add(hash);
        this.setCachedCardinality(-1L);
        return -1L;
    }

    public long computeCardinality() {
        long cardinality = this.getCachedCardinality();
        if (cardinality != -1L) {
            return cardinality;
        }
        cardinality = this.getType() == 1 ? this.sparse.computeCardinality() : this.dense.computeCardinality();
        this.setCachedCardinality(cardinality);
        return cardinality;
    }

    public boolean isSparse() {
        return this.getType() == 1;
    }

    public HyperLogLog of(long ptr) {
        if (ptr == 0L) {
            if (HyperLogLogSparseRepresentation.calculateSparseSetMaxSize(this.precision) > 0) {
                this.ptr = this.sparse.of(0L).ptr();
                this.setType((byte)1);
            } else {
                this.ptr = this.dense.of(0L).ptr();
                this.setType((byte)0);
            }
            this.setCachedCardinality(-1L);
        } else {
            this.ptr = ptr;
            if (this.getType() == 1) {
                this.sparse.of(ptr);
            } else {
                this.dense.of(ptr);
            }
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void resetPtr() {
        this.ptr = 0L;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.sparse.setAllocator(allocator);
        this.dense.setAllocator(allocator);
    }

    private static long mergeDenseWithDense(HyperLogLog src, HyperLogLog dst) {
        src.dense.copyTo(dst.dense);
        dst.of(dst.dense.ptr());
        dst.setCachedCardinality(-1L);
        return dst.ptr();
    }

    private static long mergeSparseWithDense(HyperLogLog src, HyperLogLog dst) {
        src.sparse.copyTo(dst.dense);
        dst.of(dst.dense.ptr());
        dst.setCachedCardinality(-1L);
        return dst.ptr();
    }

    private static long mergeSparseWithSparse(HyperLogLog src, HyperLogLog dst) {
        src.sparse.copyTo(dst.sparse);
        dst.of(dst.sparse.ptr());
        if (dst.sparse.isFull()) {
            dst.convertToDense();
        }
        dst.setCachedCardinality(-1L);
        return dst.ptr();
    }

    private void convertToDense() {
        this.sparse.convertToDense(this.dense);
        this.ptr = this.dense.ptr();
        this.setType((byte)0);
    }

    private long getCachedCardinality() {
        return Unsafe.getUnsafe().getLong(this.ptr + 1L);
    }

    private byte getType() {
        return Unsafe.getUnsafe().getByte(this.ptr);
    }

    private void setCachedCardinality(long estimate) {
        Unsafe.getUnsafe().putLong(this.ptr + 1L, estimate);
    }

    private void setType(byte type) {
        Unsafe.getUnsafe().putByte(this.ptr, type);
    }
}

