/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SignLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sign(L)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.get(0));
    }

    static class Func
    extends LongFunction
    implements UnaryFunction {
        private final Function arg;

        Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getLong(Record rec) {
            long val = this.arg.getLong(rec);
            if (val == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Long.signum(val);
        }

        @Override
        public String getName() {
            return "sign";
        }
    }
}

