/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.finance;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LevelTwoPriceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "l2price(DDDV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args.size() % 2 == 0) {
            throw SqlException.position(argPositions.getLast()).put("l2price requires an odd number of arguments.");
        }
        Function target = args.getQuick(0);
        if (target.isNullConstant()) {
            return target;
        }
        LevelTwoPriceFunctionFactory.validateColumnTypes(args, argPositions, true);
        int numberOfPairs = (args.size() - 1) / 2;
        if (numberOfPairs == 0) {
            throw SqlException.position(argPositions.getLast()).put("not enough arguments for l2price");
        }
        args = new ObjList<Function>(args);
        IntList positions = new IntList();
        positions.addAll(argPositions);
        switch (numberOfPairs) {
            case 1: {
                return new L2PriceFunction1(args, positions);
            }
            case 2: {
                return new L2PriceFunction2(args, positions);
            }
            case 3: {
                return new L2PriceFunction3(args, positions);
            }
            case 4: {
                return new L2PriceFunction4(args, positions);
            }
            case 5: {
                return new L2PriceFunction5(args, positions);
            }
        }
        return new L2PriceFunctionN(args, positions);
    }

    @Override
    public int resolvePreferredVariadicType(int sqlPos, int argPos, ObjList<Function> args) {
        return 10;
    }

    private static boolean allowedColumnType(int type, boolean allowUndefined) {
        switch (type) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
            case 0: {
                return allowUndefined;
            }
        }
        return false;
    }

    private static void validateColumnTypes(ObjList<Function> args, IntList argPositions, boolean allowUndefined) throws SqlException {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            if (LevelTwoPriceFunctionFactory.allowedColumnType(args.getQuick(i).getType(), allowUndefined) || args.getQuick(i).isNullConstant()) continue;
            throw SqlException.position(argPositions.getQuick(i)).put("l2price requires arguments of type `DOUBLE`, or convertible to `DOUBLE`, not `").put(ColumnType.nameOf(args.getQuick(i).getType())).put("`.");
        }
    }

    private static class L2PriceFunction1
    extends L2PriceBaseFunction {
        private final Function size0Func;
        private final Function targetFunc;
        private final Function value0Func;

        public L2PriceFunction1(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
            this.targetFunc = args.getQuick(0);
            this.size0Func = args.getQuick(1);
            this.value0Func = args.getQuick(2);
        }

        @Override
        public double getDouble(Record rec) {
            double target = this.targetFunc.getDouble(rec);
            double size0 = this.size0Func.getDouble(rec);
            double value0 = this.value0Func.getDouble(rec);
            if (size0 >= target) {
                return value0;
            }
            return Double.NaN;
        }
    }

    private static class L2PriceFunction2
    extends L2PriceBaseFunction {
        private final Function size0Func;
        private final Function size1Func;
        private final Function targetFunc;
        private final Function value0Func;
        private final Function value1Func;

        public L2PriceFunction2(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
            this.targetFunc = args.getQuick(0);
            this.size0Func = args.getQuick(1);
            this.value0Func = args.getQuick(2);
            this.size1Func = args.getQuick(3);
            this.value1Func = args.getQuick(4);
        }

        @Override
        public double getDouble(Record rec) {
            double target = this.targetFunc.getDouble(rec);
            double size0 = this.size0Func.getDouble(rec);
            double value0 = this.value0Func.getDouble(rec);
            if (size0 >= target) {
                return value0;
            }
            double size1 = this.size1Func.getDouble(rec);
            double value1 = this.value1Func.getDouble(rec);
            if (size0 + size1 >= target) {
                return (size0 * value0 + (target - size0) * value1) / target;
            }
            return Double.NaN;
        }
    }

    private static class L2PriceFunction3
    extends L2PriceBaseFunction {
        private final Function size0Func;
        private final Function size1Func;
        private final Function size2Func;
        private final Function targetFunc;
        private final Function value0Func;
        private final Function value1Func;
        private final Function value2Func;

        public L2PriceFunction3(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
            this.targetFunc = args.getQuick(0);
            this.size0Func = args.getQuick(1);
            this.value0Func = args.getQuick(2);
            this.size1Func = args.getQuick(3);
            this.value1Func = args.getQuick(4);
            this.size2Func = args.getQuick(5);
            this.value2Func = args.getQuick(6);
        }

        @Override
        public double getDouble(Record rec) {
            double target = this.targetFunc.getDouble(rec);
            double size0 = this.size0Func.getDouble(rec);
            double value0 = this.value0Func.getDouble(rec);
            if (size0 >= target) {
                return value0;
            }
            double size1 = this.size1Func.getDouble(rec);
            double value1 = this.value1Func.getDouble(rec);
            if (size0 + size1 >= target) {
                return (size0 * value0 + (target - size0) * value1) / target;
            }
            double size2 = this.size2Func.getDouble(rec);
            double value2 = this.value2Func.getDouble(rec);
            if (size0 + size1 + size2 >= target) {
                return (size0 * value0 + size1 * value1 + (target - size0 - size1) * value2) / target;
            }
            return Double.NaN;
        }
    }

    private static class L2PriceFunction4
    extends L2PriceBaseFunction {
        private final Function size0Func;
        private final Function size1Func;
        private final Function size2Func;
        private final Function size3Func;
        private final Function targetFunc;
        private final Function value0Func;
        private final Function value1Func;
        private final Function value2Func;
        private final Function value3Func;

        public L2PriceFunction4(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
            this.targetFunc = args.getQuick(0);
            this.size0Func = args.getQuick(1);
            this.value0Func = args.getQuick(2);
            this.size1Func = args.getQuick(3);
            this.value1Func = args.getQuick(4);
            this.size2Func = args.getQuick(5);
            this.value2Func = args.getQuick(6);
            this.size3Func = args.getQuick(7);
            this.value3Func = args.getQuick(8);
        }

        @Override
        public double getDouble(Record rec) {
            double target = this.targetFunc.getDouble(rec);
            double size0 = this.size0Func.getDouble(rec);
            double value0 = this.value0Func.getDouble(rec);
            if (size0 >= target) {
                return value0;
            }
            double size1 = this.size1Func.getDouble(rec);
            double value1 = this.value1Func.getDouble(rec);
            if (size0 + size1 >= target) {
                return (size0 * value0 + (target - size0) * value1) / target;
            }
            double size2 = this.size2Func.getDouble(rec);
            double value2 = this.value2Func.getDouble(rec);
            if (size0 + size1 + size2 >= target) {
                return (size0 * value0 + size1 * value1 + (target - size0 - size1) * value2) / target;
            }
            double size3 = this.size3Func.getDouble(rec);
            double value3 = this.value3Func.getDouble(rec);
            if (size0 + size1 + size2 + size3 >= target) {
                return (size0 * value0 + size1 * value1 + size2 * value2 + (target - size0 - size1 - size2) * value3) / target;
            }
            return Double.NaN;
        }
    }

    private static class L2PriceFunction5
    extends L2PriceBaseFunction {
        private final Function size0Func;
        private final Function size1Func;
        private final Function size2Func;
        private final Function size3Func;
        private final Function size4Func;
        private final Function targetFunc;
        private final Function value0Func;
        private final Function value1Func;
        private final Function value2Func;
        private final Function value3Func;
        private final Function value4Func;

        public L2PriceFunction5(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
            this.targetFunc = args.getQuick(0);
            this.size0Func = args.getQuick(1);
            this.value0Func = args.getQuick(2);
            this.size1Func = args.getQuick(3);
            this.value1Func = args.getQuick(4);
            this.size2Func = args.getQuick(5);
            this.value2Func = args.getQuick(6);
            this.size3Func = args.getQuick(7);
            this.value3Func = args.getQuick(8);
            this.size4Func = args.getQuick(9);
            this.value4Func = args.getQuick(10);
        }

        @Override
        public double getDouble(Record rec) {
            double target = this.targetFunc.getDouble(rec);
            double size0 = this.size0Func.getDouble(rec);
            double value0 = this.value0Func.getDouble(rec);
            if (size0 >= target) {
                return value0;
            }
            double size1 = this.size1Func.getDouble(rec);
            double value1 = this.value1Func.getDouble(rec);
            if (size0 + size1 >= target) {
                return (size0 * value0 + (target - size0) * value1) / target;
            }
            double size2 = this.size2Func.getDouble(rec);
            double value2 = this.value2Func.getDouble(rec);
            if (size0 + size1 + size2 >= target) {
                return (size0 * value0 + size1 * value1 + (target - size0 - size1) * value2) / target;
            }
            double size3 = this.size3Func.getDouble(rec);
            double value3 = this.value3Func.getDouble(rec);
            if (size0 + size1 + size2 + size3 >= target) {
                return (size0 * value0 + size1 * value1 + size2 * value2 + (target - size0 - size1 - size2) * value3) / target;
            }
            double size4 = this.size4Func.getDouble(rec);
            double value4 = this.value4Func.getDouble(rec);
            if (size0 + size1 + size2 + size3 + size4 >= target) {
                return (size0 * value0 + size1 * value1 + size2 * value2 + size3 * value3 + (target - size0 - size1 - size2 - size3) * value4) / target;
            }
            return Double.NaN;
        }
    }

    private static class L2PriceFunctionN
    extends L2PriceBaseFunction {
        public L2PriceFunctionN(ObjList<Function> args, IntList argPositions) {
            super(args, argPositions);
        }

        @Override
        public double getDouble(Record rec) {
            double t = ((Function)this.args.getQuick(0)).getDouble(rec);
            double ta = 0.0;
            double pa = 0.0;
            double rt = t;
            int n = this.args.size();
            for (int i = 1; i < n; i += 2) {
                double size = ((Function)this.args.getQuick(i)).getDouble(rec);
                double value = ((Function)this.args.getQuick(i + 1)).getDouble(rec);
                if ((ta += size) >= t) {
                    if (i == 1) {
                        return value;
                    }
                    double pp = rt * value;
                    return (pa + pp) / t;
                }
                pa += size * value;
                rt -= size;
            }
            return Double.NaN;
        }
    }

    private static abstract class L2PriceBaseFunction
    extends DoubleFunction
    implements MultiArgFunction {
        protected final ObjList<Function> args;
        private final IntList argPositions;

        public L2PriceBaseFunction(ObjList<Function> args, IntList argPositions) {
            this.args = args;
            this.argPositions = argPositions;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public String getName() {
            return "l2price";
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            LevelTwoPriceFunctionFactory.validateColumnTypes(this.args, this.argPositions, false);
        }
    }
}

