/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqBinaryFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(UU)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Func.equals(this.left.getBin(rec), this.right.getBin(rec));
        }

        private static boolean equals(BinarySequence lBin, BinarySequence rBin) {
            if (lBin == rBin) {
                return true;
            }
            if (lBin == null || rBin == null) {
                return false;
            }
            int len = (int)lBin.length();
            if ((long)len != rBin.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (lBin.byteAt(i) == rBin.byteAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

