/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public interface BinaryFunction
extends Function {
    @Override
    default public void close() {
        Misc.free(this.getLeft());
        Misc.free(this.getRight());
    }

    @Override
    default public void cursorClosed() {
        this.getLeft().cursorClosed();
        this.getRight().cursorClosed();
    }

    public Function getLeft();

    public Function getRight();

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.getLeft().init(symbolTableSource, executionContext);
        this.getRight().init(symbolTableSource, executionContext);
    }

    @Override
    default public boolean isConstant() {
        return this.getLeft().isConstant() && this.getRight().isConstant();
    }

    @Override
    default public boolean isNonDeterministic() {
        return this.getLeft().isNonDeterministic() || this.getRight().isNonDeterministic();
    }

    @Override
    default public boolean isOperator() {
        return false;
    }

    @Override
    default public boolean isRandom() {
        return this.getLeft().isRandom() || this.getRight().isRandom();
    }

    @Override
    default public boolean isRuntimeConstant() {
        Function l = this.getLeft();
        Function r = this.getRight();
        return l.isConstant() && r.isRuntimeConstant() || r.isConstant() && l.isRuntimeConstant() || l.isRuntimeConstant() && r.isRuntimeConstant();
    }

    @Override
    default public boolean isThreadSafe() {
        return this.getLeft().isThreadSafe() && this.getRight().isThreadSafe();
    }

    @Override
    default public void memoize(Record recordA) {
        this.getLeft().memoize(recordA);
        this.getRight().memoize(recordA);
    }

    @Override
    default public void offerStateTo(Function that) {
        if (that instanceof BinaryFunction) {
            this.getLeft().offerStateTo(((BinaryFunction)that).getLeft());
            this.getRight().offerStateTo(((BinaryFunction)that).getRight());
        }
    }

    @Override
    default public boolean shouldMemoize() {
        return this.getLeft().shouldMemoize() || this.getRight().shouldMemoize();
    }

    @Override
    default public boolean supportsParallelism() {
        return this.getLeft().supportsParallelism() && this.getRight().supportsParallelism();
    }

    @Override
    default public boolean supportsRandomAccess() {
        return this.getLeft().supportsRandomAccess() && this.getRight().supportsRandomAccess();
    }

    @Override
    default public void toPlan(PlanSink sink) {
        if (this.isOperator()) {
            sink.val(this.getLeft()).val(this.getName()).val(this.getRight());
        } else {
            sink.val(this.getName()).val('(').val(this.getLeft()).val(',').val(this.getRight()).val(')');
        }
    }

    @Override
    default public void toTop() {
        this.getLeft().toTop();
        this.getRight().toTop();
    }
}

