/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class TextMetadataDetector
implements AbstractTextLexer.Listener,
Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(TextMetadataDetector.class);
    private final IntList _blanks = new IntList();
    private final IntList _histogram = new IntList();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final ObjList<TypeAdapter> columnTypes = new ObjList();
    private final int defaultColumnType;
    private final CharSequenceObjHashMap<TypeAdapter> schemaColumns = new CharSequenceObjHashMap();
    private final StringSink tempSink = new StringSink();
    private final TypeManager typeManager;
    private final LowerCaseCharSequenceHashSet uniqueColumnNames = new LowerCaseCharSequenceHashSet();
    private final DirectUtf16Sink utf8Sink;
    private int fieldCount;
    private boolean forceHeader = false;
    private boolean header = false;
    private CharSequence tableName;

    public TextMetadataDetector(TypeManager typeManager, TextConfiguration textConfiguration) {
        this.typeManager = typeManager;
        this.utf8Sink = new DirectUtf16Sink(textConfiguration.getUtf8SinkSize());
        this.defaultColumnType = textConfiguration.isUseLegacyStringDefault() ? 11 : 26;
    }

    @Override
    public void clear() {
        this.tempSink.clear();
        this.columnNames.clear();
        this.uniqueColumnNames.clear();
        this._blanks.clear();
        this._histogram.clear();
        this.fieldCount = 0;
        this.header = false;
        this.columnTypes.clear();
        this.schemaColumns.clear();
        this.forceHeader = false;
    }

    @Override
    public void close() {
        Misc.free(this.utf8Sink);
    }

    public void evaluateResults(long lineCount, long errorCount) {
        int i;
        if (this.calcTypes(lineCount - errorCount, true) && !this.calcTypes(lineCount - errorCount - 1L, false) || this.forceHeader) {
            this.header = true;
        } else {
            LOG.info().$("no header [table=").$safe(this.tableName).$(", lineCount=").$(lineCount).$(", errorCount=").$(errorCount).$(", forceHeader=").$(this.forceHeader).$(']').$();
        }
        for (i = 0; i < this.fieldCount; ++i) {
            if (!this.header || this.columnNames.getQuick(i).length() == 0) {
                this.tempSink.clear();
                this.tempSink.put('f').put(i);
                if (this.header) {
                    for (int attempt = 0; attempt < 20 && this.columnNames.contains(this.tempSink); ++attempt) {
                        this.tempSink.put('_');
                    }
                    if (this.columnNames.contains(this.tempSink)) {
                        throw TextException.$("Failed to generate unique name for column [no=").put(i).put("]");
                    }
                }
                this.columnNames.setQuick(i, this.tempSink.toString());
            }
            if (this.uniqueColumnNames.add(this.columnNames.getQuick(i))) continue;
            throw TextException.$("duplicate column name found [no=").put(i).put(",name=").put(this.columnNames.get(i)).put(']');
        }
        if (this.schemaColumns.size() > 0) {
            int k = this.columnNames.size();
            for (i = 0; i < k; ++i) {
                TypeAdapter type = this.schemaColumns.get(this.columnNames.getQuick(i));
                if (type == null) continue;
                this.columnTypes.setQuick(i, type);
            }
        }
    }

    public boolean isHeader() {
        return this.header;
    }

    public void of(CharSequence tableName, ObjList<CharSequence> names, ObjList<TypeAdapter> types, boolean forceHeader) {
        this.clear();
        if (names != null && types != null) {
            int n = names.size();
            assert (n == types.size());
            for (int i = 0; i < n; ++i) {
                this.schemaColumns.put(names.getQuick(i), types.getQuick(i));
            }
        }
        this.forceHeader = forceHeader;
        this.tableName = tableName;
    }

    @Override
    public void onFields(long line, ObjList<DirectUtf8String> values, int fieldCount) {
        if (line == 0L) {
            this.seedFields(fieldCount);
            this.stashPossibleHeader(values, fieldCount);
        }
        int count = this.typeManager.getProbeCount();
        for (int i = 0; i < fieldCount; ++i) {
            DirectUtf8Sequence cs = values.getQuick(i);
            if (cs.size() == 0) {
                this._blanks.increment(i);
            }
            int offset = i * count;
            for (int k = 0; k < count; ++k) {
                TypeAdapter probe = this.typeManager.getProbe(k);
                if (!probe.probe(cs)) continue;
                this._histogram.increment(k + offset);
            }
        }
    }

    private boolean calcTypes(long count, boolean setDefault) {
        boolean allStrings = true;
        int probeCount = this.typeManager.getProbeCount();
        for (int i = 0; i < this.fieldCount; ++i) {
            int offset = i * probeCount;
            int blanks = this._blanks.getQuick(i);
            boolean unprobed = true;
            for (int k = 0; k < probeCount; ++k) {
                if ((long)(this._histogram.getQuick(k + offset) + blanks) != count || (long)blanks >= count) continue;
                unprobed = false;
                this.columnTypes.setQuick(i, this.typeManager.getProbe(k));
                if (!allStrings || this.typeManager.getProbe(k).getType() == 4) break;
                allStrings = false;
                break;
            }
            if (!setDefault || !unprobed) continue;
            this.columnTypes.setQuick(i, this.typeManager.getTypeAdapter(this.defaultColumnType));
        }
        return allStrings;
    }

    private String normalise(CharSequence seq) {
        boolean capNext = false;
        this.tempSink.clear();
        int l = seq.length();
        block4: for (int i = 0; i < l; ++i) {
            char c = seq.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\u007f': {
                    capNext = true;
                }
                case '\ufeff': {
                    continue block4;
                }
                default: {
                    if (this.tempSink.length() == 0 && Character.isDigit(c)) {
                        this.tempSink.put('_');
                    }
                    if (capNext) {
                        this.tempSink.put(Character.toUpperCase(c));
                        capNext = false;
                        continue block4;
                    }
                    this.tempSink.put(c);
                }
            }
        }
        return Chars.toString(this.tempSink);
    }

    private void seedFields(int count) {
        this.fieldCount = count;
        this._histogram.setAll(this.fieldCount * this.typeManager.getProbeCount(), 0);
        this._blanks.setAll(count, 0);
        this.columnTypes.extendAndSet(count - 1, null);
        this.columnNames.setAll(count, "");
    }

    private void stashPossibleHeader(ObjList<DirectUtf8String> values, int hi) {
        for (int i = 0; i < hi; ++i) {
            DirectUtf8Sequence value = values.getQuick(i);
            this.utf8Sink.clear();
            if (Utf8s.utf8ToUtf16(value.lo(), value.hi(), this.utf8Sink)) {
                this.columnNames.setQuick(i, this.normalise(this.utf8Sink));
                continue;
            }
            LOG.info().$("utf8 error [table=").$safe(this.tableName).$(", line=0, col=").$(i).$(']').$();
            this.columnNames.setQuick(i, "");
        }
    }

    ObjList<CharSequence> getColumnNames() {
        return this.columnNames;
    }

    ObjList<TypeAdapter> getColumnTypes() {
        return this.columnTypes;
    }
}

