/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.vm.MemoryPMARImpl;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.SwarUtils;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFileIndexer
implements Closeable,
Mutable {
    public static final long INDEX_ENTRY_SIZE = 16L;
    public static final CharSequence INDEX_FILE_NAME = "index.m";
    private static final Log LOG = LogFactory.getLog(CsvFileIndexer.class);
    private static final long MASK_CR = SwarUtils.broadcast((byte)13);
    private static final long MASK_NEW_LINE = SwarUtils.broadcast((byte)10);
    private static final long MASK_QUOTE = SwarUtils.broadcast((byte)34);
    private static final int MAX_TIMESTAMP_LENGTH = 100;
    private final CairoConfiguration configuration;
    private final int dirMode;
    private final FilesFacade ff;
    private final int fieldRollBufLen;
    private final CharSequence inputRoot;
    private final long maxIndexChunkSize;
    private final ObjList<IndexOutputFile> outputFileDenseList = new ObjList();
    private final LongObjHashMap<IndexOutputFile> outputFileLookupMap = new LongObjHashMap();
    private final DirectUtf8String timestampField;
    private final TypeManager typeManager;
    private final DirectUtf16Sink utf16Sink;
    private final DirectUtf8Sink utf8Sink;
    private boolean cancelled = false;
    @Nullable
    private ExecutionCircuitBreaker circuitBreaker;
    private byte columnDelimiter;
    private long columnDelimiterMask;
    private boolean delayedOutQuote;
    private boolean eol;
    private int errorCount = 0;
    private boolean failOnTsError;
    private long fd = -1L;
    private long fieldHi;
    private int fieldIndex;
    private long fieldLo;
    private long fieldRollBufCur;
    private long fieldRollBufPtr;
    private boolean header;
    private CharSequence importRoot;
    private boolean inQuote;
    private int index;
    private CharSequence inputFileName;
    private long lastLineStart;
    private long lastQuotePos = -1L;
    private long lineCount;
    private long lineNumber;
    private long offset;
    private DateFormat partitionDirFormatMethod;
    private PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private Path path;
    private boolean rollBufferUnusable = false;
    private long sortBufferLength;
    private long sortBufferPtr;
    private TimestampAdapter timestampAdapter;
    private int timestampIndex;
    private long timestampValue;
    private boolean useFieldRollBuf = false;

    public CsvFileIndexer(CairoConfiguration configuration) {
        try {
            this.configuration = configuration;
            TextConfiguration textConfiguration = configuration.getTextConfiguration();
            int utf8SinkSize = textConfiguration.getUtf8SinkSize();
            this.utf16Sink = new DirectUtf16Sink(utf8SinkSize);
            this.utf8Sink = new DirectUtf8Sink(utf8SinkSize);
            this.typeManager = new TypeManager(textConfiguration, this.utf16Sink, this.utf8Sink);
            this.ff = configuration.getFilesFacade();
            this.dirMode = configuration.getMkDirMode();
            this.inputRoot = configuration.getSqlCopyInputRoot();
            this.maxIndexChunkSize = configuration.getSqlCopyMaxIndexChunkSize();
            this.fieldRollBufLen = 100;
            this.fieldRollBufCur = this.fieldRollBufPtr = Unsafe.malloc(this.fieldRollBufLen, 35);
            this.timestampField = new DirectUtf8String();
            this.failOnTsError = false;
            this.path = new Path();
            this.sortBufferPtr = -1L;
            this.sortBufferLength = 0L;
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public final void clear() {
        this.fieldLo = 0L;
        this.eol = false;
        this.fieldIndex = 0;
        this.inQuote = false;
        this.delayedOutQuote = false;
        this.lineNumber = 0L;
        this.lineCount = 0L;
        this.fieldRollBufCur = this.fieldRollBufPtr;
        this.useFieldRollBuf = false;
        this.rollBufferUnusable = false;
        this.header = false;
        this.errorCount = 0;
        this.offset = -1L;
        Misc.clear(this.timestampField);
        this.lastQuotePos = -1L;
        this.timestampValue = Long.MIN_VALUE;
        this.inputFileName = null;
        this.importRoot = null;
        this.timestampAdapter = null;
        this.timestampIndex = -1;
        this.partitionFloorMethod = null;
        this.partitionDirFormatMethod = null;
        this.columnDelimiter = (byte)-1;
        this.columnDelimiterMask = 0L;
        this.closeOutputFiles();
        this.closeSortBuffer();
        if (this.ff != null && this.ff.close(this.fd)) {
            this.fd = -1L;
        }
        this.failOnTsError = false;
        if (this.path != null) {
            this.path.trimTo(0);
        }
        this.circuitBreaker = null;
        this.cancelled = false;
    }

    @Override
    public void close() {
        this.fieldRollBufPtr = Unsafe.free(this.fieldRollBufPtr, this.fieldRollBufLen, 35);
        this.path = Misc.free(this.path);
        Misc.clear(this.typeManager);
        Misc.free(this.utf16Sink);
        Misc.free(this.utf8Sink);
        this.clear();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(long chunkLo, long chunkHi, long lineNumber, LongList partitionKeysAndSizes, long fileBufAddr, long fileBufSize) {
        assert (chunkHi > 0L);
        assert (chunkLo >= 0L && chunkLo < chunkHi);
        this.openInputFile();
        this.lastLineStart = this.offset = chunkLo;
        this.lineNumber = lineNumber;
        try {
            long read;
            do {
                if (this.circuitBreaker != null && this.circuitBreaker.checkIfTripped()) {
                    this.cancelled = true;
                    throw TextException.$("Cancelled");
                }
                long leftToRead = Math.min(chunkHi - this.offset, fileBufSize);
                read = (int)this.ff.read(this.fd, fileBufAddr, leftToRead, this.offset);
                if (read < 1L) break;
                this.parse(fileBufAddr, fileBufAddr + read);
                this.offset += read;
            } while (this.offset < chunkHi);
            if (read < 0L || this.offset < chunkHi) {
                throw TextException.$("could not read file [path='").put(this.path).put("', offset=").put(this.offset).put(", errno=").put(this.ff.errno()).put(']');
            }
            this.parseLast();
            this.collectPartitionStats(partitionKeysAndSizes);
            this.sortAndCloseOutputFiles();
        }
        finally {
            this.closeOutputFiles();
            this.closeSortBuffer();
        }
        this.lineCount = this.lineNumber - lineNumber;
        LOG.info().$("finished chunk [chunkLo=").$(chunkLo).$(", chunkHi=").$(chunkHi).$(", lines=").$(this.lineCount).$(", errors=").$(this.errorCount).I$();
    }

    public void indexLine(long ptr, long lo) throws TextException {
        IndexOutputFile target;
        if (this.timestampValue == Long.MIN_VALUE) {
            return;
        }
        long lineStartOffset = this.lastLineStart;
        long length = this.offset + ptr - lo - this.lastLineStart;
        if (length >= 65536L) {
            LOG.error().$("row exceeds maximum line length (65k) for parallel import [line=").$(this.lineNumber).$(", length=").$(length).I$();
            ++this.errorCount;
            return;
        }
        long lengthAndOffset = length << 48 | lineStartOffset;
        long partitionKey = this.partitionFloorMethod.floor(this.timestampValue);
        long mapKey = partitionKey / 3600000000L;
        int keyIndex = this.outputFileLookupMap.keyIndex(mapKey);
        if (keyIndex > -1) {
            target = this.prepareTargetFile(partitionKey);
            this.outputFileDenseList.add(target);
            this.outputFileLookupMap.putAt(keyIndex, mapKey, target);
        } else {
            target = this.outputFileLookupMap.valueAt(keyIndex);
        }
        if (target.indexChunkSize == this.maxIndexChunkSize) {
            target.nextChunk(this.ff, this.getPartitionIndexPrefix(partitionKey));
        }
        target.putEntry(this.timestampValue, lengthAndOffset, length);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void of(CharSequence inputFileName, CharSequence importRoot, int index, int partitionBy, byte columnDelimiter, int timestampIndex, TimestampAdapter adapter, boolean ignoreHeader, int atomicity, @Nullable ExecutionCircuitBreaker circuitBreaker) {
        this.inputFileName = inputFileName;
        this.importRoot = importRoot;
        this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
        this.partitionDirFormatMethod = PartitionBy.getPartitionDirFormatMethod(partitionBy);
        this.offset = 0L;
        this.columnDelimiter = columnDelimiter;
        this.columnDelimiterMask = SwarUtils.broadcast(columnDelimiter);
        if (timestampIndex < 0) {
            throw TextException.$("Timestamp index is not set [value=").put(timestampIndex).put(']');
        }
        this.timestampIndex = timestampIndex;
        this.timestampAdapter = adapter;
        this.header = ignoreHeader;
        this.index = index;
        this.failOnTsError = atomicity == 0;
        this.timestampValue = Long.MIN_VALUE;
        this.circuitBreaker = circuitBreaker;
    }

    public void parseLast() {
        if (this.useFieldRollBuf) {
            if (this.inQuote && this.lastQuotePos < this.fieldHi) {
                ++this.errorCount;
                LOG.info().$("quote is missing [table=").$("tableName").$(']').$();
            } else {
                ++this.fieldHi;
                this.stashField(this.fieldIndex, 0L);
                this.triggerLine(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(long srcFd, long srcSize) {
        if (srcSize < 1L) {
            return;
        }
        long srcAddress = -1L;
        try {
            srcAddress = TableUtils.mapRW(this.ff, srcFd, srcSize, 2);
            if (this.sortBufferPtr == -1L) {
                this.sortBufferPtr = Unsafe.malloc(this.maxIndexChunkSize, 35);
                this.sortBufferLength = this.maxIndexChunkSize;
            }
            Vect.radixSortLongIndexAscInPlace(srcAddress, srcSize / 16L, this.sortBufferPtr);
        }
        finally {
            if (srcAddress != -1L) {
                this.ff.munmap(srcAddress, srcSize, 2);
            }
        }
    }

    private void checkEol(long lo) {
        if (this.eol) {
            this.uneol(lo);
        }
    }

    private void clearRollBuffer(long ptr) {
        this.useFieldRollBuf = false;
        this.fieldRollBufCur = this.fieldRollBufPtr;
        this.fieldLo = this.fieldHi = ptr;
    }

    private void closeOutputFiles() {
        Misc.freeObjListAndClear(this.outputFileDenseList);
        Misc.clear(this.outputFileLookupMap);
    }

    private void closeSortBuffer() {
        if (this.sortBufferPtr != -1L) {
            Unsafe.free(this.sortBufferPtr, this.sortBufferLength, 35);
            this.sortBufferPtr = -1L;
            this.sortBufferLength = 0L;
        }
    }

    private void collectPartitionStats(LongList partitionKeysAndSizes) {
        partitionKeysAndSizes.setPos(0);
        int n = this.outputFileDenseList.size();
        for (int i = 0; i < n; ++i) {
            IndexOutputFile value = this.outputFileDenseList.getQuick(i);
            partitionKeysAndSizes.add(value.partitionKey, value.dataSize);
        }
    }

    private void eol(long ptr, byte c) {
        if (c == 10 || c == 13) {
            this.eol = true;
            this.rollBufferUnusable = false;
            this.clearRollBuffer(ptr);
            this.fieldIndex = 0;
            ++this.lineNumber;
        }
    }

    private boolean fitsInBuffer(int requiredLength) {
        if (requiredLength > this.fieldRollBufLen) {
            LOG.info().$("timestamp column value too long [path=").$(this.inputFileName).$(", line=").$(this.lineNumber).$(", requiredLen=").$(requiredLength).$(", rollLimit=").$(this.fieldRollBufLen).$(']').$();
            ++this.errorCount;
            this.rollBufferUnusable = true;
            return false;
        }
        return true;
    }

    private Path getPartitionIndexDir(long partitionKey) {
        this.path.of(this.importRoot).slash();
        this.partitionDirFormatMethod.format(partitionKey, DateFormatUtils.EN_LOCALE, null, this.path);
        return this.path;
    }

    private Path getPartitionIndexPrefix(long partitionKey) {
        return this.getPartitionIndexDir(partitionKey).slash().put(this.index);
    }

    private void onColumnDelimiter(long lo, long ptr) {
        this.checkEol(lo);
        if (this.inQuote) {
            return;
        }
        this.stashField(this.fieldIndex++, ptr);
    }

    private void onLineEnd(long ptr, long lo) {
        if (this.inQuote) {
            return;
        }
        if (this.eol) {
            this.fieldLo = this.fieldHi;
            return;
        }
        this.stashField(this.fieldIndex, ptr);
        this.indexLine(ptr, lo);
        this.triggerLine(ptr);
    }

    private void onQuote() {
        if (this.inQuote) {
            this.delayedOutQuote = !this.delayedOutQuote;
            this.lastQuotePos = this.fieldHi;
        } else if (this.fieldHi - this.fieldLo == 1L) {
            this.inQuote = true;
            this.fieldLo = this.fieldHi;
        }
    }

    private void parse(long lo, long hi) {
        this.fieldHi = this.useFieldRollBuf ? this.fieldRollBufCur : (this.fieldLo = lo);
        long ptr = lo;
        while (ptr < hi) {
            if (!(this.rollBufferUnusable || this.useFieldRollBuf || this.delayedOutQuote || ptr >= hi - 7L)) {
                long word = Unsafe.getUnsafe().getLong(ptr);
                long zeroBytesWord = SwarUtils.markZeroBytes(word ^ MASK_NEW_LINE) | SwarUtils.markZeroBytes(word ^ MASK_CR) | SwarUtils.markZeroBytes(word ^ MASK_QUOTE) | SwarUtils.markZeroBytes(word ^ this.columnDelimiterMask);
                if (zeroBytesWord == 0L) {
                    ptr += 7L;
                    this.fieldHi += 7L;
                    continue;
                }
                int firstIndex = SwarUtils.indexOfFirstMarkedByte(zeroBytesWord);
                ptr += (long)firstIndex;
                this.fieldHi += (long)firstIndex;
            }
            byte b = Unsafe.getUnsafe().getByte(ptr++);
            if (this.rollBufferUnusable) {
                this.eol(ptr, b);
                continue;
            }
            if (this.useFieldRollBuf) {
                this.putToRollBuf(b);
                if (this.rollBufferUnusable) continue;
            }
            ++this.fieldHi;
            if (this.delayedOutQuote && b != 34) {
                this.delayedOutQuote = false;
                this.inQuote = false;
            }
            if (b == this.columnDelimiter) {
                this.onColumnDelimiter(lo, ptr);
                continue;
            }
            if (b == 34) {
                this.checkEol(lo);
                this.onQuote();
                continue;
            }
            if (b == 10 || b == 13) {
                this.onLineEnd(ptr, lo);
                continue;
            }
            this.checkEol(lo);
        }
        if (this.useFieldRollBuf) {
            return;
        }
        if (this.eol) {
            this.fieldLo = 0L;
        } else if (this.fieldIndex == this.timestampIndex) {
            this.rollField(hi);
        }
    }

    private void parseTimestamp() {
        try {
            this.timestampValue = this.timestampAdapter.getTimestamp(this.timestampField);
        }
        catch (Exception e) {
            if (this.failOnTsError) {
                throw TextException.$("could not parse timestamp [line=").put(this.lineNumber).put(", column=").put(this.timestampIndex).put(']');
            }
            LOG.error().$("could not parse timestamp [line=").$(this.lineNumber).$(", column=").$(this.timestampIndex).I$();
            ++this.errorCount;
        }
    }

    @NotNull
    private IndexOutputFile prepareTargetFile(long partitionKey) {
        int result;
        this.getPartitionIndexDir(partitionKey);
        this.path.slash();
        if (!this.ff.exists(this.path.$()) && (result = this.ff.mkdir(this.path.$(), this.dirMode)) != 0 && !this.ff.exists(this.path.$())) {
            throw TextException.$("Couldn't create partition dir [path='").put(this.path).put("']");
        }
        this.path.put(this.index);
        return new IndexOutputFile(this.ff, this.path, partitionKey);
    }

    private void putToRollBuf(byte c) {
        if (this.fitsInBuffer((int)(this.fieldRollBufCur - this.fieldRollBufPtr + 1L))) {
            Unsafe.getUnsafe().putByte(this.fieldRollBufCur++, c);
        }
    }

    private void rollField(long hi) {
        int length = (int)(hi - this.fieldLo);
        if (length > 0 && this.fitsInBuffer(length)) {
            assert (this.fieldLo + (long)length <= hi);
            Vect.memcpy(this.fieldRollBufPtr, this.fieldLo, length);
            this.fieldRollBufCur = this.fieldRollBufPtr + (long)length;
            this.shift(this.fieldLo - this.fieldRollBufPtr);
            this.useFieldRollBuf = true;
        }
    }

    private void shift(long d) {
        this.fieldLo -= d;
        this.fieldHi -= d;
        if (this.lastQuotePos > -1L) {
            this.lastQuotePos -= d;
        }
    }

    private void sortAndCloseOutputFiles() {
        int n = this.outputFileDenseList.size();
        for (int i = 0; i < n; ++i) {
            this.outputFileDenseList.getQuick(i).sortAndClose();
        }
        this.outputFileDenseList.clear();
        this.outputFileLookupMap.clear();
    }

    private void stashField(int fieldIndex, long ptr) {
        if (fieldIndex == this.timestampIndex && !this.header) {
            if (this.lastQuotePos > -1L) {
                this.timestampField.of(this.fieldLo, this.lastQuotePos - 1L);
            } else {
                this.timestampField.of(this.fieldLo, this.fieldHi - 1L);
            }
            this.parseTimestamp();
            if (this.useFieldRollBuf) {
                this.clearRollBuffer(ptr);
            }
        }
        this.lastQuotePos = -1L;
        this.fieldLo = this.fieldHi;
    }

    private void triggerLine(long ptr) {
        this.eol = true;
        this.fieldIndex = 0;
        if (this.useFieldRollBuf) {
            this.clearRollBuffer(ptr);
        }
        if (this.header) {
            this.header = false;
            return;
        }
        ++this.lineNumber;
        this.timestampValue = Long.MIN_VALUE;
    }

    private void uneol(long lo) {
        this.eol = false;
        this.lastLineStart = this.offset + (this.fieldLo - lo);
    }

    void openInputFile() {
        if (this.fd > -1L) {
            return;
        }
        this.path.of(this.inputRoot).slash().concat(this.inputFileName);
        this.fd = TableUtils.openRO(this.ff, this.path.$(), LOG);
        long len = this.ff.length(this.fd);
        if (len == -1L) {
            throw CairoException.critical(this.ff.errno()).put("could not get length of file [path=").put(this.path).put(']');
        }
        this.ff.fadvise(this.fd, 0L, len, Files.POSIX_FADV_SEQUENTIAL);
    }

    class IndexOutputFile
    implements Closeable {
        final MemoryPMARImpl memory;
        final long partitionKey;
        int chunkNumber;
        long dataSize;
        long indexChunkSize;

        IndexOutputFile(FilesFacade ff, Path path, long partitionKey) {
            this.partitionKey = partitionKey;
            this.indexChunkSize = 0L;
            this.chunkNumber = 0;
            this.dataSize = 0L;
            this.memory = new MemoryPMARImpl(CsvFileIndexer.this.configuration);
            this.nextChunk(ff, path);
        }

        @Override
        public void close() {
            if (this.memory.isOpen()) {
                this.memory.close(true, (byte)1);
            }
        }

        public void nextChunk(FilesFacade ff, Path path) {
            if (this.memory.isOpen()) {
                this.sortAndClose();
            }
            ++this.chunkNumber;
            this.indexChunkSize = 0L;
            path.put('_').put(this.chunkNumber);
            LPSZ lpsz = path.$();
            if (ff.exists(lpsz)) {
                throw TextException.$("index file already exists [path=").put(path).put(']');
            }
            LOG.debug().$("created import index file [path='").$(path).$("']").$();
            this.memory.of(ff, lpsz, ff.getMapPageSize(), 0, 0);
        }

        private void sortAndClose() {
            if (this.memory.isOpen()) {
                CsvFileIndexer.this.sort(this.memory.getFd(), this.indexChunkSize);
                this.memory.close(true, (byte)1);
            }
        }

        void putEntry(long timestamp, long offset, long length) {
            this.memory.putLong128(timestamp, offset);
            this.indexChunkSize += 16L;
            this.dataSize += length;
        }
    }
}

