/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerWrapper;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.sql.async.PageFrameReduceJob;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.WorkStealingStrategy;
import io.questdb.cairo.sql.async.WorkStealingStrategyFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PageFrameSequence<T extends StatefulAtom>
implements Closeable {
    private static final AtomicLong ID_SEQ = new AtomicLong();
    private static final long LOCAL_TASK_CURSOR = Long.MAX_VALUE;
    private static final Log LOG = LogFactory.getLog(PageFrameSequence.class);
    private final T atom;
    private final AtomicInteger cancelReason = new AtomicInteger(0);
    private final MillisecondClock clock;
    private final PageFrameAddressCache frameAddressCache;
    private final LongList frameRowCounts = new LongList();
    private final PageFrameReduceTaskFactory localTaskFactory;
    private final MessageBus messageBus;
    private final AtomicInteger reduceFinishedCounter = new AtomicInteger(0);
    private final AtomicInteger reduceStartedCounter = new AtomicInteger(0);
    private final PageFrameReducer reducer;
    private final byte taskType;
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final WorkStealingStrategy workStealingStrategy;
    public volatile boolean done;
    private SCSequence collectSubSeq;
    private int collectedFrameIndex = -1;
    private int dispatchStartFrameIndex;
    private int frameCount;
    private PageFrameCursor frameCursor;
    private long id;
    private PageFrameMemoryRecord localRecord;
    private PageFrameReduceTask localTask;
    private boolean readyToDispatch;
    private RingQueue<PageFrameReduceTask> reduceQueue;
    private int shard;
    private SqlExecutionContext sqlExecutionContext;
    private long startTime;
    private boolean uninterruptible;
    private SqlExecutionCircuitBreakerWrapper workStealCircuitBreaker;

    public PageFrameSequence(CairoConfiguration configuration, MessageBus messageBus, T atom, PageFrameReducer reducer, PageFrameReduceTaskFactory localTaskFactory, int sharedQueryWorkerCount, byte taskType) {
        try {
            this.atom = atom;
            this.frameAddressCache = new PageFrameAddressCache(configuration);
            this.messageBus = messageBus;
            this.reducer = reducer;
            this.clock = configuration.getMillisecondClock();
            this.localTaskFactory = localTaskFactory;
            this.workStealingStrategy = WorkStealingStrategyFactory.getInstance(configuration, sharedQueryWorkerCount);
            this.taskType = taskType;
            this.workStealCircuitBreaker = new SqlExecutionCircuitBreakerWrapper(configuration.getCircuitBreakerConfiguration());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public void await() {
        LOG.debug().$("awaiting completion [shard=").$(this.shard).$(", id=").$(this.id).$(", frameCount=").$(this.frameCount).I$();
        MCSequence pageFrameReduceSubSeq = this.messageBus.getPageFrameReduceSubSeq(this.shard);
        while (!this.done) {
            if (this.localTask != null && this.localTask.getFrameSequence() == this && this.dispatchStartFrameIndex == this.localTask.getFrameIndex() + 1) {
                this.collectedFrameIndex = this.localTask.getFrameIndex();
                this.localTask.collected(true);
            }
            if (this.dispatchStartFrameIndex == this.collectedFrameIndex + 1) {
                if (this.done) break;
                this.reset();
                break;
            }
            boolean nothingProcessed = true;
            try {
                nothingProcessed = PageFrameReduceJob.consumeQueue(this.reduceQueue, pageFrameReduceSubSeq, this.localRecord, this.workStealCircuitBreaker, this);
            }
            catch (Throwable th) {
                LOG.error().$("await error [id=").$(this.id).$(", ex=").$(th).I$();
            }
            if (!nothingProcessed) continue;
            long cursor = this.collectSubSeq.next();
            if (cursor > -1L) {
                PageFrameReduceTask task = this.reduceQueue.get(cursor);
                if (task.getFrameSequence() == this) {
                    assert (this.id == task.getFrameSequenceId()) : "ids mismatch: " + this.id + ", " + task.getFrameSequenceId();
                    this.collectedFrameIndex = task.getFrameIndex();
                    task.collected(true);
                }
                this.collectSubSeq.done(cursor);
                continue;
            }
            Os.pause();
        }
        while (this.reduceFinishedCounter.get() != this.dispatchStartFrameIndex) {
            Os.pause();
        }
    }

    public void cancel(int reason) {
        this.valid.compareAndSet(true, false);
        this.cancelReason.set(reason);
    }

    public void clear() {
        this.frameCount = 0;
        this.dispatchStartFrameIndex = 0;
        this.collectedFrameIndex = -1;
        this.readyToDispatch = false;
        this.frameRowCounts.clear();
        this.frameAddressCache.clear();
        this.atom.clear();
        this.frameCursor = Misc.free(this.frameCursor);
        if (this.collectSubSeq != null) {
            this.messageBus.getPageFrameCollectFanOut(this.shard).remove(this.collectSubSeq);
            LOG.debug().$("removed [seq=").$(this.collectSubSeq).I$();
        }
        if (this.localTask != null) {
            this.localTask.reset();
        }
    }

    @Override
    public void close() {
        this.clear();
        this.localRecord = Misc.free(this.localRecord);
        this.workStealCircuitBreaker = Misc.free(this.workStealCircuitBreaker);
        this.localTask = Misc.free(this.localTask);
        Misc.free(this.atom);
    }

    public void collect(long cursor, boolean forceCollect) {
        assert (cursor > -1L);
        if (cursor == Long.MAX_VALUE) {
            this.collectedFrameIndex = this.localTask.getFrameIndex();
            this.localTask.collected();
            return;
        }
        PageFrameReduceTask task = this.reduceQueue.get(cursor);
        this.collectedFrameIndex = task.getFrameIndex();
        task.collected(forceCollect);
        this.collectSubSeq.done(cursor);
    }

    public T getAtom() {
        return this.atom;
    }

    public int getCancelReason() {
        return this.cancelReason.get();
    }

    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        return this.sqlExecutionContext.getCircuitBreaker();
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public long getFrameRowCount(int frameIndex) {
        return this.frameRowCounts.getQuick(frameIndex);
    }

    public long getId() {
        return this.id;
    }

    public PageFrameAddressCache getPageFrameAddressCache() {
        return this.frameAddressCache;
    }

    public AtomicInteger getReduceFinishedCounter() {
        return this.reduceFinishedCounter;
    }

    public AtomicInteger getReduceStartedCounter() {
        return this.reduceStartedCounter;
    }

    public PageFrameReducer getReducer() {
        return this.reducer;
    }

    public int getShard() {
        return this.shard;
    }

    public SqlExecutionContext getSqlExecutionContext() {
        return this.sqlExecutionContext;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SymbolTableSource getSymbolTableSource() {
        return this.frameCursor;
    }

    public PageFrameReduceTask getTask(long cursor) {
        assert (cursor > -1L);
        if (cursor == Long.MAX_VALUE) {
            assert (this.localTask != null && this.localTask.getFrameSequence() != null);
            return this.localTask;
        }
        return this.reduceQueue.get(cursor);
    }

    public byte getTaskType() {
        return this.taskType;
    }

    public WorkStealingStrategy getWorkStealingStrategy() {
        return this.workStealingStrategy;
    }

    public boolean isActive() {
        return this.valid.get();
    }

    public boolean isUninterruptible() {
        return this.uninterruptible;
    }

    public long next() {
        if (this.frameCount == 0) {
            return -2L;
        }
        assert (this.collectedFrameIndex < this.frameCount - 1);
        while (true) {
            long cursor;
            if ((cursor = this.collectSubSeq.next()) > -1L) {
                PageFrameReduceTask task = this.reduceQueue.get(cursor);
                PageFrameSequence<?> thatFrameSequence = task.getFrameSequence();
                if (thatFrameSequence == this) {
                    assert (this.id == task.getFrameSequenceId()) : "ids mismatch: " + this.id + ", " + task.getFrameSequenceId();
                    return cursor;
                }
                this.collectSubSeq.done(cursor);
                continue;
            }
            if (cursor == -1L) {
                if (this.dispatch()) continue;
                if (this.dispatchStartFrameIndex == this.collectedFrameIndex + 1) {
                    this.workLocally();
                    return Long.MAX_VALUE;
                }
                return -1L;
            }
            Os.pause();
        }
    }

    public PageFrameSequence<T> of(RecordCursorFactory base, SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        this.sqlExecutionContext = executionContext;
        this.startTime = this.clock.getTicks();
        this.uninterruptible = executionContext.isUninterruptible();
        if (this.localRecord == null) {
            this.localRecord = new PageFrameMemoryRecord(0);
        }
        Rnd rnd = executionContext.getAsyncRandom();
        try {
            assert (this.frameCursor == null);
            this.frameCursor = base.getPageFrameCursor(executionContext, order);
            this.frameAddressCache.of(base.getMetadata(), this.frameCursor.getColumnIndexes());
            this.collectSubSeq = collectSubSeq;
            this.id = ID_SEQ.incrementAndGet();
            this.done = false;
            this.valid.set(true);
            this.cancelReason.set(0);
            this.reduceFinishedCounter.set(0);
            this.reduceStartedCounter.set(0);
            this.workStealingStrategy.of(this.reduceStartedCounter);
            this.shard = rnd.nextInt(this.messageBus.getPageFrameReduceShardCount());
            this.reduceQueue = this.messageBus.getPageFrameReduceQueue(this.shard);
            this.atom.init(this.frameCursor, executionContext);
        }
        catch (TableReferenceOutOfDateException e) {
            this.frameCursor = Misc.freeIfCloseable(this.frameCursor);
            throw e;
        }
        catch (Throwable th) {
            LOG.error().$("could not initialize page frame sequence [error=").$(th).I$();
            this.frameCursor = Misc.free(this.frameCursor);
            throw th;
        }
        return this;
    }

    public void prepareForDispatch() {
        if (!this.readyToDispatch) {
            this.buildAddressCache();
            this.readyToDispatch = true;
        }
    }

    public void reset() {
        assert (!this.done);
        this.done = true;
    }

    public void toTop() {
        if (this.frameCount > 0) {
            long newId = ID_SEQ.incrementAndGet();
            LOG.debug().$("toTop [shard=").$(this.shard).$(", id=").$(this.id).$(", newId=").$(newId).I$();
            this.await();
            this.done = false;
            this.id = newId;
            this.dispatchStartFrameIndex = 0;
            this.collectedFrameIndex = -1;
            this.reduceFinishedCounter.set(0);
            this.reduceStartedCounter.set(0);
            this.workStealingStrategy.of(this.reduceStartedCounter);
            this.valid.set(true);
            this.cancelReason.set(0);
        }
    }

    private void buildAddressCache() {
        PageFrame frame;
        while ((frame = this.frameCursor.next()) != null) {
            this.frameRowCounts.add(frame.getPartitionHi() - frame.getPartitionLo());
            this.frameAddressCache.add(this.frameCount++, frame);
        }
        if (this.frameCount > 0) {
            this.messageBus.getPageFrameCollectFanOut(this.shard).and(this.collectSubSeq);
            LOG.debug().$("added [shard=").$(this.shard).$(", id=").$(this.id).$(", seqCurrent=").$(this.collectSubSeq.current()).$(", seq=").$(this.collectSubSeq).I$();
        }
    }

    private boolean dispatch() {
        boolean idle = true;
        boolean dispatched = false;
        MCSequence reduceSubSeq = this.messageBus.getPageFrameReduceSubSeq(this.shard);
        MPSequence reducePubSeq = this.messageBus.getPageFrameReducePubSeq(this.shard);
        int collectedFrameCount = this.collectedFrameIndex + 1;
        block0: for (int i = this.dispatchStartFrameIndex; i < this.frameCount; ++i) {
            long cursor;
            while (true) {
                if ((cursor = reducePubSeq.next()) > -1L) break;
                if (cursor == -1L) {
                    if (!this.workStealingStrategy.shouldSteal(collectedFrameCount)) {
                        return dispatched;
                    }
                    idle = false;
                    if (!this.stealWork(this.reduceQueue, reduceSubSeq, this.localRecord, this.workStealCircuitBreaker)) break block0;
                    if (this.reduceFinishedCounter.get() <= collectedFrameCount) continue;
                    return true;
                }
                Os.pause();
            }
            this.reduceQueue.get(cursor).of(this, i);
            LOG.debug().$("dispatched [shard=").$(this.shard).$(", id=").$(this.getId()).$(", frameIndex=").$(i).$(", frameCount=").$(this.frameCount).$(", cursor=").$(cursor).I$();
            reducePubSeq.done(cursor);
            this.dispatchStartFrameIndex = i + 1;
            dispatched = true;
        }
        if (this.reduceFinishedCounter.get() > collectedFrameCount) {
            return true;
        }
        while (this.reduceFinishedCounter.get() < this.dispatchStartFrameIndex) {
            idle = false;
            if (this.stealWork(this.reduceQueue, reduceSubSeq, this.localRecord, this.workStealCircuitBreaker) && this.isActive()) continue;
        }
        if (idle) {
            this.stealWork(this.reduceQueue, reduceSubSeq, this.localRecord, this.workStealCircuitBreaker);
        }
        return dispatched;
    }

    private boolean stealWork(RingQueue<PageFrameReduceTask> queue, MCSequence reduceSubSeq, PageFrameMemoryRecord record, SqlExecutionCircuitBreakerWrapper circuitBreaker) {
        if (PageFrameReduceJob.consumeQueue(queue, reduceSubSeq, record, circuitBreaker, this)) {
            Os.pause();
            return false;
        }
        return true;
    }

    private void workLocally() {
        assert (this.dispatchStartFrameIndex < this.frameCount);
        if (this.localTask == null) {
            this.localTask = this.localTaskFactory.getInstance();
            this.localTask.setTaskType(this.taskType);
        }
        this.localTask.of(this, this.dispatchStartFrameIndex++);
        try {
            LOG.debug().$("reducing locally [shard=").$(this.shard).$(", id=").$(this.id).$(", taskType=").$(this.taskType).$(", frameIndex=").$(this.localTask.getFrameIndex()).$(", frameCount=").$(this.frameCount).$(", active=").$(this.isActive()).I$();
            if (this.isActive()) {
                this.workStealCircuitBreaker.init(this.sqlExecutionContext.getCircuitBreaker());
                PageFrameReduceJob.reduce(this.localRecord, this.workStealCircuitBreaker, this.localTask, this, this);
            }
        }
        catch (Throwable th) {
            LOG.error().$("local reduce error [error=").$(th).$(", id=").$(this.id).$(", taskType=").$(this.taskType).$(", frameIndex=").$(this.localTask.getFrameIndex()).$(", frameCount=").$(this.frameCount).I$();
            int interruptReason = 0;
            if (th instanceof CairoException) {
                CairoException e = (CairoException)th;
                interruptReason = e.getInterruptionReason();
            }
            this.cancel(interruptReason);
            throw th;
        }
        finally {
            this.reduceFinishedCounter.incrementAndGet();
        }
    }
}

