/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.NullMemoryCMR;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectByteSequenceView;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256Impl;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.StableStringSource;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8SplitString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageFrameMemoryRecord
implements Record,
StableStringSource,
QuietCloseable,
Mutable {
    public static final byte RECORD_A_LETTER = 0;
    public static final byte RECORD_B_LETTER = 1;
    private final ObjList<BorrowedArray> arrayBuffers = new ObjList();
    private final ObjList<DirectByteSequenceView> bsViews = new ObjList();
    private final ObjList<DirectString> csViewsA = new ObjList();
    private final ObjList<DirectString> csViewsB = new ObjList();
    private final byte letter;
    private final ObjList<Long256Impl> longs256A = new ObjList();
    private final ObjList<Long256Impl> longs256B = new ObjList();
    private final ObjList<SymbolTable> symbolTableCache = new ObjList();
    private final ObjList<Utf8SplitString> utf8ViewsA = new ObjList();
    private final ObjList<Utf8SplitString> utf8ViewsB = new ObjList();
    private LongList auxPageAddresses;
    private LongList auxPageSizes;
    private byte frameFormat = (byte)-1;
    private int frameIndex = -1;
    private LongList pageAddresses;
    private LongList pageSizes;
    private long rowIdOffset;
    private long rowIndex;
    private boolean stableStrings;
    private SymbolTableSource symbolTableSource;

    public PageFrameMemoryRecord(byte letter) {
        this.letter = letter;
    }

    public PageFrameMemoryRecord(PageFrameMemoryRecord other, byte letter) {
        this.symbolTableSource = other.symbolTableSource;
        this.rowIndex = other.rowIndex;
        this.frameIndex = other.frameIndex;
        this.frameFormat = other.frameFormat;
        this.rowIdOffset = other.rowIdOffset;
        this.pageAddresses = other.pageAddresses;
        this.auxPageAddresses = other.auxPageAddresses;
        this.pageSizes = other.pageSizes;
        this.auxPageSizes = other.auxPageSizes;
        this.stableStrings = other.stableStrings;
        this.letter = letter;
    }

    @Override
    public void clear() {
        this.rowIndex = 0L;
        this.frameIndex = -1;
        this.rowIdOffset = -1L;
        this.pageAddresses = null;
        this.auxPageAddresses = null;
        this.pageSizes = null;
        this.auxPageSizes = null;
    }

    @Override
    public void close() {
        Misc.freeObjListIfCloseable(this.symbolTableCache);
        this.symbolTableCache.clear();
        Misc.freeObjList(this.arrayBuffers);
        this.clear();
    }

    @Override
    public ArrayView getArray(int columnIndex, int columnType) {
        BorrowedArray array = this.borrowedArray(columnIndex);
        long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
        if (auxPageAddress != 0L) {
            long auxPageLim = auxPageAddress + this.auxPageSizes.getQuick(columnIndex);
            long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
            long dataPageLim = dataPageAddress + this.pageSizes.getQuick(columnIndex);
            array.of(columnType, auxPageAddress, auxPageLim, dataPageAddress, dataPageLim, this.rowIndex);
        } else {
            array.ofNull();
        }
        return array;
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
        if (dataPageAddress != 0L) {
            long auxOffset;
            long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
            long auxPageLim = this.auxPageSizes.getQuick(columnIndex);
            if (auxPageLim < (auxOffset = this.rowIndex << 3) + 8L) {
                throw CairoException.critical(0).put("binary is outside of file boundary [auxOffset=").put(auxOffset).put(", auxPageLim=").put(auxPageLim).put(']');
            }
            long dataPageLim = this.pageSizes.getQuick(columnIndex);
            long dataOffset = Unsafe.getUnsafe().getLong(auxPageAddress + auxOffset);
            return this.getBin(dataPageAddress, dataOffset, dataPageLim, this.bsView(columnIndex));
        }
        return NullMemoryCMR.INSTANCE.getBin(0L);
    }

    @Override
    public long getBinLen(int columnIndex) {
        long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
        if (dataPageAddress != 0L) {
            long dataOffset;
            long auxOffset;
            long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
            long auxPageLim = this.auxPageSizes.getQuick(columnIndex);
            if (auxPageLim < (auxOffset = this.rowIndex << 3) + 8L) {
                throw CairoException.critical(0).put("binary is outside of file boundary [auxOffset=").put(auxOffset).put(", auxPageLim=").put(auxPageLim).put(']');
            }
            long dataPageLim = this.pageSizes.getQuick(columnIndex);
            if (dataPageLim < (dataOffset = Unsafe.getUnsafe().getLong(auxPageAddress + auxOffset)) + 8L) {
                throw CairoException.critical(0).put("binary is outside of file boundary [dataOffset=").put(dataOffset).put(", dataPageLim=").put(dataPageLim).put(']');
            }
            return Unsafe.getUnsafe().getLong(dataPageAddress + dataOffset);
        }
        return NullMemoryCMR.INSTANCE.getBinLen(0L);
    }

    @Override
    public boolean getBool(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getByte(address + this.rowIndex) == 1;
        }
        return NullMemoryCMR.INSTANCE.getBool(0L);
    }

    @Override
    public byte getByte(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getByte(address + this.rowIndex);
        }
        return NullMemoryCMR.INSTANCE.getByte(0L);
    }

    @Override
    public char getChar(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getChar(address + (this.rowIndex << 1));
        }
        return NullMemoryCMR.INSTANCE.getChar(0L);
    }

    @Override
    public double getDouble(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getDouble(address + (this.rowIndex << 3));
        }
        return NullMemoryCMR.INSTANCE.getDouble(0L);
    }

    @Override
    public float getFloat(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getFloat(address + (this.rowIndex << 2));
        }
        return NullMemoryCMR.INSTANCE.getFloat(0L);
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public byte getGeoByte(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getByte(address + this.rowIndex);
        }
        return -1;
    }

    @Override
    public int getGeoInt(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getInt(address + (this.rowIndex << 2));
        }
        return -1;
    }

    @Override
    public long getGeoLong(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getLong(address + (this.rowIndex << 3));
        }
        return -1L;
    }

    @Override
    public short getGeoShort(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getShort(address + (this.rowIndex << 1));
        }
        return -1;
    }

    @Override
    public int getIPv4(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getInt(address + (this.rowIndex << 2));
        }
        return NullMemoryCMR.INSTANCE.getIPv4(0L);
    }

    @Override
    public int getInt(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getInt(address + (this.rowIndex << 2));
        }
        return NullMemoryCMR.INSTANCE.getInt(0L);
    }

    public byte getLetter() {
        return this.letter;
    }

    @Override
    public long getLong(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getLong(address + (this.rowIndex << 3));
        }
        return NullMemoryCMR.INSTANCE.getLong(0L);
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getLong(address + (this.rowIndex << 4) + 8L);
        }
        return NullMemoryCMR.INSTANCE.getLong128Hi();
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getLong(address + (this.rowIndex << 4));
        }
        return NullMemoryCMR.INSTANCE.getLong128Lo();
    }

    @Override
    public void getLong256(int columnIndex, CharSink<?> sink) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            this.getLong256(address + this.rowIndex * 32L, sink);
            return;
        }
        NullMemoryCMR.INSTANCE.getLong256(0L, sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        Long256Impl long256 = this.long256A(columnIndex);
        this.getLong256(columnIndex, long256);
        return long256;
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        Long256Impl long256 = this.long256B(columnIndex);
        this.getLong256(columnIndex, long256);
        return long256;
    }

    @Override
    public long getLongIPv4(int columnIndex) {
        return Numbers.ipv4ToLong(this.getIPv4(columnIndex));
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(this.frameIndex, this.rowIndex);
    }

    public long getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public short getShort(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        if (address != 0L) {
            return Unsafe.getUnsafe().getShort(address + (this.rowIndex << 1));
        }
        return NullMemoryCMR.INSTANCE.getShort(0L);
    }

    @Override
    public CharSequence getStrA(int columnIndex) {
        return this.getStr0(columnIndex, this.csViewA(columnIndex));
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        return this.getStr0(columnIndex, this.csViewB(columnIndex));
    }

    @Override
    public int getStrLen(int columnIndex) {
        long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
        if (dataPageAddress != 0L) {
            long dataOffset;
            long auxOffset;
            long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
            long auxPageLim = this.auxPageSizes.getQuick(columnIndex);
            if (auxPageLim < (auxOffset = this.rowIndex << 3) + 8L) {
                throw CairoException.critical(0).put("string is outside of file boundary [auxOffset=").put(auxOffset).put(", auxPageLim=").put(auxPageLim).put(']');
            }
            long dataPageLim = this.pageSizes.getQuick(columnIndex);
            if (dataPageLim < (dataOffset = Unsafe.getUnsafe().getLong(auxPageAddress + auxOffset)) + 4L) {
                throw CairoException.critical(0).put("string is outside of file boundary [dataOffset=").put(dataOffset).put(", dataPageLim=").put(dataPageLim).put(']');
            }
            return Unsafe.getUnsafe().getInt(dataPageAddress + dataOffset);
        }
        return NullMemoryCMR.INSTANCE.getStrLen(0L);
    }

    @Override
    public CharSequence getSymA(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        int key = NullMemoryCMR.INSTANCE.getInt(0L);
        if (address != 0L) {
            key = Unsafe.getUnsafe().getInt(address + (this.rowIndex << 2));
        }
        return this.getSymbolTable(columnIndex).valueOf(key);
    }

    @Override
    public CharSequence getSymB(int columnIndex) {
        long address = this.pageAddresses.getQuick(columnIndex);
        int key = Unsafe.getUnsafe().getInt(address + (this.rowIndex << 2));
        return this.getSymbolTable(columnIndex).valueBOf(key);
    }

    @Override
    public long getUpdateRowId() {
        return this.rowIdOffset + this.rowIndex;
    }

    @Override
    public Utf8Sequence getVarcharA(int columnIndex) {
        return this.getVarchar(columnIndex, this.utf8ViewA(columnIndex));
    }

    @Override
    public Utf8Sequence getVarcharB(int columnIndex) {
        return this.getVarchar(columnIndex, this.utf8ViewB(columnIndex));
    }

    @Override
    public int getVarcharSize(int columnIndex) {
        long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
        if (auxPageAddress != 0L) {
            return VarcharTypeDriver.getValueSize(auxPageAddress, this.rowIndex);
        }
        return -1;
    }

    public void init(PageFrameMemory frameMemory) {
        this.frameIndex = frameMemory.getFrameIndex();
        this.frameFormat = frameMemory.getFrameFormat();
        this.stableStrings = this.frameFormat == 0;
        this.rowIdOffset = frameMemory.getRowIdOffset();
        this.pageAddresses = frameMemory.getPageAddresses();
        this.auxPageAddresses = frameMemory.getAuxPageAddresses();
        this.pageSizes = frameMemory.getPageSizes();
        this.auxPageSizes = frameMemory.getAuxPageSizes();
    }

    @Override
    public boolean isStable() {
        return this.stableStrings;
    }

    public void of(SymbolTableSource symbolTableSource) {
        this.close();
        this.symbolTableSource = symbolTableSource;
    }

    public void setRowIndex(long rowIndex) {
        this.rowIndex = rowIndex;
    }

    @NotNull
    private BorrowedArray borrowedArray(int columnIndex) {
        BorrowedArray array = this.arrayBuffers.getQuiet(columnIndex);
        if (array != null) {
            return array;
        }
        array = new BorrowedArray();
        this.arrayBuffers.extendAndSet(columnIndex, array);
        return array;
    }

    @NotNull
    private DirectByteSequenceView bsView(int columnIndex) {
        DirectByteSequenceView view = this.bsViews.getQuiet(columnIndex);
        if (view != null) {
            return view;
        }
        view = new DirectByteSequenceView();
        this.bsViews.extendAndSet(columnIndex, view);
        return view;
    }

    @NotNull
    private DirectString csViewA(int columnIndex) {
        DirectString view = this.csViewsA.getQuiet(columnIndex);
        if (view != null) {
            return view;
        }
        view = new DirectString(this);
        this.csViewsA.extendAndSet(columnIndex, view);
        return view;
    }

    @NotNull
    private DirectString csViewB(int columnIndex) {
        DirectString view = this.csViewsB.getQuiet(columnIndex);
        if (view != null) {
            return view;
        }
        view = new DirectString(this);
        this.csViewsB.extendAndSet(columnIndex, view);
        return view;
    }

    private BinarySequence getBin(long base, long offset, long dataLim, DirectByteSequenceView view) {
        long address = base + offset;
        long len = Unsafe.getUnsafe().getLong(address);
        if (len != -1L) {
            if (dataLim < offset + len + 8L) {
                throw CairoException.critical(0).put("binary is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", dataLim=").put(dataLim).put(']');
            }
            return view.of(address + 8L, len);
        }
        return null;
    }

    private void getLong256(int columnIndex, Long256Acceptor sink) {
        long columnAddress = this.pageAddresses.getQuick(columnIndex);
        if (columnAddress != 0L) {
            sink.fromAddress(columnAddress + (this.rowIndex << 5));
            return;
        }
        NullMemoryCMR.INSTANCE.getLong256(0L, sink);
    }

    private void getLong256(long addr, CharSink<?> sink) {
        Numbers.appendLong256FromUnsafe(addr, sink);
    }

    private DirectString getStr(long base, long offset, long dataLim, DirectString view) {
        long address = base + offset;
        int len = Unsafe.getUnsafe().getInt(address);
        if (len != -1) {
            if (dataLim < offset + (long)len + 4L) {
                throw CairoException.critical(0).put("string is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", dataLim=").put(dataLim).put(']');
            }
            return view.of(address + 4L, len);
        }
        return null;
    }

    private CharSequence getStr0(int columnIndex, DirectString csView) {
        long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
        if (dataPageAddress != 0L) {
            long auxOffset;
            long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
            long auxPageLim = this.auxPageSizes.getQuick(columnIndex);
            if (auxPageLim < (auxOffset = this.rowIndex << 3) + 8L) {
                throw CairoException.critical(0).put("string is outside of file boundary [auxOffset=").put(auxOffset).put(", auxPageLim=").put(auxPageLim).put(']');
            }
            long dataPageLim = this.pageSizes.getQuick(columnIndex);
            long dataOffset = Unsafe.getUnsafe().getLong(auxPageAddress + auxOffset);
            return this.getStr(dataPageAddress, dataOffset, dataPageLim, csView);
        }
        return NullMemoryCMR.INSTANCE.getStrB(0L);
    }

    private SymbolTable getSymbolTable(int columnIndex) {
        SymbolTable symbolTable = this.symbolTableCache.getQuiet(columnIndex);
        if (symbolTable == null) {
            symbolTable = this.symbolTableSource.newSymbolTable(columnIndex);
            this.symbolTableCache.extendAndSet(columnIndex, symbolTable);
        }
        return symbolTable;
    }

    @Nullable
    private Utf8Sequence getVarchar(int columnIndex, Utf8SplitString utf8View) {
        long auxPageAddress = this.auxPageAddresses.getQuick(columnIndex);
        if (auxPageAddress != 0L) {
            long auxPageLim = auxPageAddress + this.auxPageSizes.getQuick(columnIndex);
            long dataPageAddress = this.pageAddresses.getQuick(columnIndex);
            long dataPageLim = dataPageAddress + this.pageSizes.getQuick(columnIndex);
            return VarcharTypeDriver.getSplitValue(auxPageAddress, auxPageLim, dataPageAddress, dataPageLim, this.rowIndex, utf8View);
        }
        return null;
    }

    @NotNull
    private Long256Impl long256A(int columnIndex) {
        Long256Impl long256 = this.longs256A.getQuiet(columnIndex);
        if (long256 != null) {
            return long256;
        }
        long256 = new Long256Impl();
        this.longs256A.extendAndSet(columnIndex, long256);
        return long256;
    }

    @NotNull
    private Long256Impl long256B(int columnIndex) {
        Long256Impl long256 = this.longs256B.getQuiet(columnIndex);
        if (long256 != null) {
            return long256;
        }
        long256 = new Long256Impl();
        this.longs256B.extendAndSet(columnIndex, long256);
        return long256;
    }

    @NotNull
    private Utf8SplitString utf8ViewA(int columnIndex) {
        Utf8SplitString view = this.utf8ViewsA.getQuiet(columnIndex);
        if (view != null) {
            return view;
        }
        view = new Utf8SplitString(this);
        this.utf8ViewsA.extendAndSet(columnIndex, view);
        return view;
    }

    @NotNull
    private Utf8SplitString utf8ViewB(int columnIndex) {
        Utf8SplitString view = this.utf8ViewsB.getQuiet(columnIndex);
        if (view != null) {
            return view;
        }
        view = new Utf8SplitString(this);
        this.utf8ViewsB.extendAndSet(columnIndex, view);
        return view;
    }

    void init(int frameIndex, byte frameFormat, long rowIdOffset, LongList pageAddresses, LongList auxPageAddresses, LongList pageLimits, LongList auxPageLimits) {
        this.frameIndex = frameIndex;
        this.frameFormat = frameFormat;
        this.stableStrings = frameFormat == 0;
        this.rowIdOffset = rowIdOffset;
        this.pageAddresses = pageAddresses;
        this.auxPageAddresses = auxPageAddresses;
        this.pageSizes = pageLimits;
        this.auxPageSizes = auxPageLimits;
    }
}

