/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.frm.DeletedFrameColumn;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.FrameColumnTypePool;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.std.Misc;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.str.Path;

public class FrameImpl
implements Frame {
    private final FrameColumnPool columnPool;
    private boolean canWrite = false;
    private ReadOnlyObjList<? extends MemoryCR> columnsMemory;
    private boolean create = false;
    private ColumnVersionReader crv;
    private RecycleBin<FrameImpl> frameRecycleBin;
    private int frameType;
    private RecordMetadata metadata;
    private long offset = 0L;
    private Path partitionPath = new Path();
    private long partitionTimestamp;
    private long rowCount;

    public FrameImpl(FrameColumnPool columnPool) {
        this.columnPool = columnPool;
    }

    @Override
    public void close() {
        this.columnsMemory = null;
        this.crv = null;
        if (this.frameRecycleBin != null && !this.frameRecycleBin.isClosed()) {
            this.frameRecycleBin.put(this);
        } else {
            this.free();
        }
    }

    @Override
    public int columnCount() {
        return this.metadata.getColumnCount();
    }

    @Override
    public FrameColumn createColumn(int columnIndex) {
        if (this.frameType == 0) {
            return this.getContiguousFileFrameColumn(columnIndex);
        }
        if (this.frameType == 1) {
            return this.getMemoryFrameColumn(columnIndex);
        }
        throw CairoException.critical(0).put("unknown frame type [type=").put(this.frameType).put(", partitionPath=").put(this.partitionPath).put(']');
    }

    public void createROFromMemoryColumns(ReadOnlyObjList<? extends MemoryCR> columns, TableWriterMetadata metadata, long size) {
        this.metadata = metadata;
        this.crv = null;
        this.rowCount = size;
        this.partitionTimestamp = Long.MIN_VALUE;
        this.partitionPath.of(this.partitionPath);
        this.canWrite = false;
        this.create = false;
        this.frameType = 1;
        assert (columns.size() == metadata.getColumnCount() * 2);
        this.columnsMemory = columns;
    }

    public void createRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        this.metadata = metadata;
        this.crv = cvw;
        this.rowCount = size;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(partitionPath);
        this.canWrite = true;
        this.create = true;
        this.frameType = 0;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    public void openRO(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionReader cvr, long partitionRowCount) {
        this.metadata = metadata;
        this.crv = cvr;
        this.rowCount = partitionRowCount;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(partitionPath);
        this.canWrite = false;
        this.create = false;
        this.frameType = 0;
    }

    public void openRO(Path tablePath, long partitionTimestamp, long partitionNameTxn, int partitionBy, RecordMetadata metadata, ColumnVersionReader cvr, long partitionRowCount) {
        this.metadata = metadata;
        this.crv = cvr;
        this.rowCount = partitionRowCount;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(tablePath);
        TableUtils.setSinkForNativePartition(this.partitionPath.slash(), partitionBy, partitionTimestamp, partitionNameTxn);
        this.canWrite = false;
        this.create = false;
        this.frameType = 0;
    }

    public void openRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        this.metadata = metadata;
        this.crv = cvw;
        this.rowCount = size;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(partitionPath);
        this.canWrite = true;
        this.create = false;
        this.frameType = 0;
    }

    @Override
    public void saveChanges(FrameColumn frameColumn) {
        if (!this.canWrite) {
            throw CairoException.critical(0).put("cannot save column top, partition frame is read-only [path=").put(this.partitionPath).put(']');
        }
        ColumnVersionWriter cvw = (ColumnVersionWriter)this.crv;
        cvw.upsertColumnTop(this.partitionTimestamp, frameColumn.getColumnIndex(), frameColumn.getColumnTop());
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    private void free() {
        this.partitionPath = Misc.free(this.partitionPath);
    }

    private FrameColumn getContiguousFileFrameColumn(int columnIndex) {
        int columnType = this.metadata.getColumnType(columnIndex);
        if (columnType < 0) {
            return DeletedFrameColumn.INSTANCE;
        }
        boolean isIndexed = this.metadata.isColumnIndexed(columnIndex);
        int indexBlockCapacity = isIndexed ? this.metadata.getIndexValueBlockCapacity(columnIndex) : 0;
        int crvRecIndex = this.crv.getRecordIndex(this.partitionTimestamp, columnIndex);
        long columnTop = this.crv.getColumnTopByIndexOrDefault(crvRecIndex, this.partitionTimestamp, columnIndex, this.rowCount);
        long columnTxn = this.crv.getColumnNameTxn(this.partitionTimestamp, columnIndex);
        FrameColumnTypePool columnTypePool = this.columnPool.getPool(columnType);
        boolean createNew = columnTop >= this.rowCount || this.create;
        columnTop = Math.min(columnTop, this.rowCount);
        return columnTypePool.create(this.partitionPath, this.metadata.getColumnName(columnIndex), columnTxn, columnType, indexBlockCapacity, columnTop, columnIndex, createNew, this.canWrite);
    }

    private FrameColumn getMemoryFrameColumn(int columnIndex) {
        int columnType = this.metadata.getColumnType(columnIndex);
        if (columnType < 0) {
            return DeletedFrameColumn.INSTANCE;
        }
        FrameColumnTypePool columnTypePool = this.columnPool.getPool(columnType);
        return columnTypePool.createFromMemoryColumn(columnIndex, columnType, this.rowCount, this.columnsMemory.get(TableWriter.getPrimaryColumnIndex(columnIndex)), this.columnsMemory.get(TableWriter.getSecondaryColumnIndex(columnIndex)));
    }

    void setRecycleBin(RecycleBin<FrameImpl> frameRecycleBin) {
        this.frameRecycleBin = frameRecycleBin;
    }
}

