/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.file.ContiguousFileColumnPool;
import io.questdb.cairo.frm.file.FrameImpl;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.mp.ConcurrentPool;
import io.questdb.std.Misc;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class FrameFactory
implements RecycleBin<FrameImpl>,
Closeable {
    private final FrameColumnPool columnPool;
    private final ConcurrentPool<FrameImpl> framePool = new ConcurrentPool();
    private boolean closed;

    public FrameFactory(CairoConfiguration configuration) {
        this.columnPool = new ContiguousFileColumnPool(configuration);
    }

    public void clear() {
        FrameImpl t;
        this.closed = true;
        while ((t = this.framePool.pop()) != null) {
            Misc.free(t);
        }
        this.closed = false;
    }

    @Override
    public void close() {
        this.closed = true;
        Misc.free(this.columnPool);
        this.clear();
    }

    public Frame createRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        FrameImpl frame = this.getOrCreate();
        frame.createRW(partitionPath, partitionTimestamp, metadata, cvw, size);
        return frame;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public Frame open(boolean rw, Path path, long targetPartition, RecordMetadata metadata, ColumnVersionWriter cvr, long size) {
        if (rw) {
            return this.openRW(path, targetPartition, metadata, cvr, size);
        }
        return this.openRO(path, targetPartition, metadata, cvr, size);
    }

    public Frame openROFromMemoryColumns(ReadOnlyObjList<? extends MemoryCR> columns, TableWriterMetadata metadata, long rowCount) {
        FrameImpl frame = this.getOrCreate();
        frame.createROFromMemoryColumns(columns, metadata, rowCount);
        return frame;
    }

    public Frame openRO(Path tablePath, long partitionTimestamp, long partitionNameTxn, int partitionBy, RecordMetadata metadata, ColumnVersionReader cvr, long partitionRowCount) {
        FrameImpl frame = this.getOrCreate();
        frame.openRO(tablePath, partitionTimestamp, partitionNameTxn, partitionBy, metadata, cvr, partitionRowCount);
        return frame;
    }

    public Frame openRO(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionReader cvr, long partitionRowCount) {
        FrameImpl frame = this.getOrCreate();
        frame.openRO(partitionPath, partitionTimestamp, metadata, cvr, partitionRowCount);
        return frame;
    }

    public Frame openRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        FrameImpl frame = this.getOrCreate();
        frame.openRW(partitionPath, partitionTimestamp, metadata, cvw, size);
        return frame;
    }

    @Override
    public void put(FrameImpl frame) {
        assert (!this.isClosed());
        this.framePool.push(frame);
    }

    private FrameImpl getOrCreate() {
        FrameImpl frm = this.framePool.pop();
        if (frm != null) {
            return frm;
        }
        FrameImpl frame = new FrameImpl(this.columnPool);
        frame.setRecycleBin(this);
        return frame;
    }
}

