/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;

public class DebugUtils {
    public static final Log LOG = LogFactory.getLog(DebugUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAscendingTimestamp(FilesFacade ff, long size, long fd) {
        if (size > 0L) {
            long buffer = TableUtils.mapAppendColumnBuffer(ff, fd, 0L, size * 8L, false, 0);
            try {
                long ts = Long.MIN_VALUE;
                int i = 0;
                while ((long)i < size) {
                    long nextTs = Unsafe.getUnsafe().getLong(buffer + (long)i * 8L);
                    if (nextTs < ts) {
                        boolean bl = false;
                        return bl;
                    }
                    ts = nextTs;
                    ++i;
                }
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(ff, buffer, 0L, size * 8L, 0);
            }
        }
        return true;
    }

    public static boolean isSparseVarCol(long colRowCount, long auxMemAddr, long dataMemAddr, int colType) {
        return ColumnType.getDriver(colType).isSparseDataVector(auxMemAddr, dataMemAddr, colRowCount);
    }

    public static boolean reconcileColumnTops(int partitionsSlotSize, LongList openPartitionInfo, ColumnVersionReader columnVersionReader, TableReader reader) {
        int partitionCount = reader.getPartitionCount();
        for (int p = 0; p < partitionCount; ++p) {
            long partitionRowCount = reader.getPartitionRowCount(p);
            if (partitionRowCount == -1L) continue;
            long partitionTimestamp = openPartitionInfo.getQuick(p * partitionsSlotSize);
            for (int c = 0; c < reader.getColumnCount(); ++c) {
                long colTop = Math.min(reader.getColumnTop(reader.getColumnBase(p), c), partitionRowCount);
                long columnTopRaw = columnVersionReader.getColumnTop(partitionTimestamp, c);
                long columnTop = Math.min(columnTopRaw == -1L ? partitionRowCount : columnTopRaw, partitionRowCount);
                if (columnTop == colTop) continue;
                LOG.critical().$("failed to reconcile column top [partition=").$ts(partitionTimestamp).$(", column=").$(c).$(", expected=").$(columnTop).$(", actual=").$(colTop).$(']').$();
                return false;
            }
        }
        return true;
    }

    static void assertO3IndexSorted(long indexAddr, long indexSize) {
        long lastTs = Long.MIN_VALUE;
        for (long i = 0L; i < indexSize; ++i) {
            long ts = Unsafe.getUnsafe().getLong(indexAddr + 16L * i);
            long rowId = Unsafe.getUnsafe().getLong(indexAddr + 16L * i + 8L);
            assert (ts >= lastTs) : String.format("ts %,d lastTs %,d rowId %,d", ts, lastTs, rowId);
            lastTs = ts;
        }
    }

    static void assertTimestampColumnSorted(long columnAddr, long columnSize) {
        long lastTs = Long.MIN_VALUE;
        for (long i = 0L; i < columnSize; ++i) {
            long ts = Unsafe.getUnsafe().getLong(columnAddr + 8L * i);
            assert (ts >= lastTs) : String.format("ts %,d lastTs %,d", ts, lastTs);
            lastTs = ts;
        }
    }

    static void logO3Index(long indexAddr, long indexSize, long tailLen) {
        long start;
        for (long i = start = Math.max(0L, indexSize - tailLen); i < indexSize; ++i) {
            long ts = Unsafe.getUnsafe().getLong(indexAddr + 16L * i);
            long rowId = Unsafe.getUnsafe().getLong(indexAddr + 16L * i + 8L);
            LOG.info().$("index [").$(i).$("] = ").$ts(ts).$(", ts=").$(ts).$(", rowId=").$(rowId).$();
        }
    }

    static void logTimestampColumn(long colAddr, long colSize, long tailLen) {
        long start;
        for (long i = start = Math.max(0L, colSize - tailLen); i < colSize; ++i) {
            long ts = Unsafe.getUnsafe().getLong(colAddr + 8L * i);
            LOG.info().$("ts_col [").$(i).$("] = ").$ts(ts).$(", ts=").$(ts).$();
        }
    }
}

