/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;

public abstract class AbstractRecordMetadata
implements RecordMetadata,
Mutable {
    protected final ObjList<TableColumnMetadata> columnMetadata = new ObjList();
    protected final LowerCaseCharSequenceIntHashMap columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    protected int columnCount;
    protected int timestampIndex = -1;

    @Override
    public void clear() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        int index = this.columnNameIndexMap.keyIndex(columnName, lo, hi);
        if (index < 0) {
            return this.columnNameIndexMap.valueAt(index);
        }
        return -1;
    }

    @Override
    public TableColumnMetadata getColumnMetadata(int index) {
        return this.columnMetadata.getQuick(index);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getColumnName();
    }

    @Override
    public int getColumnType(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getColumnType();
    }

    @Override
    public int getIndexValueBlockCapacity(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getIndexValueBlockCapacity();
    }

    @Override
    public RecordMetadata getMetadata(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getMetadata();
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    @Override
    public int getWriterIndex(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getWriterIndex();
    }

    @Override
    public boolean hasColumn(int columnIndex) {
        TableColumnMetadata columnMeta = this.columnMetadata.getQuiet(columnIndex);
        return columnMeta != null && !columnMeta.isDeleted();
    }

    @Override
    public boolean isColumnIndexed(int columnIndex) {
        return this.getColumnMetadata(columnIndex).isSymbolIndexFlag();
    }

    @Override
    public boolean isDedupKey(int columnIndex) {
        return this.getColumnMetadata(columnIndex).isDedupKeyFlag();
    }

    @Override
    public boolean isSymbolTableStatic(int columnIndex) {
        return this.getColumnMetadata(columnIndex).isSymbolTableStatic();
    }
}

