/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.health;

import com.ecwid.consul.ConsulRequest;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.v1.NodeMetaParameters;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.TagsParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HealthServicesRequest
implements ConsulRequest {
    private final String datacenter;
    private final String near;
    private final String[] tags;
    private final Map<String, String> nodeMeta;
    private final boolean passing;
    private final QueryParams queryParams;
    private final String token;

    private HealthServicesRequest(String datacenter, String near, String[] tags, Map<String, String> nodeMeta, boolean passing, QueryParams queryParams, String token) {
        this.datacenter = datacenter;
        this.near = near;
        this.tags = tags;
        this.nodeMeta = nodeMeta;
        this.passing = passing;
        this.queryParams = queryParams;
        this.token = token;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getNear() {
        return this.near;
    }

    public String getTag() {
        return this.tags != null && this.tags.length > 0 ? this.tags[0] : null;
    }

    public String[] getTags() {
        return this.tags;
    }

    public Map<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public boolean isPassing() {
        return this.passing;
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    public String getToken() {
        return this.token;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public List<UrlParameters> asUrlParameters() {
        ArrayList<UrlParameters> params = new ArrayList<UrlParameters>();
        if (this.datacenter != null) {
            params.add(new SingleUrlParameters("dc", this.datacenter));
        }
        if (this.near != null) {
            params.add(new SingleUrlParameters("near", this.near));
        }
        if (this.tags != null) {
            params.add(new TagsParameters(this.tags));
        }
        if (this.nodeMeta != null) {
            params.add(new NodeMetaParameters(this.nodeMeta));
        }
        params.add(new SingleUrlParameters("passing", String.valueOf(this.passing)));
        if (this.queryParams != null) {
            params.add(this.queryParams);
        }
        if (this.token != null) {
            params.add(new SingleUrlParameters("token", this.token));
        }
        return params;
    }

    public static class Builder {
        private String datacenter;
        private String near;
        private String[] tags;
        private Map<String, String> nodeMeta;
        private boolean passing;
        private QueryParams queryParams;
        private String token;

        private Builder() {
        }

        public Builder setDatacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder setNear(String near) {
            this.near = near;
            return this;
        }

        public Builder setTag(String tag) {
            this.tags = new String[]{tag};
            return this;
        }

        public Builder setTags(String[] tags) {
            this.tags = tags;
            return this;
        }

        public Builder setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta != null ? Collections.unmodifiableMap(nodeMeta) : null;
            return this;
        }

        public Builder setPassing(boolean passing) {
            this.passing = passing;
            return this;
        }

        public Builder setQueryParams(QueryParams queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public HealthServicesRequest build() {
            return new HealthServicesRequest(this.datacenter, this.near, this.tags, this.nodeMeta, this.passing, this.queryParams, this.token);
        }
    }
}

