/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionWALCleaner
extends MasterRegionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionWALCleaner.class);
    private static long TTL_MS = 5000L;
    private LogCleaner logCleaner;
    private Path globalWALArchiveDir;

    @Override
    protected void postSetUp() throws IOException {
        Configuration conf = this.htu.getConfiguration();
        conf.setLong("hbase.master.local.store.walcleaner.ttl", TTL_MS);
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(conf);
        this.globalWALArchiveDir = new Path(testDir, "oldWALs");
        this.logCleaner = new LogCleaner(1000, new Stoppable(){
            private volatile boolean stopped = false;

            public void stop(String why) {
                this.stopped = true;
            }

            public boolean isStopped() {
                return this.stopped;
            }
        }, conf, fs, this.globalWALArchiveDir, this.logCleanerPool, null);
        this.choreService.scheduleChore((ScheduledChore)this.logCleaner);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        this.region.update(r -> r.put(new Put(Bytes.toBytes((int)1)).addColumn(CF1, QUALIFIER, Bytes.toBytes((int)1))));
        this.region.flush(true);
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertFalse((boolean)fs.exists(this.globalWALArchiveDir));
        this.region.requestRollAll();
        this.region.waitUntilWalRollFinished();
        FileStatus[] files = fs.listStatus(this.globalWALArchiveDir);
        Assert.assertEquals((long)1L, (long)files.length);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)fs.exists(files[0].getPath()));
        Thread.sleep(6000L);
        Assert.assertEquals((long)0L, (long)fs.listStatus(this.globalWALArchiveDir).length);
    }
}

